/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.world.item.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import novamachina.exnihilosequentia.world.item.crafting.EXNRecipeSerializers;
import novamachina.exnihilosequentia.world.item.crafting.EXNRecipeTypes;
import novamachina.exnihilosequentia.world.level.block.EXNBlocks;
import novamachina.novacore.world.item.crafting.Recipe;
import org.checkerframework.checker.nullness.qual.NonNull;

public class HeatRecipe
extends Recipe {
    private final int amount;
    private final Block inputBlock;
    private final StatePropertiesPredicate properties;

    public HeatRecipe(ResourceLocation id, Block inputBlock, int amount, StatePropertiesPredicate properties) {
        super(id);
        this.inputBlock = inputBlock;
        this.amount = amount;
        this.properties = properties;
    }

    public boolean isMatch(@NonNull BlockState state) {
        if (this.inputBlock == null) {
            return false;
        }
        ResourceLocation resourceLocation = ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_());
        if (resourceLocation == null) {
            return false;
        }
        if (this.inputBlock != null) {
            return state.m_60713_(this.inputBlock) && (this.properties == null || this.properties.m_67667_(state));
        }
        return false;
    }

    public @NonNull ItemStack m_8042_() {
        return EXNBlocks.FIRED_CRUCIBLE.itemStack();
    }

    public @NonNull RecipeSerializer<?> m_7707_() {
        return EXNRecipeSerializers.HEAT_RECIPE_SERIALIZER.recipeSerializer();
    }

    public @NonNull RecipeType<?> m_6671_() {
        return EXNRecipeTypes.HEAT;
    }

    private boolean hasProperties() {
        return this.properties != StatePropertiesPredicate.f_67658_;
    }

    public void write(FriendlyByteBuf buffer) {
        int length = ForgeRegistries.BLOCKS.getKey((Object)this.inputBlock).toString().length();
        buffer.writeInt(length);
        buffer.m_130072_(ForgeRegistries.BLOCKS.getKey((Object)this.inputBlock).toString(), length);
        buffer.writeInt(this.amount);
        buffer.writeBoolean(this.hasProperties());
        if (this.hasProperties()) {
            buffer.m_130070_(this.properties.m_67666_().toString());
        }
    }

    public int getAmount() {
        return this.amount;
    }

    public Block getInputBlock() {
        return this.inputBlock;
    }

    public StatePropertiesPredicate getProperties() {
        return this.properties;
    }

    public static class Serializer<T extends HeatRecipe>
    implements RecipeSerializer<T> {
        private final IBlockFactory<T> blockFactory;

        public Serializer(IBlockFactory<T> blockFactory) {
            this.blockFactory = blockFactory;
        }

        public @NonNull T fromJson(@NonNull ResourceLocation id, JsonObject json) {
            Block inputBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(json.get("block").getAsString()));
            int amount = json.get("amount").getAsInt();
            if (json.has("state")) {
                return (T)((Object)((HeatRecipe)((Object)this.blockFactory.create(id, inputBlock, amount, StatePropertiesPredicate.m_67679_((JsonElement)json.get("state"))))));
            }
            return (T)((Object)((HeatRecipe)((Object)this.blockFactory.create(id, inputBlock, amount, StatePropertiesPredicate.f_67658_))));
        }

        public T fromNetwork(@NonNull ResourceLocation id, FriendlyByteBuf buffer) {
            int length = buffer.readInt();
            Block inputBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(buffer.m_130136_(length)));
            int amount = buffer.readInt();
            boolean hasProperties = buffer.readBoolean();
            if (hasProperties) {
                StatePropertiesPredicate properties = StatePropertiesPredicate.m_67679_((JsonElement)JsonParser.parseString((String)buffer.m_130277_()));
                return (T)((Object)((HeatRecipe)((Object)this.blockFactory.create(id, inputBlock, amount, properties))));
            }
            return (T)((Object)((HeatRecipe)((Object)this.blockFactory.create(id, inputBlock, amount, StatePropertiesPredicate.f_67658_))));
        }

        public void toNetwork(@NonNull FriendlyByteBuf buffer, T recipe) {
            ((HeatRecipe)((Object)recipe)).write(buffer);
        }

        @FunctionalInterface
        public static interface IBlockFactory<T> {
            public T create(ResourceLocation var1, Block var2, int var3, StatePropertiesPredicate var4);
        }
    }
}

