/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.world.item.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import novamachina.exnihilosequentia.world.item.crafting.EXNRecipeSerializers;
import novamachina.exnihilosequentia.world.item.crafting.EXNRecipeTypes;
import novamachina.exnihilosequentia.world.level.block.EXNBlocks;
import novamachina.novacore.util.FluidStackUtils;
import novamachina.novacore.util.ItemStackHelper;
import novamachina.novacore.world.item.crafting.Recipe;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrecipitateRecipe
extends Recipe {
    private final Ingredient input;
    private final FluidStack fluid;
    private final ItemStack output;

    public PrecipitateRecipe(@Nonnull ResourceLocation id, @Nonnull FluidStack fluid, @Nonnull Ingredient input, @Nonnull ItemStack output) {
        super(id);
        this.input = input;
        this.fluid = fluid;
        this.output = output;
    }

    public boolean validInputs(Fluid fluid, ItemLike input) {
        return this.fluid.getFluid().m_6212_(fluid) && this.input.test(new ItemStack(input));
    }

    public void write(FriendlyByteBuf buffer) {
        this.input.m_43923_(buffer);
        this.fluid.writeToPacket(buffer);
        buffer.m_130055_(this.output);
    }

    @NotNull
    public ItemStack m_8042_() {
        return EXNBlocks.OAK_BARREL.itemStack();
    }

    public @NonNull RecipeSerializer<?> m_7707_() {
        return EXNRecipeSerializers.PRECIPITATE_RECIPE_SERIALIZER.recipeSerializer();
    }

    public @NonNull RecipeType<?> m_6671_() {
        return EXNRecipeTypes.PRECIPITATE;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public static class Serializer<T extends PrecipitateRecipe>
    implements RecipeSerializer<T> {
        private final IFactory<T> factory;

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
        }

        public @NonNull T fromJson(@NonNull ResourceLocation id, JsonObject json) {
            Ingredient input = Ingredient.m_43917_((JsonElement)json.get("input"));
            FluidStack fluid = FluidStackUtils.deserialize((JsonObject)json.getAsJsonObject("fluid"));
            ItemStack result = ItemStackHelper.deserialize((JsonElement)json.get("result"));
            return (T)((Object)((PrecipitateRecipe)((Object)this.factory.create(id, fluid, input, result))));
        }

        @Nullable
        public T fromNetwork(@NonNull ResourceLocation id, @NonNull FriendlyByteBuf buffer) {
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            FluidStack fluid = FluidStack.readFromPacket((FriendlyByteBuf)buffer);
            ItemStack result = buffer.m_130267_();
            return (T)((Object)((PrecipitateRecipe)((Object)this.factory.create(id, fluid, input, result))));
        }

        public void toNetwork(@NonNull FriendlyByteBuf buffer, T recipe) {
            ((PrecipitateRecipe)((Object)recipe)).write(buffer);
        }

        @FunctionalInterface
        public static interface IFactory<T> {
            public T create(ResourceLocation var1, FluidStack var2, Ingredient var3, ItemStack var4);
        }
    }
}

