/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.world.item.crafting;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import novamachina.exnihilosequentia.world.item.MeshType;
import novamachina.exnihilosequentia.world.item.crafting.EXNRecipeSerializers;
import novamachina.exnihilosequentia.world.item.crafting.EXNRecipeTypes;
import novamachina.exnihilosequentia.world.item.crafting.MeshWithChance;
import novamachina.exnihilosequentia.world.level.block.EXNBlocks;
import novamachina.novacore.world.item.crafting.Recipe;
import org.checkerframework.checker.nullness.qual.NonNull;

public class SiftingRecipe
extends Recipe {
    private final Ingredient input;
    private final ItemStack drop;
    private final boolean isWaterlogged;
    private final List<MeshWithChance> rolls;

    public SiftingRecipe(ResourceLocation id, Ingredient input, ItemStack drop, boolean isWaterlogged, MeshWithChance ... rolls) {
        super(id);
        this.input = input;
        this.drop = drop;
        this.rolls = Lists.newArrayList((Object[])rolls);
        this.isWaterlogged = isWaterlogged;
    }

    public SiftingRecipe filterByMesh(MeshType meshType, boolean flattenRecipes) {
        ArrayList<MeshWithChance> possibleMeshes = new ArrayList<MeshWithChance>();
        for (MeshWithChance mesh : this.rolls) {
            if (flattenRecipes) {
                if (mesh.getMesh().getLevel() > meshType.getLevel()) continue;
                possibleMeshes.add(mesh);
                continue;
            }
            if (mesh.getMesh().getLevel() != meshType.getLevel()) continue;
            possibleMeshes.add(mesh);
        }
        return new SiftingRecipe(this.m_6423_(), this.input, this.drop, this.isWaterlogged, (MeshWithChance[])possibleMeshes.toArray(MeshWithChance[]::new));
    }

    public ItemStack getDrop() {
        return this.drop.m_41777_();
    }

    public @NonNull ItemStack m_8042_() {
        return EXNBlocks.OAK_SIEVE.itemStack();
    }

    public @NonNull RecipeSerializer<?> m_7707_() {
        return EXNRecipeSerializers.SIFTING_RECIPE_SERIALIZER.recipeSerializer();
    }

    public RecipeType<?> m_6671_() {
        return EXNRecipeTypes.SIFTING;
    }

    public void write(FriendlyByteBuf buffer) {
        this.input.m_43923_(buffer);
        buffer.m_130055_(this.drop);
        buffer.writeInt(this.rolls.size());
        this.rolls.forEach(roll -> roll.write(buffer));
        buffer.writeBoolean(this.isWaterlogged);
    }

    public Ingredient getInput() {
        return this.input;
    }

    public boolean isWaterlogged() {
        return this.isWaterlogged;
    }

    public List<MeshWithChance> getRolls() {
        return this.rolls;
    }

    public static class Serializer<T extends SiftingRecipe>
    implements RecipeSerializer<T> {
        private final IFactory<T> factory;

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
        }

        public @NonNull T fromJson(@NonNull ResourceLocation id, JsonObject json) {
            Ingredient input = Ingredient.m_43917_((JsonElement)json.get("input"));
            ItemStack drop = ShapedRecipe.m_151278_((JsonObject)json.getAsJsonObject("result")).m_7968_();
            ArrayList<MeshWithChance> rolls = new ArrayList<MeshWithChance>();
            for (JsonElement element : json.get("rolls").getAsJsonArray()) {
                rolls.add(MeshWithChance.deserialize(element));
            }
            if (json.has("waterlogged")) {
                return (T)((Object)((SiftingRecipe)((Object)this.factory.create(id, input, drop, json.get("waterlogged").getAsBoolean(), (MeshWithChance[])rolls.toArray(MeshWithChance[]::new)))));
            }
            return (T)((Object)((SiftingRecipe)((Object)this.factory.create(id, input, drop, false, (MeshWithChance[])rolls.toArray(MeshWithChance[]::new)))));
        }

        public T fromNetwork(@NonNull ResourceLocation id, @NonNull FriendlyByteBuf buffer) {
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack drop = buffer.m_130267_();
            int rollCount = buffer.readInt();
            ArrayList<MeshWithChance> rolls = new ArrayList<MeshWithChance>(rollCount);
            for (int i = 0; i < rollCount; ++i) {
                rolls.add(MeshWithChance.read(buffer));
            }
            boolean waterlogged = buffer.readBoolean();
            return (T)((Object)((SiftingRecipe)((Object)this.factory.create(id, input, drop, waterlogged, (MeshWithChance[])rolls.toArray(MeshWithChance[]::new)))));
        }

        public void toNetwork(@NonNull FriendlyByteBuf buffer, T recipe) {
            ((SiftingRecipe)((Object)recipe)).write(buffer);
        }

        @FunctionalInterface
        public static interface IFactory<T> {
            public T create(ResourceLocation var1, Ingredient var2, ItemStack var3, boolean var4, MeshWithChance ... var5);
        }
    }
}

