/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.world.level.block.entity;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import novamachina.exnihilosequentia.common.Config;
import novamachina.exnihilosequentia.common.registries.ExNihiloRegistries;
import novamachina.exnihilosequentia.world.item.capability.MeltableItemHandler;
import novamachina.exnihilosequentia.world.item.crafting.MeltingRecipe;
import novamachina.exnihilosequentia.world.level.material.capability.CrucibleFluidHandler;
import novamachina.novacore.util.TankUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CrucibleBlockEntity
extends BlockEntity {
    private static Logger log = LoggerFactory.getLogger(CrucibleBlockEntity.class);
    public static final int MAX_FLUID_AMOUNT = Config.getCrucibleNumberOfBuckets() * 1000;
    @Nonnull
    private static final String BLOCK_TAG = "block";
    @Nonnull
    private static final String CURRENT_ITEM_TAG = "currentItem";
    @Nonnull
    private static final String FLUID_TAG = "fluid";
    @Nonnull
    private static final String INVENTORY_TAG = "inventory";
    @Nonnull
    private static final String SOLID_AMOUNT_TAG = "solidAmount";
    @Nonnull
    protected ItemStack currentItem;
    @Nonnull
    protected MeltableItemHandler inventory;
    @Nonnull
    private final LazyOptional<IItemHandler> inventoryHolder = LazyOptional.of(() -> this.inventory);
    @Nullable
    protected BaseCrucibleTileState lastSyncedState = null;
    protected int solidAmount = 0;
    @Nonnull
    protected CrucibleFluidHandler tank;
    @Nonnull
    private final LazyOptional<IFluidHandler> tankHolder = LazyOptional.of(() -> this.tank);
    protected int ticksSinceLast = 0;

    protected CrucibleBlockEntity(BlockEntityType<? extends CrucibleBlockEntity> tileEntityType, BlockPos pos, BlockState state) {
        super(tileEntityType, pos, state);
        this.inventory = new MeltableItemHandler(this.getCrucibleType());
        this.tank = new CrucibleFluidHandler(this);
        this.currentItem = ItemStack.f_41583_;
    }

    public abstract boolean canAcceptFluidTemperature(@Nonnull FluidStack var1);

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventoryHolder.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.tankHolder.cast();
        }
        return super.getCapability(cap, side);
    }

    public abstract CrucibleType getCrucibleType();

    @Nonnull
    public ItemStack getCurrentItem() {
        return this.currentItem;
    }

    @Nullable
    public Fluid getFluid() {
        if (!this.tank.isEmpty()) {
            return this.tank.getFluid().getFluid();
        }
        return null;
    }

    public int getFluidAmount() {
        return this.tank.getFluidAmount();
    }

    public float getFluidProportion() {
        return (float)this.tank.getFluidAmount() / (float)this.tank.getCapacity();
    }

    public int getHeat() {
        if (this.f_58857_ == null) {
            return 0;
        }
        BlockState source = this.f_58857_.m_8055_(this.f_58858_.m_7495_());
        int blockHeat = ExNihiloRegistries.HEAT_REGISTRY.getHeatAmount(source);
        if (source.m_60734_() instanceof LiquidBlock) {
            int level = 8 - (Integer)source.m_61143_((Property)BlockStateProperties.f_61422_);
            double partial = (double)blockHeat / 8.0;
            return (int)Math.ceil(partial * (double)level);
        }
        return blockHeat;
    }

    private Optional<MeltingRecipe> getMeltable() {
        return ExNihiloRegistries.CRUCIBLE_REGISTRY.findRecipe((ItemLike)this.currentItem.m_41720_());
    }

    public abstract int getSolidAmount();

    public float getSolidProportion() {
        try {
            Optional<MeltingRecipe> meltable;
            int itemCount = this.inventory.getStackInSlot(0).m_41619_() ? 0 : this.inventory.getStackInSlot(0).m_41613_();
            float solidProportion = (float)itemCount / 4.0f;
            if (this.solidAmount > 0 && (meltable = this.getMeltable()).isPresent()) {
                solidProportion += (float)this.solidAmount / (float)(4 * meltable.get().getResultFluid().getAmount());
            }
            return solidProportion;
        }
        catch (NullPointerException e) {
            log.error(e.getMessage());
            return 0.0f;
        }
    }

    @Nonnull
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        if (!this.inventory.getStackInSlot(0).m_41619_()) {
            CompoundTag blockNbt = this.inventory.getStackInSlot(0).m_41739_(new CompoundTag());
            nbt.m_128365_(BLOCK_TAG, (Tag)blockNbt);
        }
        if (!this.currentItem.m_41619_()) {
            CompoundTag currentItemTag = this.currentItem.m_41739_(new CompoundTag());
            nbt.m_128365_(CURRENT_ITEM_TAG, (Tag)currentItemTag);
        }
        if (!this.tank.isEmpty()) {
            CompoundTag fluidNbt = this.tank.writeToNBT(new CompoundTag());
            nbt.m_128365_(FLUID_TAG, (Tag)fluidNbt);
        }
        nbt.m_128405_(SOLID_AMOUNT_TAG, this.solidAmount);
        return nbt;
    }

    public void m_142466_(@Nonnull CompoundTag compound) {
        this.inventory.deserializeNBT(compound.m_128469_(INVENTORY_TAG));
        this.tank.readFromNBT(compound.m_128469_("tank"));
        this.ticksSinceLast = compound.m_128451_("ticksSinceLast");
        this.solidAmount = compound.m_128451_(SOLID_AMOUNT_TAG);
        this.currentItem = ItemStack.m_41712_((CompoundTag)compound.m_128469_(CURRENT_ITEM_TAG));
        super.m_142466_(compound);
    }

    public InteractionResult onBlockActivated(@Nonnull Player player, @Nonnull InteractionHand handIn, @Nonnull IFluidHandler handler) {
        log.debug("Crucible activated");
        ItemStack stack = player.m_21120_(handIn);
        if (stack.m_41619_()) {
            return InteractionResult.SUCCESS;
        }
        if (TankUtil.drainWaterIntoBottle((BlockEntity)this, (Player)player, (IFluidHandler)handler)) {
            return InteractionResult.SUCCESS;
        }
        if (TankUtil.drainWaterFromBottle((BlockEntity)this, (Player)player, (IFluidHandler)handler)) {
            return InteractionResult.SUCCESS;
        }
        boolean result = FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)handIn, (IFluidHandler)handler);
        if (result) {
            log.debug("Fluid handler interaction successful");
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            if (this.f_58857_ != null) {
                this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
            }
            this.m_6596_();
            return InteractionResult.SUCCESS;
        }
        Optional<MeltingRecipe> recipe = this.getMeltable();
        if (recipe.isPresent() && !this.tank.isEmpty() && !this.tank.getFluid().getFluid().m_6212_(recipe.get().getResultFluid().getFluid())) {
            return InteractionResult.SUCCESS;
        }
        log.debug("Inserting item");
        ItemStack addStack = stack.m_41777_();
        addStack.m_41764_(1);
        ItemStack insertStack = this.inventory.insertItem(0, addStack, true);
        if (!ItemStack.m_41728_((ItemStack)addStack, (ItemStack)insertStack)) {
            this.inventory.insertItem(0, addStack, false);
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            this.m_6596_();
            this.tickCrucible();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    public void onDataPacket(@Nonnull Connection net, @Nonnull ClientboundBlockEntityDataPacket packet) {
        Tag currentItemTag;
        CompoundTag nbt = packet.m_131708_();
        this.currentItem = nbt.m_128441_(CURRENT_ITEM_TAG) ? ((currentItemTag = nbt.m_128423_(CURRENT_ITEM_TAG)) != null ? ItemStack.m_41712_((CompoundTag)((CompoundTag)currentItemTag)) : ItemStack.f_41583_) : ItemStack.f_41583_;
        if (nbt.m_128441_(BLOCK_TAG)) {
            Tag blockTag = nbt.m_128423_(BLOCK_TAG);
            if (blockTag != null) {
                this.inventory.setStackInSlot(0, ItemStack.m_41712_((CompoundTag)((CompoundTag)blockTag)));
            } else {
                this.inventory.setStackInSlot(0, ItemStack.f_41583_);
            }
        } else {
            this.inventory.setStackInSlot(0, ItemStack.f_41583_);
        }
        if (nbt.m_128441_(FLUID_TAG)) {
            this.tank.readFromNBT(nbt.m_128469_(FLUID_TAG));
        } else {
            this.tank.setFluid(FluidStack.EMPTY);
        }
        this.solidAmount = nbt.m_128451_(SOLID_AMOUNT_TAG);
    }

    public void m_183515_(@Nonnull CompoundTag compound) {
        compound.m_128365_(INVENTORY_TAG, (Tag)this.inventory.serializeNBT());
        compound.m_128365_("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
        compound.m_128405_("ticksSinceLast", this.ticksSinceLast);
        compound.m_128405_(SOLID_AMOUNT_TAG, this.solidAmount);
        compound.m_128365_(CURRENT_ITEM_TAG, (Tag)this.currentItem.m_41739_(new CompoundTag()));
    }

    public void tickServer() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        this.inventory.setCrucibleHasRoom(this.tank.getFluidAmount() < MAX_FLUID_AMOUNT);
        ++this.ticksSinceLast;
        if (this.ticksSinceLast >= Config.getTicksBetweenMelts()) {
            this.ticksSinceLast = 0;
            this.tickCrucible();
        }
        this.updateCurrentState();
    }

    private void updateCurrentState() {
        BaseCrucibleTileState currentState = new BaseCrucibleTileState(this);
        if (!currentState.equals(this.lastSyncedState)) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
            this.lastSyncedState = currentState;
        }
    }

    protected void tickCrucible() {
        int heat = this.getHeat();
        if (heat <= 0) {
            return;
        }
        if (this.solidAmount <= 0) {
            if (!this.inventory.getStackInSlot(0).m_41619_()) {
                this.consumeNewSolid();
            } else {
                return;
            }
        }
        if (!this.inventory.getStackInSlot(0).m_41619_() && this.inventory.getStackInSlot(0).m_150930_(this.currentItem.m_41720_())) {
            this.addFluid(heat);
        }
        if (heat > this.solidAmount) {
            heat = this.solidAmount;
        }
        if (heat > 0 && ExNihiloRegistries.CRUCIBLE_REGISTRY.isMeltable((ItemLike)this.currentItem.m_41720_(), this.getCrucibleType().getLevel())) {
            this.processSolid(heat);
        }
    }

    protected abstract void processSolid(int var1);

    private void addFluid(int heat) {
        while (heat > this.solidAmount && !this.inventory.getStackInSlot(0).m_41619_()) {
            Optional<MeltingRecipe> recipe = ExNihiloRegistries.CRUCIBLE_REGISTRY.findRecipe((ItemLike)this.currentItem.m_41720_());
            if (!recipe.isPresent()) continue;
            this.solidAmount += recipe.get().getResultFluid().getAmount();
            this.inventory.getStackInSlot(0).m_41774_(1);
            if (!this.inventory.getStackInSlot(0).m_41619_()) continue;
            this.inventory.setStackInSlot(0, ItemStack.f_41583_);
        }
    }

    protected abstract void consumeNewSolid();

    protected static class BaseCrucibleTileState {
        @Nullable
        private final Fluid fluid;
        private final int fluidAmount;
        private final int heat;
        @Nonnull
        private final Item solid;
        private final int solidAmount;

        BaseCrucibleTileState(@Nonnull CrucibleBlockEntity crucibleBlockEntity) {
            this.fluid = crucibleBlockEntity.getFluid();
            this.fluidAmount = crucibleBlockEntity.getFluidAmount();
            this.solid = crucibleBlockEntity.inventory.getStackInSlot(0).m_41720_();
            this.solidAmount = crucibleBlockEntity.getSolidAmount();
            this.heat = crucibleBlockEntity.getHeat();
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BaseCrucibleTileState that = (BaseCrucibleTileState)o;
            return this.fluidAmount == that.fluidAmount && this.solidAmount == that.solidAmount && this.heat == that.heat && Objects.equals(this.fluid, that.fluid) && Objects.equals(this.solid, that.solid);
        }

        public int hashCode() {
            return Objects.hash(this.fluid, this.fluidAmount, this.solid, this.solidAmount, this.heat);
        }
    }

    public static enum CrucibleType {
        WOOD("wood", 0),
        FIRED("fired", 1);

        @Nonnull
        private final String name;
        private final int level;

        @Nonnull
        public String getName() {
            return this.name;
        }

        private CrucibleType(String name, int level) {
            this.name = name;
            this.level = level;
        }

        public static CrucibleType getTypeByName(@Nonnull String name) {
            for (CrucibleType type : CrucibleType.values()) {
                if (!type.name.equals(name)) continue;
                return type;
            }
            return null;
        }

        public int getLevel() {
            return this.level;
        }
    }
}

