/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.world.level.block.entity;

import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import novamachina.exnihilosequentia.common.registries.ExNihiloRegistries;
import novamachina.exnihilosequentia.world.item.crafting.MeltingRecipe;
import novamachina.exnihilosequentia.world.level.block.entity.CrucibleBlockEntity;

public class FiredCrucibleBlockBlockEntity
extends CrucibleBlockEntity {
    public FiredCrucibleBlockBlockEntity(BlockEntityType<? extends FiredCrucibleBlockBlockEntity> tile, BlockPos pos, BlockState state) {
        super(tile, pos, state);
    }

    @Override
    @Nonnull
    public CrucibleBlockEntity.CrucibleType getCrucibleType() {
        return CrucibleBlockEntity.CrucibleType.FIRED;
    }

    @Override
    public int getSolidAmount() {
        if (!this.currentItem.m_41619_()) {
            int itemCount = this.inventory.getStackInSlot(0).m_41613_();
            Optional<MeltingRecipe> recipe = ExNihiloRegistries.CRUCIBLE_REGISTRY.findRecipe((ItemLike)this.currentItem.m_41720_());
            if (recipe.isPresent()) {
                return this.solidAmount + itemCount * recipe.get().getResultFluid().getAmount();
            }
        }
        return this.solidAmount;
    }

    @Override
    public boolean canAcceptFluidTemperature(@Nonnull FluidStack fluidStack) {
        return true;
    }

    @Override
    protected void processSolid(int heat) {
        Optional<MeltingRecipe> recipe = ExNihiloRegistries.CRUCIBLE_REGISTRY.findRecipe((ItemLike)this.currentItem.m_41720_());
        if (recipe.isPresent()) {
            FluidStack fluidStack = new FluidStack(recipe.get().getResultFluid(), heat);
            int filled = this.tank.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
            this.solidAmount -= filled;
        }
    }

    @Override
    protected void consumeNewSolid() {
        this.currentItem = this.inventory.getStackInSlot(0).m_41777_();
        this.inventory.getStackInSlot(0).m_41774_(1);
        if (this.inventory.getStackInSlot(0).m_41619_()) {
            this.inventory.setStackInSlot(0, ItemStack.f_41583_);
        }
        ExNihiloRegistries.CRUCIBLE_REGISTRY.findRecipe((ItemLike)this.currentItem.m_41720_()).ifPresent(recipe -> {
            this.solidAmount = recipe.getResultFluid().getAmount();
        });
    }
}

