/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.jingle;

import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import me.paulf.fairylights.server.feature.light.Light;
import me.paulf.fairylights.server.jingle.Jingle;
import me.paulf.fairylights.server.sound.FLSounds;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public final class JinglePlayer {
    private State<?> state = new NotPlayingState();

    @Nullable
    public Jingle getJingle() {
        return this.state.getJingle();
    }

    public boolean isPlaying() {
        return this.state.isPlaying();
    }

    public float getProgress() {
        return this.state.getProgress();
    }

    public void play(Jingle jingle, int lightOffset) {
        this.state = new PlayingState(jingle, lightOffset);
    }

    public void tick(Level world, Vec3 origin, Light<?>[] lights, boolean isClient) {
        this.state = this.state.tick(world, origin, lights, isClient);
    }

    public CompoundTag serialize() {
        return StateType.serialize(this.state);
    }

    public void deserialize(CompoundTag compound) {
        this.state = StateType.deserialize(compound);
    }

    private static final class NotPlayingState
    extends State<NotPlayingState> {
        public static final StateFactory<NotPlayingState> FACTORY = NotPlayingState.newFactory();

        private NotPlayingState() {
        }

        @Override
        public Jingle getJingle() {
            return null;
        }

        @Override
        public boolean isPlaying() {
            return false;
        }

        @Override
        public float getProgress() {
            return 0.0f;
        }

        @Override
        public State<?> tick(Level world, Vec3 origin, Light<?>[] lights, boolean isClient) {
            return this;
        }

        @Override
        public StateFactory<NotPlayingState> getFactory() {
            return FACTORY;
        }

        @Override
        public NotPlayingState resolve() {
            return this;
        }

        private static StateFactory<NotPlayingState> newFactory() {
            return new StateFactory<NotPlayingState>(){

                @Override
                public String getId() {
                    return "not_playing";
                }

                @Override
                public CompoundTag serialize(NotPlayingState state) {
                    return new CompoundTag();
                }

                public NotPlayingState deserialize(CompoundTag compound) {
                    return new NotPlayingState();
                }
            };
        }
    }

    private static abstract class State<S extends State<S>> {
        private State() {
        }

        public abstract Jingle getJingle();

        public abstract boolean isPlaying();

        public abstract float getProgress();

        public abstract State<?> tick(Level var1, Vec3 var2, Light<?>[] var3, boolean var4);

        public abstract StateFactory<S> getFactory();

        public abstract S resolve();
    }

    private static final class PlayingState
    extends State<PlayingState> {
        public static final StateFactory<PlayingState> FACTORY = PlayingState.newFactory();
        private final Jingle jingle;
        private final int lightOffset;
        private final List<Jingle.PlayTick> playTicks;
        private final int length;
        private final ParticleOptions[] noteParticle;
        private int index;
        private int rest;
        private int time;

        private PlayingState(Jingle jingle, int lightOffset) {
            this(jingle, lightOffset, jingle.getPlayTicks(), jingle.getLength(), PlayingState.getParticles(jingle));
        }

        private PlayingState(Jingle jingle, int lightOffset, List<Jingle.PlayTick> playTicks, int length, ParticleOptions[] noteParticle) {
            this.jingle = jingle;
            this.lightOffset = lightOffset;
            this.playTicks = playTicks;
            this.length = length;
            this.noteParticle = noteParticle;
        }

        @Override
        public Jingle getJingle() {
            return this.jingle;
        }

        @Override
        public boolean isPlaying() {
            return true;
        }

        @Override
        public float getProgress() {
            return (float)this.time / (float)this.length;
        }

        @Override
        public State<?> tick(Level world, Vec3 origin, Light<?>[] lights, boolean isClient) {
            ++this.time;
            if (this.rest <= 0) {
                if (this.index >= this.playTicks.size()) {
                    return new NotPlayingState();
                }
                Jingle.PlayTick playTick = this.playTicks.get(this.index++);
                this.rest = playTick.getDuration() - 1;
                if (isClient) {
                    this.play(world, origin, lights, playTick);
                }
            } else {
                --this.rest;
            }
            return this;
        }

        private void play(Level world, Vec3 origin, Light<?>[] lights, Jingle.PlayTick playTick) {
            for (int note : playTick.getNotes()) {
                int idx = note - this.jingle.getLowestNote() + this.lightOffset;
                if (idx < 0 || idx >= lights.length) continue;
                lights[idx].jingle(world, origin, note, (SoundEvent)FLSounds.JINGLE_BELL.get(), this.noteParticle);
            }
        }

        @Override
        public StateFactory<PlayingState> getFactory() {
            return FACTORY;
        }

        @Override
        public PlayingState resolve() {
            return this;
        }

        private static StateFactory<PlayingState> newFactory() {
            return new StateFactory<PlayingState>(){

                @Override
                public String getId() {
                    return "playing";
                }

                @Override
                public CompoundTag serialize(PlayingState state) {
                    CompoundTag compound = new CompoundTag();
                    Jingle.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)state.jingle).result().ifPresent(jingle -> {
                        compound.m_128365_("jingle", jingle);
                        compound.m_128405_("lightOffset", state.lightOffset);
                        compound.m_128405_("index", state.index);
                        compound.m_128405_("rest", state.rest);
                        compound.m_128405_("time", state.time);
                    });
                    return compound;
                }

                @Override
                public State<?> deserialize(CompoundTag compound) {
                    return Jingle.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)compound.m_128469_("jingle")).result().map(jingle -> {
                        int lightOffset = compound.m_128451_("lightOffset");
                        PlayingState state = new PlayingState((Jingle)jingle, lightOffset);
                        state.index = compound.m_128451_("index");
                        state.rest = compound.m_128451_("rest");
                        state.time = compound.m_128451_("time");
                        return state;
                    }).orElseGet(NotPlayingState::new);
                }
            };
        }

        private static ParticleOptions[] getParticles(Jingle jingle) {
            if (jingle.getTitle().hashCode() == -222984226) {
                return new ParticleOptions[]{ParticleTypes.f_123758_, ParticleTypes.f_123756_};
            }
            if (jingle.getTitle().hashCode() == -1006999363 || jingle.getTitle().hashCode() == 1895267316) {
                return new ParticleOptions[]{ParticleTypes.f_123758_, ParticleTypes.f_123750_};
            }
            return new ParticleOptions[]{ParticleTypes.f_123758_};
        }
    }

    private static enum StateType {
        NOT_PLAYING(NotPlayingState.FACTORY),
        PLAYING(PlayingState.FACTORY);

        private static final Map<String, StateType> MAP;
        private final StateFactory<?> factory;

        private StateType(StateFactory<?> factory) {
            this.factory = factory;
        }

        private String getId() {
            return this.factory.getId();
        }

        private StateFactory<?> getFactory() {
            return this.factory;
        }

        public static <S extends State<S>> CompoundTag serialize(State<S> state) {
            StateFactory<S> factory = state.getFactory();
            CompoundTag compound = new CompoundTag();
            compound.m_128359_("state", factory.getId());
            compound.m_128365_("data", (Tag)factory.serialize(state.resolve()));
            return compound;
        }

        public static State<?> deserialize(CompoundTag compound) {
            return MAP.getOrDefault(compound.m_128461_("state"), NOT_PLAYING).getFactory().deserialize(compound.m_128469_("data"));
        }

        static {
            MAP = Stream.of(StateType.values()).collect(Collectors.toMap(StateType::getId, Function.identity()));
        }
    }

    private static abstract class StateFactory<S extends State<S>> {
        private StateFactory() {
        }

        public abstract String getId();

        public abstract CompoundTag serialize(S var1);

        public abstract State<?> deserialize(CompoundTag var1);
    }
}

