/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.net.serverbound;

import java.util.function.BiConsumer;
import me.paulf.fairylights.server.collision.Intersection;
import me.paulf.fairylights.server.connection.Connection;
import me.paulf.fairylights.server.connection.PlayerAction;
import me.paulf.fairylights.server.feature.FeatureType;
import me.paulf.fairylights.server.net.ConnectionMessage;
import me.paulf.fairylights.server.net.ServerMessageContext;
import me.paulf.fairylights.util.Utils;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public final class InteractionConnectionMessage
extends ConnectionMessage {
    private static final float RANGE = 1089.0f;
    private static final float REACH = 36.0f;
    private PlayerAction type;
    private Vec3 hit;
    private FeatureType featureType;
    private int featureId;

    public InteractionConnectionMessage() {
    }

    public InteractionConnectionMessage(Connection connection, PlayerAction type, Intersection intersection) {
        super(connection);
        this.type = type;
        this.hit = intersection.getResult();
        this.featureType = intersection.getFeatureType();
        this.featureId = intersection.getFeature().getId();
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        super.encode(buf);
        buf.writeByte(this.type.ordinal());
        buf.writeDouble(this.hit.f_82479_);
        buf.writeDouble(this.hit.f_82480_);
        buf.writeDouble(this.hit.f_82481_);
        buf.m_130130_(this.featureType.getId());
        buf.m_130130_(this.featureId);
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        super.decode(buf);
        this.type = Utils.getEnumValue(PlayerAction.class, buf.readUnsignedByte());
        this.hit = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
        this.featureType = FeatureType.fromId(buf.m_130242_());
        this.featureId = buf.m_130242_();
    }

    public static final class Handler
    implements BiConsumer<InteractionConnectionMessage, ServerMessageContext> {
        @Override
        public void accept(InteractionConnectionMessage message, ServerMessageContext context) {
            ServerPlayer player = context.getPlayer();
            ConnectionMessage.getConnection(message, c -> true, player.m_9236_()).ifPresent(connection -> {
                if (connection.isModifiable((Player)player) && player.m_20238_(Vec3.m_82528_((Vec3i)connection.getFastener().getPos())) < 1089.0 && player.m_20275_(message.hit.f_82479_, message.hit.f_82480_, message.hit.f_82481_) < 36.0) {
                    if (message.type == PlayerAction.ATTACK) {
                        connection.disconnect((Player)player, message.hit);
                    } else {
                        this.interact(message, (Player)player, (Connection)connection, message.hit);
                    }
                }
            });
        }

        private void interact(InteractionConnectionMessage message, Player player, Connection connection, Vec3 hit) {
            for (InteractionHand hand : InteractionHand.values()) {
                ItemStack stack = player.m_21120_(hand);
                ItemStack oldStack = stack.m_41777_();
                if (!connection.interact(player, hit, message.featureType, message.featureId, stack, hand)) continue;
                this.updateItem(player, oldStack, stack, hand);
                break;
            }
        }

        private void updateItem(Player player, ItemStack oldStack, ItemStack stack, InteractionHand hand) {
            if (stack.m_41613_() <= 0 && !player.m_150110_().f_35937_) {
                ForgeEventFactory.onPlayerDestroyItem((Player)player, (ItemStack)stack, (InteractionHand)hand);
                player.m_21008_(hand, ItemStack.f_41583_);
            } else if (stack.m_41613_() < oldStack.m_41613_() && player.m_150110_().f_35937_) {
                stack.m_41764_(oldStack.m_41613_());
            }
        }
    }
}

