/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.entity.misc;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.PotatoBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.yirmiri.dungeonsdelight.core.init.DDDamageTypes;
import net.yirmiri.dungeonsdelight.core.registry.DDBlocks;
import net.yirmiri.dungeonsdelight.core.registry.DDEffects;
import net.yirmiri.dungeonsdelight.core.registry.DDEntities;
import net.yirmiri.dungeonsdelight.core.registry.DDItems;
import net.yirmiri.dungeonsdelight.core.registry.DDParticles;
import net.yirmiri.dungeonsdelight.core.registry.DDSounds;
import vectorwing.farmersdelight.common.block.TomatoVineBlock;
import vectorwing.farmersdelight.common.registry.ModDamageTypes;

public class RancidReductionEntity
extends ThrowableItemProjectile {
    public RancidReductionEntity(EntityType<? extends ThrowableItemProjectile> type, Level level) {
        super(type, level);
    }

    public RancidReductionEntity(Level level, LivingEntity entity) {
        super((EntityType)DDEntities.RANCID_REDUCTION.get(), entity, level);
    }

    public RancidReductionEntity(Level level, double x, double y, double z) {
        super((EntityType)DDEntities.RANCID_REDUCTION.get(), x, y, z, level);
    }

    protected Item m_7881_() {
        return (Item)DDItems.RANCID_REDUCTION.get();
    }

    public void m_7822_(byte id) {
        ItemStack entityStack = new ItemStack((ItemLike)this.m_7881_());
        if (id == 3) {
            for (int i = 0; i < 12; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, entityStack), this.m_20185_(), this.m_20186_(), this.m_20189_(), ((double)this.f_19796_.m_188501_() * 2.0 - 1.0) * 0.1, ((double)this.f_19796_.m_188501_() * 2.0 - 1.0) * 0.1 + 0.1, ((double)this.f_19796_.m_188501_() * 2.0 - 1.0) * 0.1);
            }
        }
    }

    protected float m_7139_() {
        return 0.05f;
    }

    public void rotCrop(BlockPos pos, Block newBlock, Level level, BlockState state) {
        level.m_7731_(pos, newBlock.m_49966_(), 3);
        level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)this, (BlockState)state));
        level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (SoundEvent)DDSounds.MONSTER_YAM_AMBIENT.get(), SoundSource.BLOCKS, 1.0f, 0.75f);
        RancidReductionEntity.addRotParticles((LevelAccessor)level, pos, 5);
    }

    public static void addRotParticles(LevelAccessor accessor, BlockPos pos, int i1) {
        BlockState blockstate;
        if (i1 == 0) {
            i1 = 15;
        }
        if (!(blockstate = accessor.m_8055_(pos)).m_60795_()) {
            double d1;
            double d0 = 0.5;
            if (blockstate.m_60713_(Blocks.f_49990_)) {
                i1 *= 3;
                d1 = 1.0;
                d0 = 3.0;
            } else if (blockstate.m_60804_((BlockGetter)accessor, pos)) {
                pos = pos.m_7494_();
                i1 *= 3;
                d0 = 3.0;
                d1 = 1.0;
            } else {
                d1 = blockstate.m_60808_((BlockGetter)accessor, pos).m_83297_(Direction.Axis.Y);
            }
            accessor.m_7106_((ParticleOptions)DDParticles.ROTTEN_GLINT.get(), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
            RandomSource randomsource = accessor.m_213780_();
            for (int i = 0; i < i1; ++i) {
                double d8;
                double d7;
                double d2 = randomsource.m_188583_() * 0.02;
                double d3 = randomsource.m_188583_() * 0.02;
                double d4 = randomsource.m_188583_() * 0.02;
                double d5 = 0.5 - d0;
                double d6 = (double)pos.m_123341_() + d5 + randomsource.m_188500_() * d0 * 2.0;
                if (accessor.m_8055_(BlockPos.m_274561_((double)d6, (double)(d7 = (double)pos.m_123342_() + randomsource.m_188500_() * d1), (double)(d8 = (double)pos.m_123343_() + d5 + randomsource.m_188500_() * d0 * 2.0)).m_7495_()).m_60795_()) continue;
                accessor.m_7106_((ParticleOptions)DDParticles.ROTTEN_GLINT.get(), d6, d7, d8, d2, d3, d4);
            }
        }
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        Entity entity = result.m_82443_();
        entity.m_6469_(ModDamageTypes.getSimpleDamageSource((Level)this.m_9236_(), DDDamageTypes.SHATTER), 3.0f);
    }

    protected void m_6532_(HitResult hitResult) {
        super.m_6532_(hitResult);
        if (!this.m_9236_().f_46443_) {
            this.makeAreaOfEffectCloud();
            this.m_146870_();
        }
    }

    private void makeAreaOfEffectCloud() {
        AreaEffectCloud cloud = new AreaEffectCloud(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
        Entity owner = this.m_19749_();
        if (owner instanceof LivingEntity) {
            cloud.m_19718_((LivingEntity)owner);
        }
        cloud.m_19734_(300);
        cloud.m_19712_(3.0f);
        cloud.m_19732_(-0.5f);
        cloud.m_19740_(10);
        cloud.m_19738_(-cloud.m_19743_() / (float)cloud.m_19748_());
        cloud.m_19724_((ParticleOptions)DDParticles.ROT_CLOUD.get());
        cloud.m_19716_(new MobEffectInstance((MobEffect)DDEffects.EXUDATION.get(), 300, 2));
        cloud.m_19716_(new MobEffectInstance(MobEffects.f_19613_, 300, 0));
        Level level = this.m_9236_();
        BlockPos centerPos = new BlockPos((int)Math.floor(cloud.m_20185_()), (int)Math.floor(cloud.m_20186_()), (int)Math.floor(cloud.m_20189_()));
        this.m_5496_(SoundEvents.f_11983_, 1.5f, -1.0f);
        if (!level.f_46443_) {
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        TomatoVineBlock tomatoVineBlock;
                        PotatoBlock potatoBlock;
                        CropBlock cropBlock;
                        BlockPos pos = new BlockPos(centerPos.m_123341_() + dx, centerPos.m_123342_() + dy, centerPos.m_123343_() + dz);
                        BlockState state = level.m_8055_(pos);
                        Block block = state.m_60734_();
                        if (!(block instanceof CropBlock) || !(cropBlock = (CropBlock)block).m_52307_(state)) continue;
                        if (cropBlock instanceof PotatoBlock && (potatoBlock = (PotatoBlock)cropBlock).m_52307_(state)) {
                            this.rotCrop(pos, (Block)DDBlocks.ROTTEN_POTATOES.get(), level, state);
                            continue;
                        }
                        if (cropBlock instanceof TomatoVineBlock && (tomatoVineBlock = (TomatoVineBlock)cropBlock).m_52307_(state) && !((Boolean)state.m_61143_((Property)TomatoVineBlock.ROPELOGGED)).booleanValue()) {
                            this.rotCrop(pos, (Block)DDBlocks.ROTTEN_TOMATOES.get(), level, state);
                            continue;
                        }
                        if (cropBlock instanceof TomatoVineBlock) continue;
                        this.rotCrop(pos, (Block)DDBlocks.ROTTEN_CROP.get(), level, state);
                    }
                }
            }
        }
        this.m_9236_().m_7967_((Entity)cloud);
    }
}

