/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.client;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import whocraft.tardis_refined.common.VortexRegistry;
import whocraft.tardis_refined.common.network.messages.sync.S2CSyncTardisClientData;
import whocraft.tardis_refined.common.soundscape.hum.HumEntry;
import whocraft.tardis_refined.common.soundscape.hum.TardisHums;
import whocraft.tardis_refined.common.tardis.themes.ShellTheme;
import whocraft.tardis_refined.patterns.ShellPatterns;

public class TardisClientData {
    private static final List<TardisClientData> DATA = new ArrayList<TardisClientData>();
    public static int FOG_TICK_DELTA = 0;
    static int MAX_FOG_TICK_DELTA = 40;
    private final ResourceKey<Level> levelKey;
    public AnimationState ROTOR_ANIMATION = new AnimationState();
    public AnimationState CRASHING_ANIMATION = new AnimationState();
    public AnimationState LANDING_ANIMATION = new AnimationState();
    public AnimationState TAKEOFF_ANIMATION = new AnimationState();
    public int landingTime = 0;
    public int takeOffTime = 0;
    int nextAmbientNoiseCall = 40;
    int nextVoiceAmbientCall = 12000;
    private boolean flying = false;
    private int throttleStage = 0;
    private boolean isLanding = false;
    private boolean isHandbrakeEngaged = false;
    private boolean isTakingOff = false;
    private boolean isInDangerZone = false;
    private boolean isCrashing = false;
    private boolean isOnCooldown = false;
    private float flightShakeScale = 0.0f;
    private double fuel = 0.0;
    private double maximumFuel = 0.0;
    private int tardisState = 0;
    private int recoveryTicks = 0;
    private float journeyProgress = 0.0f;
    private ResourceLocation shellTheme = ShellTheme.HALF_BAKED.getId();
    private ResourceLocation vortex = VortexRegistry.FLOW.getId();
    private ResourceLocation shellPattern = ShellPatterns.DEFAULT.id();
    private HumEntry humEntry = TardisHums.getDefaultHum();

    public TardisClientData(ResourceKey<Level> resourceKey) {
        this.levelKey = resourceKey;
    }

    public static void add(TardisClientData tardisClientData) {
        DATA.add(tardisClientData);
    }

    public ResourceLocation getVortex() {
        return this.vortex;
    }

    public void setVortex(ResourceLocation vortex) {
        this.vortex = vortex;
    }

    public static TardisClientData getInstance(ResourceKey<Level> levelResourceKey) {
        for (TardisClientData data : DATA) {
            if (!data.getLevelKey().equals(levelResourceKey)) continue;
            return data;
        }
        TardisClientData newData = new TardisClientData(levelResourceKey);
        DATA.add(newData);
        return newData;
    }

    public static List<TardisClientData> getAllEntries() {
        return new ArrayList<TardisClientData>(DATA);
    }

    public static void clearAll() {
        DATA.clear();
    }

    public ResourceKey<Level> getLevelKey() {
        return this.levelKey;
    }

    public float getJourneyProgress() {
        return this.journeyProgress;
    }

    public void setJourneyProgress(float journeyProgress) {
        this.journeyProgress = journeyProgress;
    }

    public ResourceLocation getShellTheme() {
        return this.shellTheme;
    }

    public void setShellTheme(ResourceLocation shellTheme) {
        this.shellTheme = shellTheme;
    }

    public HumEntry getHumEntry() {
        return this.humEntry;
    }

    public void setHumEntry(HumEntry humEntry) {
        this.humEntry = humEntry;
    }

    public int getThrottleStage() {
        return this.throttleStage;
    }

    public void setThrottleStage(int stage) {
        this.throttleStage = stage;
    }

    public ResourceLocation getShellPattern() {
        return this.shellPattern;
    }

    public void setShellPattern(ResourceLocation shellPattern) {
        this.shellPattern = shellPattern;
    }

    public boolean isFlying() {
        return this.flying;
    }

    public void setFlying(boolean flying) {
        this.flying = flying;
    }

    public void setIsLanding(boolean landing) {
        this.isLanding = landing;
    }

    public boolean isLanding() {
        return this.isLanding;
    }

    public void setIsTakingOff(boolean takingOff) {
        this.isTakingOff = takingOff;
    }

    public boolean isTakingOff() {
        return this.isTakingOff;
    }

    public void setIsCrashing(boolean isCrashing) {
        this.isCrashing = isCrashing;
    }

    public boolean isCrashing() {
        return this.isCrashing;
    }

    public void setIsOnCooldown(boolean isCooldown) {
        this.isOnCooldown = isCooldown;
    }

    public boolean isInRecovery() {
        return this.isOnCooldown;
    }

    public double getFuel() {
        return this.fuel;
    }

    public void setFuel(double fuel) {
        this.fuel = fuel;
    }

    public double getMaximumFuel() {
        return this.maximumFuel;
    }

    public void setMaximumFuel(double fuel) {
        this.maximumFuel = fuel;
    }

    public CompoundTag serializeNBT() {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128379_("flying", this.flying);
        compoundTag.m_128405_("throttle_stage", this.throttleStage);
        compoundTag.m_128405_("recoveryTicks", this.recoveryTicks);
        compoundTag.m_128350_("journeyProgress", this.journeyProgress);
        compoundTag.m_128379_("handbrake_engaged", this.isHandbrakeEngaged);
        compoundTag.m_128379_("isLanding", this.isLanding);
        compoundTag.m_128379_("isTakingOff", this.isTakingOff);
        compoundTag.m_128379_("isInDangerZone", this.isInDangerZone);
        compoundTag.m_128350_("flightShakeScale", this.flightShakeScale);
        compoundTag.m_128379_("isOnCooldown", this.isOnCooldown);
        compoundTag.m_128359_("shellTheme", this.shellTheme.toString());
        compoundTag.m_128359_("vortex", this.vortex.toString());
        compoundTag.m_128359_("shellPattern", this.shellPattern.toString());
        compoundTag.m_128359_("tardis_current_hum", this.humEntry.getIdentifier().toString());
        compoundTag.m_128347_("fuel", this.fuel);
        compoundTag.m_128347_("MaximumFuel", this.maximumFuel);
        return compoundTag;
    }

    public void deserializeNBT(CompoundTag compoundTag) {
        this.flying = compoundTag.m_128471_("flying");
        this.throttleStage = compoundTag.m_128451_("throttle_stage");
        this.isHandbrakeEngaged = compoundTag.m_128471_("handbrake_engaged");
        this.isLanding = compoundTag.m_128471_("isLanding");
        this.isTakingOff = compoundTag.m_128471_("isTakingOff");
        this.isInDangerZone = compoundTag.m_128471_("isInDangerZone");
        this.flightShakeScale = compoundTag.m_128457_("flightShakeScale");
        this.isOnCooldown = compoundTag.m_128471_("isOnCooldown");
        this.recoveryTicks = compoundTag.m_128451_("recoveryTicks");
        this.journeyProgress = compoundTag.m_128457_("journeyProgress");
        this.shellTheme = new ResourceLocation(compoundTag.m_128461_("shellTheme"));
        this.shellPattern = new ResourceLocation(compoundTag.m_128461_("shellPattern"));
        this.vortex = new ResourceLocation(compoundTag.m_128461_("vortex"));
        this.setHumEntry(TardisHums.getHumById(new ResourceLocation(compoundTag.m_128461_("tardis_current_hum"))));
        this.fuel = compoundTag.m_128459_("fuel");
        this.maximumFuel = compoundTag.m_128459_("MaximumFuel");
    }

    public void sync() {
        new S2CSyncTardisClientData(this.getLevelKey(), this.serializeNBT()).sendToAll();
    }

    public Vec3 fogColor(boolean isCrashing) {
        if (isCrashing) {
            return new Vec3(1.0, 0.0, 0.0);
        }
        return new Vec3((double)0.14f, (double)0.15f, (double)0.22f);
    }

    public boolean isHandbrakeEngaged() {
        return this.isHandbrakeEngaged;
    }

    public void setHandbrakeEngaged(boolean handbrakeEngaged) {
        this.isHandbrakeEngaged = handbrakeEngaged;
    }

    public int getTardisState() {
        return this.tardisState;
    }

    public void setTardisState(int tardisState) {
        this.tardisState = tardisState;
    }

    public void setRecoveryProgress(int crashRecoveryTicks) {
        this.recoveryTicks = crashRecoveryTicks;
    }

    public int getRecoveryTicks() {
        return this.recoveryTicks;
    }
}

