/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.client.model.blockentity.console;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.jeryn.frame.tardis.Frame;
import net.minecraft.client.Minecraft;
import net.minecraft.client.animation.AnimationChannel;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.Keyframe;
import net.minecraft.client.animation.KeyframeAnimations;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import whocraft.tardis_refined.client.TardisClientData;
import whocraft.tardis_refined.client.model.blockentity.console.ConsoleUnit;
import whocraft.tardis_refined.common.blockentity.console.GlobalConsoleBlockEntity;

public class MystConsoleModel
extends HierarchicalModel
implements ConsoleUnit {
    public static final AnimationDefinition MODEL_ROTOR_LOOP = AnimationDefinition.Builder.m_232275_((float)4.0f).m_232274_().m_232279_("rotor", new AnimationChannel(AnimationChannel.Targets.f_232250_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(2.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)-4.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(4.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_)})).m_232279_("rotor", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(4.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)240.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232282_();
    private static final ResourceLocation MYST_TEXTURE = new ResourceLocation("tardis_refined", "textures/blockentity/console/myst/myst_console.png");
    private final ModelPart root;
    private final ModelPart base_console;
    private final ModelPart controls;
    private final ModelPart rotor;
    private final ModelPart throttle_control;
    private final ModelPart handbrake;

    public MystConsoleModel(ModelPart root) {
        this.root = root;
        this.base_console = root.m_171324_("base_console");
        this.controls = root.m_171324_("controls");
        this.rotor = root.m_171324_("rotor");
        this.throttle_control = this.controls.m_171324_("south").m_171324_("bone120").m_171324_("throttle_control");
        this.handbrake = Frame.findPart(this, "door_control");
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.base_console.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.controls.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rotor.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void m_6973_(Entity entity, float f, float g, float h, float i, float j) {
    }

    @Override
    public void renderConsole(GlobalConsoleBlockEntity globalConsoleBlock, Level level, PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        float rot;
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        TardisClientData reactions = TardisClientData.getInstance((ResourceKey<Level>)level.m_46472_());
        this.m_233381_(reactions.ROTOR_ANIMATION, MODEL_ROTOR_LOOP, Minecraft.m_91087_().f_91074_.f_19797_);
        this.throttle_control.f_104203_ = rot = -1.0f + 2.0f * ((float)reactions.getThrottleStage() / 5.0f);
        this.handbrake.f_104203_ = reactions.isHandbrakeEngaged() ? 1.0f : 0.0f;
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    @Override
    public ResourceLocation getDefaultTexture() {
        return MYST_TEXTURE;
    }
}

