/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.client.model.blockentity.shell;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.animation.AnimationChannel;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.Keyframe;
import net.minecraft.client.animation.KeyframeAnimations;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import whocraft.tardis_refined.client.TardisClientData;
import whocraft.tardis_refined.common.blockentity.shell.GlobalShellBlockEntity;
import whocraft.tardis_refined.patterns.ShellPattern;

public abstract class ShellModel
extends HierarchicalModel {
    public static final AnimationDefinition MODEL_TAKEOFF = AnimationDefinition.Builder.m_232275_((float)12.0f).m_232279_("fade_value", new AnimationChannel(AnimationChannel.Targets.f_232250_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)9.5f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)9.5f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(2.125f, KeyframeAnimations.m_253126_((float)0.0f, (float)5.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(3.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)10.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(4.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)3.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(5.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)6.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(5.791677f, KeyframeAnimations.m_253126_((float)0.0f, (float)3.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(6.916767f, KeyframeAnimations.m_253126_((float)0.0f, (float)5.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(8.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)2.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(9.167666f, KeyframeAnimations.m_253126_((float)0.0f, (float)4.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(12.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_)})).m_232282_();
    ModelPart fade_value;
    float initAlpha = 0.0f;
    float ANIMATION_SPEED = 1.1f;
    boolean ignoreAnmationAlpha = false;
    AnimationDefinition MODEL_LAND = AnimationDefinition.Builder.m_232275_((float)11.0f).m_232279_("fade_value", new AnimationChannel(AnimationChannel.Targets.f_232250_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)1.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(2.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(3.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)2.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(4.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(5.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)4.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(6.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(7.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)6.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(8.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)2.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(9.5f, KeyframeAnimations.m_253126_((float)0.0f, (float)10.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232282_();
    private float currentAlpha = 0.0f;

    public ShellModel(ModelPart root) {
        this.fade_value = root.m_171324_("fade_value");
        this.initAlpha = this.fade_value.f_104201_;
    }

    public static void addMaterializationPart(PartDefinition partDefinition) {
        partDefinition.m_171599_("fade_value", CubeListBuilder.m_171558_().m_171514_(128, 128), PartPose.m_171419_((float)-24.0f, (float)24.0f, (float)0.0f));
    }

    public abstract void setDoorPosition(boolean var1);

    public abstract void renderShell(GlobalShellBlockEntity var1, boolean var2, boolean var3, PoseStack var4, VertexConsumer var5, int var6, int var7, float var8, float var9, float var10, float var11);

    public ResourceLocation getShellTexture(ShellPattern pattern, boolean isEmmissive) {
        return this.texture(pattern, isEmmissive);
    }

    public ResourceLocation getShellTexture(GlobalShellBlockEntity shellBlockEntitys, boolean isEmmissive) {
        ShellPattern pattern = shellBlockEntitys.pattern();
        return this.texture(pattern, isEmmissive);
    }

    private ResourceLocation texture(ShellPattern pattern, boolean isEmmissive) {
        return isEmmissive ? pattern.shellTexture().emissiveTexture() : pattern.shellTexture().texture();
    }

    public boolean isIgnoreAnmationAlpha() {
        return this.ignoreAnmationAlpha;
    }

    public void setIgnoreAnmationAlpha(boolean ignoreAnmationAlpha) {
        this.ignoreAnmationAlpha = ignoreAnmationAlpha;
    }

    public float initAlpha() {
        return this.initAlpha;
    }

    public ModelPart fadeValue() {
        return this.fade_value;
    }

    public float getCurrentAlpha() {
        return this.currentAlpha;
    }

    public void handleAllAnimations(GlobalShellBlockEntity entity, ModelPart root, boolean isBaseModel, boolean isDoorOpen, PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float baseAlpha) {
        if (entity.getTardisId() == null) {
            return;
        }
        entity.liveliness.m_216977_(12);
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        TardisClientData reactions = TardisClientData.getInstance(entity.getTardisId());
        this.setDoorPosition(isDoorOpen);
        if (reactions.isLanding()) {
            this.m_233381_(reactions.LANDING_ANIMATION, this.MODEL_LAND, (float)reactions.landingTime * this.ANIMATION_SPEED);
        }
        if (reactions.isTakingOff()) {
            this.m_233381_(reactions.ROTOR_ANIMATION, MODEL_TAKEOFF, (float)reactions.takeOffTime * this.ANIMATION_SPEED);
        }
        this.currentAlpha = reactions.isFlying() ? (this.initAlpha() - this.fadeValue().f_104201_) * 0.1f : baseAlpha;
        this.handleSpecialAnimation(entity, poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, baseAlpha);
        this.m_142109_().m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, reactions.isFlying() && !this.ignoreAnmationAlpha ? this.getCurrentAlpha() : baseAlpha);
    }

    public void handleSpecialAnimation(GlobalShellBlockEntity entity, PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float baseAlpha) {
    }
}

