/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.client.model.blockentity.shell;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import whocraft.tardis_refined.api.event.TardisClientEvents;
import whocraft.tardis_refined.client.ModelRegistry;
import whocraft.tardis_refined.client.model.blockentity.door.interior.BriefcaseDoorModel;
import whocraft.tardis_refined.client.model.blockentity.door.interior.DualInteriorDoorModel;
import whocraft.tardis_refined.client.model.blockentity.door.interior.DualTexInteriorDoorModel;
import whocraft.tardis_refined.client.model.blockentity.door.interior.GrowthDoorModel;
import whocraft.tardis_refined.client.model.blockentity.door.interior.HalfBakedDoorModel;
import whocraft.tardis_refined.client.model.blockentity.door.interior.PresentDoorModel;
import whocraft.tardis_refined.client.model.blockentity.door.interior.ShellDoorModel;
import whocraft.tardis_refined.client.model.blockentity.door.interior.SingleInteriorDoorModel;
import whocraft.tardis_refined.client.model.blockentity.door.interior.SingleTexInteriorDoorModel;
import whocraft.tardis_refined.client.model.blockentity.shell.ShellEntry;
import whocraft.tardis_refined.client.model.blockentity.shell.ShellModel;
import whocraft.tardis_refined.client.model.blockentity.shell.internal.door.ShulkerDoorModel;
import whocraft.tardis_refined.client.model.blockentity.shell.shells.BigBenShellModel;
import whocraft.tardis_refined.client.model.blockentity.shell.shells.BriefcaseShellModel;
import whocraft.tardis_refined.client.model.blockentity.shell.shells.CastleShellModel;
import whocraft.tardis_refined.client.model.blockentity.shell.shells.DrifterShellModel;
import whocraft.tardis_refined.client.model.blockentity.shell.shells.FactoryShellModel;
import whocraft.tardis_refined.client.model.blockentity.shell.shells.GroeningShellModel;
import whocraft.tardis_refined.client.model.blockentity.shell.shells.GrowthShellModel;
import whocraft.tardis_refined.client.model.blockentity.shell.shells.HalfBakedShellModel;
import whocraft.tardis_refined.client.model.blockentity.shell.shells.HieroglyphModel;
import whocraft.tardis_refined.client.model.blockentity.shell.shells.LiftShellModel;
import whocraft.tardis_refined.client.model.blockentity.shell.shells.MysticShellModel;
import whocraft.tardis_refined.client.model.blockentity.shell.shells.NukaShellModel;
import whocraft.tardis_refined.client.model.blockentity.shell.shells.PagodaShellModel;
import whocraft.tardis_refined.client.model.blockentity.shell.shells.PathfinderShellModel;
import whocraft.tardis_refined.client.model.blockentity.shell.shells.PhoneBoothModel;
import whocraft.tardis_refined.client.model.blockentity.shell.shells.PoliceBoxModel;
import whocraft.tardis_refined.client.model.blockentity.shell.shells.PortalooShellModel;
import whocraft.tardis_refined.client.model.blockentity.shell.shells.PresentShellModel;
import whocraft.tardis_refined.client.model.blockentity.shell.shells.ShulkerShellModel;
import whocraft.tardis_refined.client.model.blockentity.shell.shells.VendingMachineShellModel;
import whocraft.tardis_refined.common.tardis.themes.ShellTheme;
import whocraft.tardis_refined.compat.ModCompatChecker;

public class ShellModelCollection {
    public static Map<ResourceLocation, ShellEntry> SHELL_MODELS = new HashMap<ResourceLocation, ShellEntry>();
    private static ShellModel shulkerShellModel;
    private static ShellModel factoryShellModel;
    private static ShellModel policeBoxModel;
    private static ShellModel phoneBoothModel;
    private static ShellModel mysticModel;
    private static ShellModel drifterModel;
    private static ShellModel presentModel;
    private static ShellModel vendingModel;
    private static ShellModel briefcaseModel;
    private static ShellModel groeningModel;
    private static ShellModel bigBenModel;
    private static ShellModel nukaModel;
    private static ShellModel growthModel;
    private static ShellModel portalooModel;
    private static ShellModel pagodaModel;
    private static ShellModel liftModel;
    private static ShellModel hieroglyphModel;
    private static ShellModel castleShellModel;
    private static ShellModel pathfinderShellModel;
    private static ShellModel halfBakedShellModel;
    private static ShellDoorModel shulkerDoorModel;
    private static ShellDoorModel factoryDoorModel;
    private static ShellDoorModel policeBoxDoorModel;
    private static ShellDoorModel phoneBoothDoorModel;
    private static ShellDoorModel mysticDoorModel;
    private static ShellDoorModel drifterDoorModel;
    private static ShellDoorModel presentDoorModel;
    private static ShellDoorModel vendingDoorModel;
    private static ShellDoorModel briefcaseDoorModel;
    private static ShellDoorModel groeningDoorModel;
    private static ShellDoorModel bigBenDoorModel;
    private static ShellDoorModel nukaDoorModel;
    private static ShellDoorModel growthDoorModel;
    private static ShellDoorModel portalooDoorModel;
    private static ShellDoorModel pagodaDoorModel;
    private static ShellDoorModel liftDoorModel;
    private static ShellDoorModel hieroglyphDoorModel;
    private static ShellDoorModel castleDoorModel;
    private static ShellDoorModel pathfinderDoorModel;
    private static ShellDoorModel halfBakedDoorModel;
    private static ShellModelCollection instance;
    public static Logger LOGGER;

    public ShellModelCollection() {
        EntityModelSet context = Minecraft.m_91087_().m_167973_();
        this.registerModels(context);
    }

    public static void registerShellEntry(ShellTheme theme, ShellModel shellModel, ShellDoorModel shellDoorModel) {
        SHELL_MODELS.put(ShellTheme.getKey(theme), new ShellEntry(shellModel, shellDoorModel));
    }

    public static void registerShellEntry(ShellTheme theme, ShellEntry shellEntry) {
        SHELL_MODELS.put(ShellTheme.getKey(theme), shellEntry);
    }

    public static ShellModelCollection getInstance() {
        if (instance == null) {
            instance = new ShellModelCollection();
        }
        return instance;
    }

    public void registerModels(EntityModelSet context) {
        factoryShellModel = new FactoryShellModel(context.m_171103_(ModelRegistry.FACTORY_SHELL));
        policeBoxModel = new PoliceBoxModel(context.m_171103_(ModelRegistry.POLICE_BOX_SHELL));
        phoneBoothModel = new PhoneBoothModel(context.m_171103_(ModelRegistry.PHONE_BOOTH_SHELL));
        mysticModel = new MysticShellModel(context.m_171103_(ModelRegistry.MYSTIC_SHELL));
        drifterModel = new DrifterShellModel(context.m_171103_(ModelRegistry.DRIFTER_SHELL));
        presentModel = new PresentShellModel(context.m_171103_(ModelRegistry.PRESENT_SHELL));
        vendingModel = new VendingMachineShellModel(context.m_171103_(ModelRegistry.VENDING_SHELL));
        briefcaseModel = new BriefcaseShellModel(context.m_171103_(ModelRegistry.BRIEFCASE_SHELL));
        groeningModel = new GroeningShellModel(context.m_171103_(ModelRegistry.GROENING_SHELL));
        bigBenModel = new BigBenShellModel(context.m_171103_(ModelRegistry.BIG_BEN_SHELL));
        nukaModel = new NukaShellModel(context.m_171103_(ModelRegistry.NUKA_SHELL));
        growthModel = new GrowthShellModel(context.m_171103_(ModelRegistry.GROWTH_SHELL));
        portalooModel = new PortalooShellModel(context.m_171103_(ModelRegistry.PORTALOO_SHELL));
        pagodaModel = new PagodaShellModel(context.m_171103_(ModelRegistry.PAGODA_SHELL));
        liftModel = new LiftShellModel(context.m_171103_(ModelRegistry.LIFT_SHELL));
        hieroglyphModel = new HieroglyphModel(context.m_171103_(ModelRegistry.HIEROGLYPH_SHELL));
        castleShellModel = new CastleShellModel(context.m_171103_(ModelRegistry.CASTLE_SHELL));
        pathfinderShellModel = new PathfinderShellModel(context.m_171103_(ModelRegistry.PATHFINDER_SHELL));
        halfBakedShellModel = new HalfBakedShellModel(context.m_171103_(ModelRegistry.HALF_BAKED_SHELL));
        shulkerShellModel = new ShulkerShellModel(context.m_171103_(ModelRegistry.SHULKER_SHELL));
        factoryDoorModel = new DualInteriorDoorModel(context.m_171103_(ModelRegistry.FACTORY_DOOR), 250.0f);
        mysticDoorModel = new DualInteriorDoorModel(context.m_171103_(ModelRegistry.MYSTIC_DOOR), 250.0f);
        nukaDoorModel = new DualInteriorDoorModel(context.m_171103_(ModelRegistry.NUKA_DOOR), 250.0f);
        castleDoorModel = new DualInteriorDoorModel(context.m_171103_(ModelRegistry.CASTLE_DOOR), -90.0f);
        pathfinderDoorModel = new DualInteriorDoorModel(context.m_171103_(ModelRegistry.PATHFINDER_DOOR), 275.0f);
        policeBoxDoorModel = new DualInteriorDoorModel(context.m_171103_(ModelRegistry.POLICE_BOX_DOOR), 300.0f, true, false);
        bigBenDoorModel = new SingleInteriorDoorModel(context.m_171103_(ModelRegistry.BIG_BEN_DOOR), 275.0f);
        phoneBoothDoorModel = new SingleInteriorDoorModel(context.m_171103_(ModelRegistry.PHONE_BOOTH_DOOR), ModCompatChecker.immersivePortals() ? 1.75f : -1.75f);
        portalooDoorModel = new SingleInteriorDoorModel(context.m_171103_(ModelRegistry.PORTALOO_DOOR), ModCompatChecker.immersivePortals() ? 1.75f : -1.75f);
        groeningDoorModel = new SingleInteriorDoorModel(context.m_171103_(ModelRegistry.GROENING_DOOR), -275.0f);
        drifterDoorModel = new SingleTexInteriorDoorModel(context.m_171103_(ModelRegistry.DRIFTER_DOOR));
        vendingDoorModel = new SingleTexInteriorDoorModel(context.m_171103_(ModelRegistry.VENDING_DOOR));
        presentDoorModel = new PresentDoorModel(context.m_171103_(ModelRegistry.PRESENT_DOOR));
        briefcaseDoorModel = new BriefcaseDoorModel(context.m_171103_(ModelRegistry.BRIEFCASE_DOOR));
        growthDoorModel = new GrowthDoorModel(context.m_171103_(ModelRegistry.GROWTH_DOOR));
        pagodaDoorModel = new SingleInteriorDoorModel(context.m_171103_(ModelRegistry.PAGODA_DOOR), -275.0f);
        liftDoorModel = new DualTexInteriorDoorModel(context.m_171103_(ModelRegistry.LIFT_DOOR));
        hieroglyphDoorModel = new DualTexInteriorDoorModel(context.m_171103_(ModelRegistry.HIEROGLYPH_DOOR));
        halfBakedDoorModel = new HalfBakedDoorModel(context.m_171103_(ModelRegistry.HALF_BAKED_DOOR));
        shulkerDoorModel = new ShulkerDoorModel(context.m_171103_(ModelRegistry.SHULKER_DOOR));
        TardisClientEvents.SHELLENTRY_MODELS_SETUP.invoker().setUpShellAndInteriorModels(context);
        ShellModelCollection.registerShellEntry(ShellTheme.FACTORY.get(), factoryShellModel, factoryDoorModel);
        ShellModelCollection.registerShellEntry(ShellTheme.POLICE_BOX.get(), policeBoxModel, policeBoxDoorModel);
        ShellModelCollection.registerShellEntry(ShellTheme.PHONE_BOOTH.get(), phoneBoothModel, phoneBoothDoorModel);
        ShellModelCollection.registerShellEntry(ShellTheme.MYSTIC.get(), mysticModel, mysticDoorModel);
        ShellModelCollection.registerShellEntry(ShellTheme.DRIFTER.get(), drifterModel, drifterDoorModel);
        ShellModelCollection.registerShellEntry(ShellTheme.PRESENT.get(), presentModel, presentDoorModel);
        ShellModelCollection.registerShellEntry(ShellTheme.VENDING.get(), vendingModel, vendingDoorModel);
        ShellModelCollection.registerShellEntry(ShellTheme.BRIEFCASE.get(), briefcaseModel, briefcaseDoorModel);
        ShellModelCollection.registerShellEntry(ShellTheme.GROENING.get(), groeningModel, groeningDoorModel);
        ShellModelCollection.registerShellEntry(ShellTheme.BIG_BEN.get(), bigBenModel, bigBenDoorModel);
        ShellModelCollection.registerShellEntry(ShellTheme.NUKA.get(), nukaModel, nukaDoorModel);
        ShellModelCollection.registerShellEntry(ShellTheme.GROWTH.get(), growthModel, growthDoorModel);
        ShellModelCollection.registerShellEntry(ShellTheme.PORTALOO.get(), portalooModel, portalooDoorModel);
        ShellModelCollection.registerShellEntry(ShellTheme.PAGODA.get(), pagodaModel, pagodaDoorModel);
        ShellModelCollection.registerShellEntry(ShellTheme.LIFT.get(), liftModel, liftDoorModel);
        ShellModelCollection.registerShellEntry(ShellTheme.HIEROGLYPH.get(), hieroglyphModel, hieroglyphDoorModel);
        ShellModelCollection.registerShellEntry(ShellTheme.CASTLE.get(), castleShellModel, castleDoorModel);
        ShellModelCollection.registerShellEntry(ShellTheme.PATHFINDER.get(), pathfinderShellModel, pathfinderDoorModel);
        ShellModelCollection.registerShellEntry(ShellTheme.HALF_BAKED.get(), halfBakedShellModel, halfBakedDoorModel);
        ShellModelCollection.registerShellEntry(ShellTheme.SHULKER.get(), shulkerShellModel, shulkerDoorModel);
        this.validateShellModels();
    }

    private void validateShellModels() {
        for (ResourceLocation resourceLocation : ShellTheme.SHELL_THEME_DEFERRED_REGISTRY.keySet()) {
            Validate.isTrue((boolean)SHELL_MODELS.containsKey(resourceLocation), (String)String.format("Missing registered model for shell theme: %s", resourceLocation), (Object[])new Object[0]);
        }
    }

    public ShellEntry getShellEntry(ResourceLocation themeId) {
        return SHELL_MODELS.get(themeId);
    }

    static {
        instance = null;
        LOGGER = LogManager.getLogger((String)"TardisRefined/ShellPatternProvider");
    }
}

