/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.client.renderer.blockentity.console;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import whocraft.tardis_refined.client.TRShaders;
import whocraft.tardis_refined.client.TardisClientData;
import whocraft.tardis_refined.client.model.blockentity.console.ConsoleModelCollection;
import whocraft.tardis_refined.client.model.blockentity.console.ConsoleUnit;
import whocraft.tardis_refined.client.model.blockentity.shell.ShellModel;
import whocraft.tardis_refined.client.model.blockentity.shell.ShellModelCollection;
import whocraft.tardis_refined.client.renderer.RenderHelper;
import whocraft.tardis_refined.client.screen.screens.ShellSelectionScreen;
import whocraft.tardis_refined.common.block.console.GlobalConsoleBlock;
import whocraft.tardis_refined.common.blockentity.console.GlobalConsoleBlockEntity;
import whocraft.tardis_refined.common.tardis.themes.ConsoleTheme;
import whocraft.tardis_refined.patterns.ShellPattern;
import whocraft.tardis_refined.patterns.ShellPatterns;

public class GlobalConsoleRenderer
implements BlockEntityRenderer<GlobalConsoleBlockEntity>,
BlockEntityRendererProvider<GlobalConsoleBlockEntity> {
    private static final Vec3 crystalHolo = new Vec3((double)0.3f, -1.725, 0.655);
    private static final Vec3 crystalHoloColor = new Vec3(1.0, (double)0.64f, 0.0);
    private static final Vec3 initiativeHolo = new Vec3(-1.23, -1.225, (double)1.775f);
    private static final Vec3 initiativeHoloColor = new Vec3(0.0, (double)0.8f, 1.0);

    public GlobalConsoleRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(GlobalConsoleBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        poseStack.m_85836_();
        poseStack.m_252880_(0.5f, 1.5f, 0.5f);
        poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        ResourceLocation theme = blockEntity.theme();
        BlockState blockState = blockEntity.m_58900_();
        Level level = blockEntity.m_58904_();
        ConsoleUnit consoleModel = ConsoleModelCollection.getInstance().getConsoleEntry(theme).getConsoleModel(blockEntity.pattern());
        consoleModel.renderConsole(blockEntity, level, poseStack, bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)consoleModel.getTexture(blockEntity))), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (blockEntity != null && ((Boolean)blockState.m_61143_((Property)GlobalConsoleBlock.POWERED)).booleanValue() && blockEntity.pattern() != null && blockEntity.pattern().patternTexture().emissive()) {
            consoleModel.renderConsole(blockEntity, level, poseStack, bufferSource.m_6299_(TRShaders.glow(consoleModel.getTexture(blockEntity, true), 0.5f)), 0xF00000, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        poseStack.m_85849_();
        if (blockEntity != null && ((Boolean)blockState.m_61143_((Property)GlobalConsoleBlock.POWERED)).booleanValue()) {
            if (theme.toString().equals(ConsoleTheme.CRYSTAL.getId().toString())) {
                this.renderHoloShell(crystalHolo, 270, blockEntity, poseStack, bufferSource, packedLight, crystalHoloColor);
            }
            if (theme.toString().equals(ConsoleTheme.INITIATIVE.getId().toString())) {
                this.renderHoloShell(initiativeHolo, 150, blockEntity, poseStack, bufferSource, packedLight, initiativeHoloColor);
            }
        }
    }

    private void renderHoloShell(Vec3 offset, int rotation, GlobalConsoleBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, Vec3 color) {
        Level level = blockEntity.m_58904_();
        if (level.f_46441_.m_188503_(20) != 0) {
            poseStack.m_85836_();
            TardisClientData reactions = TardisClientData.getInstance((ResourceKey<Level>)level.m_46472_());
            ResourceLocation shellTheme = reactions.getShellTheme();
            ResourceLocation shellPattern = reactions.getShellPattern();
            ShellPattern pattern = ShellPatterns.getPatternOrDefault(shellTheme, shellPattern);
            ShellModel model = ShellModelCollection.getInstance().getShellEntry(shellTheme).getShellModel(pattern);
            model.setDoorPosition(false);
            poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
            poseStack.m_85837_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
            if (reactions.isFlying()) {
                float floatingOffset = (float)Math.sin((double)level.m_46467_() / 15.0) * 0.05f;
                poseStack.m_252880_(0.0f, floatingOffset, 0.0f);
            }
            poseStack.m_252880_(level.f_46441_.m_188501_() * 0.005f - 0.0025f, level.f_46441_.m_188501_() * 0.005f - 0.0025f, level.f_46441_.m_188501_() * 0.005f - 0.0025f);
            float scaleModifier = 0.1f + (float)Math.sin((double)level.m_46467_() / 20.0) * 0.005f;
            poseStack.m_85841_(scaleModifier, scaleModifier, scaleModifier);
            if (reactions.isFlying()) {
                long time = System.currentTimeMillis();
                float timeFactor = (float)(time % 4000L) / 4000.0f * ((float)Math.PI * 2);
                float xR = (float)Math.sin(timeFactor * 2.0f) * 15.0f;
                float yR = timeFactor * 360.0f / ((float)Math.PI * 2) % 360.0f * (float)reactions.getThrottleStage();
                float zR = (float)Math.cos(timeFactor * 3.0f) * 10.0f;
                boolean control = true;
                RenderHelper.rotateZYX(poseStack, xR * (float)control, yR * (float)control, zR * (float)control);
            } else {
                poseStack.m_252781_(Axis.f_252436_.m_252977_((float)(rotation % 360)));
            }
            if (ShellSelectionScreen.GLOBALSHELL_BLOCKENTITY == null) {
                ShellSelectionScreen.generateDummyGlobalShell();
            }
            ShellSelectionScreen.GLOBALSHELL_BLOCKENTITY.setTardisId(reactions.getLevelKey());
            float flickerAlpha = 0.2f + level.f_46441_.m_188501_() * 0.1f;
            boolean recoveryOrCrashing = reactions.isCrashing() || reactions.isInRecovery();
            float time = (float)level.m_46467_() / 100.0f;
            float red = recoveryOrCrashing ? 0.5f + (float)Math.sin(time) * 0.5f : (float)color.f_82479_;
            float green = recoveryOrCrashing ? 0.5f + (float)Math.sin((double)time + 1.5707963267948966) * 0.5f : (float)color.f_82480_;
            float blue = recoveryOrCrashing ? 0.5f + (float)Math.sin((double)time + Math.PI) * 0.5f : (float)color.f_82481_;
            model.setIgnoreAnmationAlpha(!reactions.isTakingOff() && !reactions.isLanding());
            model.renderShell(ShellSelectionScreen.GLOBALSHELL_BLOCKENTITY, false, true, poseStack, bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)pattern.shellTexture().texture())), packedLight, OverlayTexture.f_118083_, red, green, blue, flickerAlpha);
            model.setIgnoreAnmationAlpha(false);
            poseStack.m_85849_();
        }
    }

    public boolean shouldRenderOffScreen(GlobalConsoleBlockEntity blockEntity) {
        return true;
    }

    public BlockEntityRenderer<GlobalConsoleBlockEntity> m_173570_(BlockEntityRendererProvider.Context context) {
        return new GlobalConsoleRenderer(context);
    }
}

