/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.client.renderer.blockentity.device;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import org.joml.Vector3f;
import whocraft.tardis_refined.client.renderer.RenderHelper;
import whocraft.tardis_refined.common.blockentity.device.AstralManipulatorBlockEntity;
import whocraft.tardis_refined.common.items.ScrewdriverItem;

public class AstralManipulatorRenderer
implements BlockEntityRenderer<AstralManipulatorBlockEntity>,
BlockEntityRendererProvider<AstralManipulatorBlockEntity> {
    public AstralManipulatorRenderer(BlockEntityRendererProvider.Context context) {
    }

    public BlockEntityRenderer<AstralManipulatorBlockEntity> m_173570_(BlockEntityRendererProvider.Context context) {
        return new AstralManipulatorRenderer(context);
    }

    public void render(AstralManipulatorBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        BlockPos pointA = blockEntity.getPointABlockPos();
        if (pointA != null && blockEntity.shouldDisplay()) {
            BlockPos pointB = blockEntity.getPointBBlockPos();
            float width = 1.0f;
            float height = 1.0f;
            float length = 1.0f;
            Vector3f centerOfBoth = new Vector3f(0.0f, 0.0f, 0.0f);
            if (pointB != null) {
                float xDiff = Math.abs(pointA.m_123341_() - pointB.m_123341_());
                float yDiff = Math.abs(pointA.m_123342_() - pointB.m_123342_());
                float zDiff = Math.abs(pointA.m_123343_() - pointB.m_123343_());
                int smallestPointX = Math.min(pointA.m_123341_(), pointB.m_123341_());
                int smallestPointY = Math.min(pointA.m_123342_(), pointB.m_123342_());
                int smallestPointZ = Math.min(pointA.m_123343_(), pointB.m_123343_());
                float xCenter = (float)smallestPointX + xDiff * 0.5f;
                float yCenter = (float)smallestPointY + yDiff * 0.5f;
                float zCenter = (float)smallestPointZ + zDiff * 0.5f;
                centerOfBoth = new Vector3f(xCenter, yCenter, zCenter);
                length = xDiff;
                height = yDiff;
                width = zDiff;
            }
            Vector3f centerPos = pointB != null ? centerOfBoth : new Vector3f((float)pointA.m_123341_(), (float)pointA.m_123342_(), (float)pointA.m_123343_());
            float posAOffsetX = (float)blockEntity.m_58899_().m_123341_() - centerPos.x - 0.5f;
            float posAOffsetY = (float)blockEntity.m_58899_().m_123342_() - centerPos.y - 0.5f;
            float posAOffsetZ = (float)blockEntity.m_58899_().m_123343_() - centerPos.z - 0.5f;
            float sine = (float)(Math.sin((double)((float)blockEntity.m_58904_().m_46467_() * 10.0f) * Math.PI / 8.0) * 0.125 + 0.125) * 0.25f;
            if ((double)sine < 0.001) {
                sine = 0.001f;
            }
            poseStack.m_85836_();
            poseStack.m_252880_(-posAOffsetX, -posAOffsetY, -posAOffsetZ);
            VertexConsumer vertexBuilder = bufferSource.m_6299_(RenderType.m_110502_());
            Item yCenter = Minecraft.m_91087_().f_91074_.m_6844_(EquipmentSlot.MAINHAND).m_41720_();
            if (yCenter instanceof ScrewdriverItem) {
                ScrewdriverItem screwdriverItem = (ScrewdriverItem)yCenter;
                Color color = new Color(screwdriverItem.m_41121_(Minecraft.m_91087_().f_91074_.m_6844_(EquipmentSlot.MAINHAND)));
                RenderHelper.drawGlowingBox(poseStack, vertexBuilder, length + 1.25f, height + 1.25f, width + 1.25f, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 0.2f, 0);
            } else {
                RenderHelper.drawGlowingBox(poseStack, vertexBuilder, length + 1.25f, height + 1.25f, width + 1.25f, 0.635f, 0.392f, 0.878f, 0.2f, 0);
            }
            poseStack.m_85849_();
        }
    }
}

