/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.client.screen.screens;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import whocraft.tardis_refined.client.screen.components.GenericMonitorSelectionList;
import whocraft.tardis_refined.client.screen.components.SelectionListEntry;
import whocraft.tardis_refined.client.screen.main.MonitorOS;
import whocraft.tardis_refined.common.VortexRegistry;
import whocraft.tardis_refined.common.network.messages.C2SChangeVortex;
import whocraft.tardis_refined.common.util.Platform;
import whocraft.tardis_refined.constants.ModMessages;

public class VortexSelectionScreen
extends MonitorOS {
    private final List<ResourceLocation> vortexList = VortexRegistry.VORTEX_DEFERRED_REGISTRY.keySet().stream().toList();

    public VortexSelectionScreen(ResourceLocation currentVortex) {
        super((Component)Component.m_237115_((String)ModMessages.UI_MONITOR_VORTEX), null);
        VortexSelectionScreen.currentVortex = currentVortex;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.setEvents(() -> this.selectVortex(currentVortex), () -> {
            if (this.PREVIOUS != null) {
                this.switchScreenToLeft(this.PREVIOUS);
            }
        });
        if (currentVortex == null) {
            currentVortex = this.vortexList.get(0);
        }
        int vPos = (this.f_96544_ - 130) / 2;
        this.addSubmitButton(this.f_96543_ / 2 + 90, this.f_96544_ - vPos - 25);
        this.addCancelButton(this.f_96543_ / 2 - 11, this.f_96544_ - vPos - 25);
    }

    public void selectVortex(ResourceLocation themeId) {
        assert (Minecraft.m_91087_().f_91074_ != null);
        new C2SChangeVortex((ResourceKey<Level>)Minecraft.m_91087_().f_91074_.m_9236_().m_46472_(), themeId).send();
    }

    @Override
    public void renderBackdrop(@NotNull GuiGraphics guiGraphics) {
        super.renderBackdrop(guiGraphics);
        PoseStack poseStack = guiGraphics.m_280168_();
        int hPos = (this.f_96543_ - 230) / 2;
        int vPos = (this.f_96544_ - 130) / 2;
        poseStack.m_85836_();
        int b = this.f_96544_ - vPos;
        int r = this.f_96543_ - hPos;
        int l1 = hPos + 57;
        int l2 = hPos + 115;
        guiGraphics.m_280509_(l2, vPos, r, b, -1072689136);
        poseStack.m_252781_(Axis.f_252403_.m_252977_(-90.0f));
        poseStack.m_252880_((float)(-this.f_96544_), 0.0f, 0.0f);
        guiGraphics.m_280024_(vPos, l1, b, l2, 0, -1072689136);
        poseStack.m_85849_();
    }

    public GenericMonitorSelectionList<SelectionListEntry> createSelectionList() {
        int leftPos = this.f_96543_ / 2;
        int topPos = (this.f_96544_ - 130) / 2;
        GenericMonitorSelectionList<SelectionListEntry> selectionList = new GenericMonitorSelectionList<SelectionListEntry>(this.f_96541_, 105, 80, leftPos, topPos + 15, topPos + 130 - 30, 12);
        selectionList.m_93488_(false);
        List<Object> values = VortexRegistry.VORTEX_DEFERRED_REGISTRY.entrySet().stream().toList();
        values = values.stream().sorted(Comparator.comparing(theme -> ((VortexRegistry)theme.getValue()).getDisplayName().toString())).toList();
        for (Map.Entry entry2 : values) {
            ResourceLocation vortId = VortexRegistry.VORTEX_DEFERRED_REGISTRY.getKey((VortexRegistry)entry2.getValue());
            String owner = Platform.getModName(((ResourceKey)entry2.getKey()).m_135782_().m_135827_());
            MutableComponent tooltip = Component.m_237113_((String)(ChatFormatting.BLUE + owner));
            SelectionListEntry selectionListEntry = new SelectionListEntry(((VortexRegistry)entry2.getValue()).getDisplayName(), entry -> {
                currentVortex = vortId;
                for (Object child : selectionList.m_6702_()) {
                    if (!(child instanceof SelectionListEntry)) continue;
                    SelectionListEntry current = (SelectionListEntry)((Object)((Object)((Object)child)));
                    current.setChecked(false);
                }
                entry.setChecked(true);
            }, leftPos);
            selectionListEntry.setTooltip((Component)tooltip);
            if (currentVortex.toString().equals(vortId.toString())) {
                selectionListEntry.setChecked(true);
            }
            selectionList.m_6702_().add(selectionListEntry);
        }
        return selectionList;
    }
}

