/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.client.screen.upgrades;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;
import whocraft.tardis_refined.client.screen.upgrades.BuyUpgradeScreen;
import whocraft.tardis_refined.client.screen.upgrades.UpgradeTab;
import whocraft.tardis_refined.client.screen.upgrades.UpgradeTabType;
import whocraft.tardis_refined.client.screen.upgrades.UpgradeWidget;
import whocraft.tardis_refined.common.capability.tardis.upgrades.Upgrade;
import whocraft.tardis_refined.common.capability.tardis.upgrades.UpgradeHandler;

public class UpgradesScreen
extends Screen {
    public static final ResourceLocation WINDOW = new ResourceLocation("tardis_refined", "textures/gui/upgrades/window.png");
    public static final ResourceLocation OVERLAY = new ResourceLocation("tardis_refined", "textures/gui/upgrades/upgrades_overlay.png");
    public static final ResourceLocation TABS = new ResourceLocation("tardis_refined", "textures/gui/upgrades/tabs.png");
    public static final ResourceLocation BACKDROP = new ResourceLocation("tardis_refined", "textures/gui/upgrades/upgrades.png");
    public static final ResourceLocation MAIN_UPGRADE_LOCKED = new ResourceLocation("tardis_refined", "textures/gui/sprites/upgrades/gallifreyan_frame_unobtained.png");
    public static final ResourceLocation SUB_UPGRADE_LOCKED = new ResourceLocation("tardis_refined", "textures/gui/sprites/upgrades/upgrade_frame_unobtained.png");
    public static final ResourceLocation SUB_UPGRADE = new ResourceLocation("tardis_refined", "textures/gui/sprites/upgrades/upgrade_frame_obtained.png");
    public static final ResourceLocation MAIN_UPGRADE = new ResourceLocation("tardis_refined", "textures/gui/sprites/upgrades/gallifreyan_frame_obtained.png");
    public static final ResourceLocation LOCKED = new ResourceLocation("tardis_refined", "textures/gui/sprites/upgrades/lock.png");
    public static final ResourceLocation UNOBTAINED_BOX = new ResourceLocation("tardis_refined", "textures/gui/sprites/upgrades/box_unobtained.png");
    public static final ResourceLocation OBTAINED_BOX = new ResourceLocation("tardis_refined", "textures/gui/sprites/upgrades/box_obtained.png");
    public static final ResourceLocation WIDGETS = new ResourceLocation("tardis_refined", "textures/gui/sprites/upgrades/widgets.png");
    public static final int WINDOW_WIDTH = 256;
    public static final int WINDOW_HEIGHT = 173;
    public static final int WINDOW_INSIDE_WIDTH = 224;
    public static final int WINDOW_INSIDE_HEIGHT = 123;
    private static final int WINDOW_INSIDE_X = 10;
    private static final int WINDOW_INSIDE_Y = 18;
    private static int tabPage;
    private static int maxPages;
    private final List<UpgradeTab> tabs = new ArrayList<UpgradeTab>();
    private final UpgradeHandler upgradeHandler;
    @Nullable
    public UpgradeTab selectedTab;
    public Screen overlayScreen = null;
    private boolean isScrolling;

    public UpgradesScreen(UpgradeHandler upgradeHandler) {
        super((Component)Component.m_237119_());
        this.upgradeHandler = upgradeHandler;
    }

    public static boolean isPotentialParentUnlocked(Upgrade upgrade, UpgradeHandler upgradeHandler) {
        if (upgrade.getParent() == null) {
            return true;
        }
        return upgrade.getParent().isUnlocked(upgradeHandler);
    }

    public static ResourceLocation getFrame(Upgrade.UpgradeType upgradeType, boolean isUnlocked) {
        if (isUnlocked) {
            return upgradeType == Upgrade.UpgradeType.MAIN_UPGRADE ? MAIN_UPGRADE : SUB_UPGRADE;
        }
        return upgradeType == Upgrade.UpgradeType.MAIN_UPGRADE ? MAIN_UPGRADE_LOCKED : SUB_UPGRADE_LOCKED;
    }

    public static ResourceLocation getBox(boolean isUnlocked) {
        return isUnlocked ? OBTAINED_BOX : UNOBTAINED_BOX;
    }

    protected void m_7856_() {
        this.tabs.clear();
        this.selectedTab = null;
        UpgradeTab upgradeTab = UpgradeTab.create(this.f_96541_, this, 0, this.upgradeHandler);
        this.tabs.add(upgradeTab);
        if (this.tabs.size() > UpgradeTabType.MAX_TABS) {
            int guiLeft = (this.f_96543_ - 256) / 2;
            int guiTop = (this.f_96544_ - 173) / 2;
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"<"), b -> {
                tabPage = Math.max(tabPage - 1, 0);
            }).m_252987_(guiLeft, guiTop - 50, 20, 20).m_253136_());
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)">"), b -> {
                tabPage = Math.min(tabPage + 1, maxPages);
            }).m_252987_(guiLeft + 256 - 20, guiTop - 50, 20, 20).m_253136_());
            maxPages = this.tabs.size() / UpgradeTabType.MAX_TABS;
        }
        if (!this.tabs.isEmpty()) {
            this.selectedTab = this.tabs.get(0);
        }
        if (this.overlayScreen != null) {
            this.overlayScreen.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            UpgradeWidget entry;
            int i = (this.f_96543_ - 256) / 2;
            int j = (this.f_96544_ - 173) / 2;
            if (this.isOverOverlayScreen(mouseX, mouseY)) {
                return this.overlayScreen.m_6375_(mouseX, mouseY, button);
            }
            for (UpgradeTab powerTab : this.tabs) {
                if (!powerTab.isMouseOver(i, j, mouseX, mouseY)) continue;
                this.selectedTab = powerTab;
                break;
            }
            if (this.selectedTab != null && (entry = this.selectedTab.getUpgradeHoveredOver((int)(mouseX - (double)i - 9.0), (int)(mouseY - (double)j - 18.0), i, j)) != null) {
                Upgrade upgrade = entry.upgradeEntry;
                boolean hasUnlockedParent = UpgradesScreen.isPotentialParentUnlocked(upgrade, this.upgradeHandler);
                if (upgrade.isUnlocked(this.upgradeHandler)) {
                    return false;
                }
                this.openOverlayScreen(new BuyUpgradeScreen(upgrade, hasUnlockedParent && !upgrade.isUnlocked(this.upgradeHandler) && this.upgradeHandler.getUpgradePoints() >= upgrade.getSkillPointsRequired(), this));
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        return this.overlayScreen == null ? super.m_7933_(keyCode, scanCode, modifiers) : this.overlayScreen.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int i = (this.f_96543_ - 256) / 2;
        int j = (this.f_96544_ - 173) / 2;
        guiGraphics.m_280024_(0, 0, this.f_96543_, this.f_96544_, -1072689136, -804253680);
        this.renderWindow(guiGraphics, i, j);
        this.renderInside(guiGraphics, mouseX, mouseY, i, j);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        if (this.selectedTab != null && this.overlayScreen != null) {
            guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 500.0f);
            this.overlayScreen.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
            this.selectedTab.fade = Mth.m_14036_((float)(this.selectedTab.fade + 0.02f), (float)0.0f, (float)0.5f);
            guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, -500.0f);
        }
        this.renderFinalOverlay(guiGraphics, i, j);
        this.renderTooltips(guiGraphics, mouseX, mouseY, i, j);
        if (this.upgradeHandler.getUpgradePoints() > 0) {
            guiGraphics.m_280056_(this.f_96541_.f_91062_, "Points: " + this.upgradeHandler.getUpgradePoints(), this.f_96543_ / 2 - this.f_96547_.m_92895_("Points: " + this.upgradeHandler.getUpgradePoints()) / 2, j + 173 - 15, ChatFormatting.BLACK.m_126665_().intValue(), false);
        }
        guiGraphics.m_280056_(this.f_96541_.f_91062_, "XP: " + this.upgradeHandler.getUpgradeXP() + " / 100", this.f_96543_ / 2 - this.f_96547_.m_92895_("XP: " + this.upgradeHandler.getUpgradeXP() + " / 100") / 2, j + 6, ChatFormatting.BLACK.m_126665_().intValue(), false);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (button != 0) {
            this.isScrolling = false;
            return false;
        }
        if (!this.isScrolling) {
            this.isScrolling = true;
        } else if (this.selectedTab != null) {
            this.selectedTab.scroll(dragX, dragY);
        }
        return true;
    }

    private void renderInside(GuiGraphics guiGraphics, int mouseX, int mouseY, int offsetX, int offsetY) {
        UpgradeTab tab = this.selectedTab;
        if (tab == null) {
            guiGraphics.m_280509_(offsetX + 10, offsetY + 18, offsetX + 10 + 224, offsetY + 18 + 123, -16777216);
        } else {
            tab.drawContents(guiGraphics, offsetX + 10, offsetY + 18);
        }
    }

    public void renderWindow(GuiGraphics guiGraphics, int offsetX, int offsetY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        guiGraphics.m_280218_(BACKDROP, offsetX, offsetY, 0, 0, 256, 173);
        if (this.tabs.size() > 1) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TABS);
            for (UpgradeTab tab : this.tabs) {
                tab.drawTab(guiGraphics, offsetX, offsetY, tab == this.selectedTab);
            }
            RenderSystem.defaultBlendFunc();
            for (UpgradeTab tab : this.tabs) {
                tab.drawIcon(guiGraphics, offsetX, offsetY);
            }
            RenderSystem.disableBlend();
        }
    }

    public void renderFinalOverlay(GuiGraphics guiGraphics, int offsetX, int offsetY) {
        guiGraphics.m_280218_(OVERLAY, offsetX, offsetY, 0, 0, 256, 173);
    }

    private void renderTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY, int offsetX, int offsetY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.selectedTab != null) {
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_((float)(offsetX + 10), (float)(offsetY + 18), 400.0f);
            RenderSystem.enableDepthTest();
            this.selectedTab.drawTooltips(guiGraphics, mouseX - offsetX - 10, mouseY - offsetY - 18, offsetX, offsetY, this.overlayScreen != null);
            RenderSystem.disableDepthTest();
            guiGraphics.m_280168_().m_85849_();
        }
        if (this.tabs.size() > 1) {
            for (UpgradeTab tab : this.tabs) {
                if (!tab.isMouseOver(offsetX, offsetY, mouseX, mouseY)) continue;
                guiGraphics.m_280557_(this.f_96547_, tab.getTitle(), mouseX, mouseY);
            }
        }
    }

    public void closeOverlayScreen() {
        this.overlayScreen = null;
    }

    public void openOverlayScreen(Screen screen) {
        this.closeOverlayScreen();
        this.overlayScreen = screen;
        this.overlayScreen.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
    }

    public boolean isOverOverlayScreen(double mouseX, double mouseY) {
        return this.overlayScreen != null;
    }
}

