/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.command.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import whocraft.tardis_refined.common.capability.tardis.upgrades.Upgrade;
import whocraft.tardis_refined.constants.ModMessages;
import whocraft.tardis_refined.registry.TRUpgrades;

public class UpgradeArgumentType
implements ArgumentType<ResourceLocation> {
    public static final DynamicCommandExceptionType INVALID_UPGRADE_EXCEPTION = new DynamicCommandExceptionType(upgrade -> Component.m_237110_((String)ModMessages.CMD_ARG_UPGRADE_INVALID, (Object[])new Object[]{upgrade}));
    private static final Collection<String> EXAMPLES = Stream.of(TRUpgrades.ARCHITECTURE_SYSTEM).map(upgrade -> upgrade != null ? upgrade.getId().toString() : "").collect(Collectors.toList());

    public static UpgradeArgumentType upgradeArgumentType() {
        return new UpgradeArgumentType();
    }

    public static Upgrade getUpgrade(CommandContext<CommandSourceStack> context, String name) throws CommandSyntaxException {
        ResourceLocation resourcelocation = (ResourceLocation)context.getArgument(name, ResourceLocation.class);
        Upgrade upgrade = TRUpgrades.UPGRADE_DEFERRED_REGISTRY.get(resourcelocation);
        if (upgrade == null) {
            throw INVALID_UPGRADE_EXCEPTION.create((Object)resourcelocation);
        }
        return upgrade;
    }

    public static ResourceLocation getUpgradeId(CommandContext<CommandSourceStack> context, String name) throws CommandSyntaxException {
        ResourceLocation resourcelocation = (ResourceLocation)context.getArgument(name, ResourceLocation.class);
        if (TRUpgrades.UPGRADE_DEFERRED_REGISTRY.get(resourcelocation) == null) {
            throw INVALID_UPGRADE_EXCEPTION.create((Object)resourcelocation);
        }
        return resourcelocation;
    }

    public ResourceLocation parse(StringReader reader) throws CommandSyntaxException {
        return ResourceLocation.m_135818_((StringReader)reader);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.m_82926_(TRUpgrades.UPGRADE_DEFERRED_REGISTRY.keySet(), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

