/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.command.sub;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;
import whocraft.tardis_refined.common.items.KeyItem;
import whocraft.tardis_refined.common.tardis.TardisNavLocation;
import whocraft.tardis_refined.common.tardis.manager.TardisPilotingManager;
import whocraft.tardis_refined.common.util.CommandHelper;
import whocraft.tardis_refined.common.util.PlayerUtil;
import whocraft.tardis_refined.constants.ModMessages;
import whocraft.tardis_refined.registry.TRDimensionTypes;

public class SummonCommand
implements Command<CommandSourceStack> {
    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher) {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"summon").then(Commands.m_82129_((String)"tardis", (ArgumentType)DimensionArgument.m_88805_()).suggests(CommandHelper.SUGGEST_TARDISES).executes(context -> SummonCommand.summonTardis((CommandContext<CommandSourceStack>)context, DimensionArgument.m_88808_((CommandContext)context, (String)"tardis"))))).executes(SummonCommand::summonTardisFromKey);
    }

    private static int summonTardis(CommandContext<CommandSourceStack> context, ServerLevel tardis) {
        Optional<TardisLevelOperator> tardisData = TardisLevelOperator.get(tardis);
        ServerPlayer sender = ((CommandSourceStack)context.getSource()).m_230896_();
        if (sender.m_9236_().m_220362_() == TRDimensionTypes.TARDIS) {
            PlayerUtil.sendMessage((LivingEntity)sender, (Component)Component.m_237113_((String)(ChatFormatting.RED + "You cannot Summon a TARDIS within a TARDIS.")), false);
            return 0;
        }
        if (tardisData.isPresent()) {
            TardisLevelOperator data = tardisData.get();
            TardisPilotingManager pilot = data.getPilotingManager();
            pilot.setHandbrakeOn(false);
            pilot.setTargetLocation(new TardisNavLocation(sender.m_20183_(), sender.m_6350_().m_122424_(), (ServerLevel)sender.m_9236_()));
            pilot.beginFlight(true);
            PlayerUtil.sendMessage((LivingEntity)sender, (Component)Component.m_237115_((String)ModMessages.TARDIS_IS_ON_THE_WAY), true);
            return 1;
        }
        return 0;
    }

    private static int summonTardisFromKey(CommandContext<CommandSourceStack> context) {
        ResourceKey<Level> tardisDimKey;
        ServerLevel tardisLevel;
        ArrayList<ResourceKey<Level>> keychain;
        ServerPlayer sender = ((CommandSourceStack)context.getSource()).m_230896_();
        ItemStack mainHandItem = sender.m_21205_();
        if (mainHandItem.m_41720_() instanceof KeyItem && !(keychain = KeyItem.getKeychain(mainHandItem)).isEmpty() && (tardisLevel = sender.f_8924_.m_129880_(tardisDimKey = keychain.get(0))) != null) {
            return SummonCommand.summonTardis(context, tardisLevel);
        }
        PlayerUtil.sendMessage((LivingEntity)sender, (Component)Component.m_237113_((String)(ChatFormatting.RED + "You must specify a TARDIS dimension or hold a valid TARDIS key.")), false);
        return 0;
    }

    public int run(CommandContext<CommandSourceStack> context) {
        return 0;
    }
}

