/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.block;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import whocraft.tardis_refined.common.block.shell.RootedShellBlock;
import whocraft.tardis_refined.common.blockentity.shell.RootPlantBlockEntity;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;
import whocraft.tardis_refined.common.util.ClientHelper;
import whocraft.tardis_refined.common.util.TardisHelper;
import whocraft.tardis_refined.registry.TRBlockRegistry;
import whocraft.tardis_refined.registry.TRDimensionTypes;

public class RootPlantBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final IntegerProperty AGE = BlockStateProperties.f_61408_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public RootPlantBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING, AGE, WATERLOGGED});
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 5;
    }

    protected int getAge(BlockState blockState) {
        return (Integer)blockState.m_61143_((Property)this.getAgeProperty());
    }

    public boolean isMaxAge(BlockState blockState) {
        return (Integer)blockState.m_61143_((Property)this.getAgeProperty()) >= this.getMaxAge();
    }

    public BlockState m_5573_(@NotNull BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        boolean waterlogged = fluidState.m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)context.m_8125_())).m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(this.getAge(state)))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
    }

    private BlockState getStateForAging(int ageValue, Direction facing) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(ageValue))).m_61124_((Property)FACING, (Comparable)facing);
    }

    public boolean m_6724_(BlockState blockState) {
        return !this.isMaxAge(blockState);
    }

    public void m_214162_(BlockState blockState, Level level, BlockPos blockPos, RandomSource randomSource) {
        super.m_214162_(blockState, level, blockPos, randomSource);
        if (level.m_8055_(blockPos.m_7495_()).m_60734_() == Blocks.f_50450_) {
            ClientHelper.playParticle((ClientLevel)level, (ParticleOptions)ParticleTypes.f_123789_, new Vec3((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_(), (double)blockPos.m_123343_() + 0.5), 0.0, 0.1, 0.0);
        }
    }

    public void m_213898_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        int age = this.getAge(blockState);
        Direction facing = (Direction)blockState.m_61143_((Property)FACING);
        if (age < this.getMaxAge() && serverLevel.m_8055_(blockPos.m_7495_()).m_60734_() == Blocks.f_50450_ && randomSource.m_188503_(6) == 0) {
            boolean waterlogged;
            FluidState fluidState = serverLevel.m_6425_(blockPos);
            boolean bl = waterlogged = fluidState.m_76152_() == Fluids.f_76193_;
            if (age + 1 == this.getMaxAge()) {
                serverLevel.m_7471_(blockPos, waterlogged);
                serverLevel.m_7731_(blockPos, (BlockState)((BlockState)TRBlockRegistry.ROOT_SHELL_BLOCK.get().m_49966_().m_61124_((Property)RootedShellBlock.FACING, (Comparable)facing)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged)), 3);
            } else {
                serverLevel.m_7471_(blockPos, waterlogged);
                serverLevel.m_7731_(blockPos, (BlockState)this.getStateForAging(age + 1, facing).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged)), 3);
                double d = blockState.m_60808_((BlockGetter)serverLevel, blockPos).m_83290_(Direction.Axis.Y, 0.5, 0.5) + 0.03125;
                double g = randomSource.m_188583_() * 0.02;
                double h = randomSource.m_188583_() * 0.02;
                double j = randomSource.m_188583_() * 0.02;
                for (int i = 0; i < 10; ++i) {
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123749_, (double)blockPos.m_123341_() + (double)0.13125f + (double)0.7375f * (double)randomSource.m_188501_(), (double)blockPos.m_123342_() + d + (double)randomSource.m_188501_() * 1.0, (double)blockPos.m_123343_() + (double)0.13125f + (double)0.7375f * (double)randomSource.m_188501_(), 120, g, h, j, 0.005);
                }
            }
            serverLevel.m_5594_(null, blockPos, SoundEvents.f_184217_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new RootPlantBlockEntity(blockPos, blockState);
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)5.0, (double)11.0);
    }

    public void m_6807_(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean bl) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (level.m_220362_() == TRDimensionTypes.TARDIS) {
                TardisLevelOperator.get(serverLevel).ifPresent(TardisHelper::playCloisterBell);
                serverLevel.m_46961_(blockPos, true);
                return;
            }
        }
        super.m_6807_(blockState, level, blockPos, blockState2, bl);
        if (level.m_8055_(blockPos.m_7495_()).m_60734_() == Blocks.f_50450_) {
            level.m_5594_(null, blockPos, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 1.25f);
        }
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        if (((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(blockPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        return super.m_7417_(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
    }

    public FluidState m_5888_(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(blockState);
    }
}

