/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.block.console;

import java.util.Optional;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.LeadItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import whocraft.tardis_refined.client.TardisClientData;
import whocraft.tardis_refined.common.blockentity.console.GlobalConsoleBlockEntity;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;
import whocraft.tardis_refined.common.tardis.manager.TardisPilotingManager;
import whocraft.tardis_refined.common.util.ClientHelper;
import whocraft.tardis_refined.common.util.PlayerUtil;
import whocraft.tardis_refined.constants.ModMessages;
import whocraft.tardis_refined.patterns.ConsolePatterns;
import whocraft.tardis_refined.registry.TRDimensionTypes;

public class GlobalConsoleBlock
extends BaseEntityBlock {
    public static final BooleanProperty POWERED = BooleanProperty.m_61465_((String)"powered");

    public GlobalConsoleBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new GlobalConsoleBlockEntity(blockPos, blockState);
    }

    protected void m_142387_(Level level, Player player, BlockPos pos, BlockState state) {
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{POWERED});
    }

    public BlockState m_5573_(@NotNull BlockPlaceContext blockPlaceContext) {
        BlockState state = super.m_5573_(blockPlaceContext);
        return (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }

    public void m_6807_(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean bl) {
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof GlobalConsoleBlockEntity) {
            GlobalConsoleBlockEntity globalConsoleBlockEntity = (GlobalConsoleBlockEntity)blockEntity;
            ResourceLocation theme = globalConsoleBlockEntity.theme();
            globalConsoleBlockEntity.setConsoleTheme(theme);
            globalConsoleBlockEntity.setPattern(ConsolePatterns.DEFAULT);
            globalConsoleBlockEntity.markDirty();
        }
        super.m_6807_(blockState, level, blockPos, blockState2, bl);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return (level1, blockPos, blockState, t) -> {
            if (t instanceof GlobalConsoleBlockEntity) {
                GlobalConsoleBlockEntity globalConsoleBlock = (GlobalConsoleBlockEntity)t;
                globalConsoleBlock.tick(level, blockPos, blockState, globalConsoleBlock);
            }
        };
    }

    public void m_6810_(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean bl) {
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof GlobalConsoleBlockEntity) {
            GlobalConsoleBlockEntity globalConsoleBlock = (GlobalConsoleBlockEntity)blockEntity;
            globalConsoleBlock.killControls();
        }
        super.m_6810_(blockState, level, blockPos, blockState2, bl);
    }

    public void m_6786_(LevelAccessor levelAccessor, BlockPos blockPos, BlockState blockState) {
        BlockEntity blockEntity = levelAccessor.m_7702_(blockPos);
        if (blockEntity instanceof GlobalConsoleBlockEntity) {
            GlobalConsoleBlockEntity globalConsoleBlock = (GlobalConsoleBlockEntity)blockEntity;
            globalConsoleBlock.killControls();
        }
        levelAccessor.m_5594_(null, blockPos, SoundEvents.f_11664_, SoundSource.BLOCKS, 1.0f, 1.0f);
        super.m_6786_(levelAccessor, blockPos, blockState);
    }

    public void m_214162_(BlockState blockState, Level level, BlockPos blockPos, RandomSource randomSource) {
        super.m_214162_(blockState, level, blockPos, randomSource);
        TardisClientData clientData = TardisClientData.getInstance((ResourceKey<Level>)level.m_46472_());
        if (!((Boolean)blockState.m_61143_((Property)POWERED)).booleanValue()) {
            return;
        }
        if (clientData != null) {
            double xCord = (double)blockPos.m_123341_() + (double)randomSource.m_188501_() * 1.5;
            double yCord = (double)blockPos.m_123342_() + randomSource.m_188500_() + 0.5;
            double zCord = (double)blockPos.m_123343_() + (double)randomSource.m_188501_() * 1.5;
            if (level.f_46441_.m_188503_(5) == 0) {
                ClientHelper.playParticle((ClientLevel)level, (ParticleOptions)ParticleTypes.f_123796_, new Vec3(xCord, yCord, zCord), 0.0, 0.05, 0.0);
            }
            if (clientData.isFlying() && level.f_46441_.m_188503_(1) == 0) {
                ClientHelper.playParticle((ClientLevel)level, (ParticleOptions)ParticleTypes.f_123796_, new Vec3(xCord, yCord, zCord), 0.0, 0.05, 0.0);
            }
            if (clientData.isInRecovery() || clientData.isCrashing()) {
                int i;
                ClientHelper.playParticle((ClientLevel)level, (ParticleOptions)ParticleTypes.f_123777_, new Vec3(xCord, yCord, zCord), 0.0, 0.1, 0.0);
                for (i = 0; i < 5; ++i) {
                    ClientHelper.playParticle((ClientLevel)level, (ParticleOptions)ParticleTypes.f_123755_, new Vec3(xCord, yCord, zCord), 0.0, 0.1, 0.0);
                }
                if (level.f_46441_.m_188503_(10) == 0) {
                    for (i = 0; i < 3; ++i) {
                        ClientHelper.playParticle((ClientLevel)level, (ParticleOptions)ParticleTypes.f_123756_, new Vec3(xCord, yCord, zCord), -0.5 + (double)level.f_46441_.m_188501_(), 0.05, -0.5 + (double)level.f_46441_.m_188501_());
                    }
                    level.m_7785_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), SoundEvents.f_12031_, SoundSource.BLOCKS, 1.0f, level.m_213780_().m_188501_() + 1.0f, false);
                }
            }
        }
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        BlockEntity blockEntity;
        if (!player.m_9236_().m_5776_() && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (level.m_220362_() == TRDimensionTypes.TARDIS) {
                TardisLevelOperator operator2;
                TardisPilotingManager pilotManager;
                Optional<TardisLevelOperator> operatorOptional;
                TardisLevelOperator.get(serverLevel).ifPresent(operator -> {
                    TardisPilotingManager pilotingManager = operator.getPilotingManager();
                    BlockEntity patt7845$temp = serverLevel.m_7702_(blockPos);
                    if (patt7845$temp instanceof GlobalConsoleBlockEntity) {
                        GlobalConsoleBlockEntity consoleBlockEntity = (GlobalConsoleBlockEntity)patt7845$temp;
                        if (pilotingManager.getCurrentConsole() != null) {
                            if (pilotingManager.getCurrentConsole() != consoleBlockEntity) {
                                if (!pilotingManager.isInFlight()) {
                                    pilotingManager.setCurrentConsole(consoleBlockEntity);
                                    consoleBlockEntity.setTicksBooting(1);
                                } else {
                                    PlayerUtil.sendMessage((LivingEntity)player, ModMessages.CONSOLE_NOT_IN_FLIGHT, true);
                                }
                            }
                        } else {
                            pilotingManager.setCurrentConsole(consoleBlockEntity);
                            consoleBlockEntity.m_58483_();
                        }
                    }
                });
                if (player.m_7500_() && player.m_21120_(interactionHand).m_41720_() == Items.f_41980_ && (operatorOptional = TardisLevelOperator.get(serverLevel)).isPresent() && (pilotManager = (operator2 = operatorOptional.get()).getPilotingManager()).isInRecovery()) {
                    pilotManager.endRecovery();
                    return InteractionResult.m_19078_((boolean)false);
                }
                if (player.m_21120_(interactionHand).m_41720_() == Items.f_42655_ && !level.f_46443_) {
                    LeadItem.m_42829_((Player)player, (Level)level, (BlockPos)blockPos);
                    return InteractionResult.m_19078_((boolean)false);
                }
            }
        }
        if (level.f_46443_ && (blockEntity = level.m_7702_(blockPos)) instanceof GlobalConsoleBlockEntity) {
            GlobalConsoleBlockEntity consoleBlockEntity = (GlobalConsoleBlockEntity)blockEntity;
            if (!((Boolean)blockState.m_61143_((Property)POWERED)).booleanValue()) {
                consoleBlockEntity.powerOff.m_216973_();
                consoleBlockEntity.powerOn.m_216977_(player.f_19797_);
            }
        }
        return InteractionResult.m_19078_((boolean)true);
    }

    public boolean m_7357_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, PathComputationType pathComputationType) {
        return false;
    }
}

