/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.block.door;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import whocraft.tardis_refined.common.blockentity.door.BulkHeadDoorBlockEntity;
import whocraft.tardis_refined.registry.TRItemRegistry;
import whocraft.tardis_refined.registry.TRSoundRegistry;

public class BulkHeadDoorBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty OPEN = BooleanProperty.m_61465_((String)"open");
    public static final BooleanProperty LOCKED = BooleanProperty.m_61465_((String)"locked");
    public static final EnumProperty<BulkHeadType> TYPE = EnumProperty.m_61587_((String)"bulkhead", BulkHeadType.class);

    public BulkHeadDoorBlock(BlockBehaviour.Properties properties) {
        super(properties.m_60918_(SoundType.f_56749_));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(TYPE, (Comparable)((Object)BulkHeadType.MODERN))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LOCKED, (Comparable)Boolean.valueOf(true)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING, OPEN, LOCKED, TYPE});
    }

    public BlockState m_5573_(@NotNull BlockPlaceContext blockPlaceContext) {
        BlockState state = super.m_5573_(blockPlaceContext);
        if (this.m_7898_(state, (LevelReader)blockPlaceContext.m_43725_(), blockPlaceContext.m_8083_())) {
            return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)blockPlaceContext.m_8125_())).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LOCKED, (Comparable)Boolean.valueOf(false))).m_61124_(TYPE, (Comparable)((Object)BulkHeadType.MODERN));
        }
        return null;
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new BulkHeadDoorBlockEntity(blockPos, blockState);
    }

    public void m_6807_(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean bl) {
        super.m_6807_(blockState, level, blockPos, blockState2, bl);
        if (((Boolean)blockState.m_61143_((Property)OPEN)).booleanValue()) {
            this.changeBlockStates(level, blockPos, blockState, Blocks.f_50016_.m_49966_());
        } else {
            this.changeBlockStates(level, blockPos, blockState, Blocks.f_50375_.m_49966_());
        }
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (player.m_21120_(interactionHand).m_41720_() == TRItemRegistry.PATTERN_MANIPULATOR.get() && blockState.m_61138_(TYPE)) {
            BlockState nextType = (BlockState)blockState.m_61122_(TYPE);
            level.m_7731_(blockPos, nextType, 3);
            level.m_5594_(player, blockPos, TRSoundRegistry.PATTERN_MANIPULATOR.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(blockState, level, blockPos, player, interactionHand, blockHitResult);
    }

    public void m_6240_(Level level, Player player, BlockPos blockPos, BlockState blockState, @Nullable BlockEntity blockEntity, ItemStack itemStack) {
        super.m_6240_(level, player, blockPos, blockState, blockEntity, itemStack);
        this.m_6786_((LevelAccessor)level, blockPos, blockState);
    }

    public void m_6786_(LevelAccessor levelAccessor, BlockPos blockPos, BlockState blockState) {
        super.m_6786_(levelAccessor, blockPos, blockState);
        this.changeBlockStates((Level)levelAccessor, blockPos, blockState, Blocks.f_50016_.m_49966_());
    }

    private void changeBlockStates(Level level, BlockPos blockPos, BlockState blockState, BlockState blockToSet) {
        level.m_7731_(blockPos.m_7494_(), blockToSet, 2);
        level.m_7731_(blockPos.m_6630_(2), blockToSet, 2);
        if (blockState.m_61143_((Property)FACING) == Direction.NORTH || blockState.m_61143_((Property)FACING) == Direction.SOUTH) {
            level.m_7731_(blockPos.m_122029_(), blockToSet, 2);
            level.m_7731_(blockPos.m_7494_().m_122029_(), blockToSet, 2);
            level.m_7731_(blockPos.m_6630_(2).m_122029_(), blockToSet, 2);
            level.m_7731_(blockPos.m_122024_(), blockToSet, 2);
            level.m_7731_(blockPos.m_7494_().m_122024_(), blockToSet, 2);
            level.m_7731_(blockPos.m_6630_(2).m_122024_(), blockToSet, 2);
        }
        if (blockState.m_61143_((Property)FACING) == Direction.EAST || blockState.m_61143_((Property)FACING) == Direction.WEST) {
            level.m_7731_(blockPos.m_122012_(), blockToSet, 2);
            level.m_7731_(blockPos.m_7494_().m_122012_(), blockToSet, 2);
            level.m_7731_(blockPos.m_6630_(2).m_122012_(), blockToSet, 2);
            level.m_7731_(blockPos.m_122019_(), blockToSet, 2);
            level.m_7731_(blockPos.m_7494_().m_122019_(), blockToSet, 2);
            level.m_7731_(blockPos.m_6630_(2).m_122019_(), blockToSet, 2);
        }
    }

    public void m_6402_(Level level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity livingEntity, ItemStack itemStack) {
        super.m_6402_(level, blockPos, blockState, livingEntity, itemStack);
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        return this.checkAirBlockStates(world, pos) && super.m_7898_(state, world, pos);
    }

    private boolean checkAirBlockStates(LevelReader world, BlockPos pos) {
        for (int y = 0; y < 3; ++y) {
            for (int x = -1; x < 2; ++x) {
                for (int z = -1; z < 2; ++z) {
                    BlockPos checkPos = pos.m_7918_(x, y, z);
                    BlockState checkState = world.m_8055_(checkPos);
                    if (checkState.m_60795_() || checkState.m_60713_((Block)this)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public VoxelShape m_5939_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return (Boolean)blockState.m_61143_((Property)OPEN) != false ? Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0) : Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return (level1, blockPos, blockState, t) -> {
            if (t instanceof BulkHeadDoorBlockEntity) {
                BulkHeadDoorBlockEntity bulkHeadDoorBlockEntity = (BulkHeadDoorBlockEntity)t;
                bulkHeadDoorBlockEntity.tick(pLevel, blockPos, blockState, bulkHeadDoorBlockEntity);
            }
        };
    }

    public static enum BulkHeadType implements StringRepresentable
    {
        ROUGH("rough"),
        MODERN("modern");

        private final String name;

        private BulkHeadType(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

