/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.block.door;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import whocraft.tardis_refined.common.blockentity.door.InternalDoorBlockEntity;
import whocraft.tardis_refined.common.blockentity.door.TardisInternalDoor;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;
import whocraft.tardis_refined.common.util.TRTeleporter;

public class InternalDoorBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty OPEN = BooleanProperty.m_61465_((String)"open");
    public static final BooleanProperty OFFSET = BooleanProperty.m_61465_((String)"offset");
    public static final BooleanProperty LOCKED = BooleanProperty.m_61465_((String)"locked");
    protected static final VoxelShape COLLISION = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)32.0, (double)16.0);
    protected static BlockEntity blockEntity;

    public InternalDoorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)OFFSET, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LOCKED, (Comparable)Boolean.valueOf(false)));
    }

    public void m_6807_(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean bl) {
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof InternalDoorBlockEntity) {
            InternalDoorBlockEntity door = (InternalDoorBlockEntity)blockEntity;
            door.onBlockPlaced();
        }
        super.m_6807_(blockState, level, blockPos, blockState2, bl);
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        if (((Boolean)blockState.m_61143_((Property)OFFSET)).booleanValue()) {
            Direction facing = (Direction)blockState.m_61143_((Property)FACING);
            double xOffset = 0.0;
            double zOffset = 0.0;
            switch (facing) {
                case NORTH: {
                    xOffset = -0.5;
                    break;
                }
                case SOUTH: {
                    xOffset = 0.5;
                    break;
                }
                case EAST: {
                    zOffset = -0.5;
                    break;
                }
                case WEST: {
                    zOffset = 0.5;
                }
            }
            return COLLISION.m_83216_(xOffset, 0.0, zOffset);
        }
        return COLLISION;
    }

    public VoxelShape m_5939_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return this.m_5940_(blockState, blockGetter, blockPos, collisionContext);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return this.getDoorBlockEntity();
    }

    public void setBlockEntity(BlockEntity blockEntity) {
        InternalDoorBlock.blockEntity = blockEntity;
    }

    public BlockEntity getDoorBlockEntity() {
        return blockEntity;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{OPEN, FACING, LOCKED, OFFSET});
    }

    public BlockState m_5573_(@NotNull BlockPlaceContext blockPlaceContext) {
        BlockState state = super.m_5573_(blockPlaceContext);
        return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)blockPlaceContext.m_8125_())).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LOCKED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)OFFSET, (Comparable)Boolean.valueOf(blockPlaceContext.m_43723_().m_6047_()));
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public void m_7892_(BlockState blockState, Level level, BlockPos blockPos, Entity entity) {
        ServerLevel serverLevel;
        BlockEntity blockEntity;
        if (!level.m_5776_() && (blockEntity = (serverLevel = (ServerLevel)level).m_7702_(blockPos)) instanceof TardisInternalDoor) {
            TardisInternalDoor door = (TardisInternalDoor)blockEntity;
            TardisLevelOperator.get(serverLevel).ifPresent(tardisLevelOperator -> {
                AABB teleportAABB;
                if (!tardisLevelOperator.getPilotingManager().isInFlight() && TRTeleporter.teleportIfCollided(serverLevel, blockPos, entity, teleportAABB = this.m_5939_(blockState, (BlockGetter)level, blockPos, CollisionContext.m_82750_((Entity)entity)).m_83215_().m_82338_(blockPos))) {
                    door.onAttemptEnter(blockState, (Level)serverLevel, blockPos, entity);
                }
            });
        }
    }
}

