/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.capability.player;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.entity.player.Player;
import whocraft.tardis_refined.common.capability.player.TardisPilot;
import whocraft.tardis_refined.common.capability.player.forge.TardisPlayerInfoImpl;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;
import whocraft.tardis_refined.common.network.messages.player.C2SExitTardisView;
import whocraft.tardis_refined.common.network.messages.player.S2CResetPostShellView;
import whocraft.tardis_refined.common.network.messages.sync.S2CSyncTardisPlayerView;
import whocraft.tardis_refined.common.tardis.TardisNavLocation;
import whocraft.tardis_refined.common.tardis.manager.TardisPilotingManager;
import whocraft.tardis_refined.common.util.DimensionUtil;
import whocraft.tardis_refined.common.util.Platform;
import whocraft.tardis_refined.common.util.TRTeleporter;

public class TardisPlayerInfo
implements TardisPilot {
    private Player player;
    private UUID viewedTardis;
    private TardisNavLocation playerPreviousPos = TardisNavLocation.ORIGIN;
    private float playerPreviousRot = 0.0f;
    private float playerPreviousYaw = 0.0f;
    private boolean renderVortex = false;

    public TardisPlayerInfo(Player player) {
        this.player = player;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Optional<TardisPlayerInfo> get(LivingEntity player) {
        return TardisPlayerInfoImpl.get(player);
    }

    public static void updateTardisForAllPlayers(TardisLevelOperator tardisLevelOperator, TardisNavLocation tardisNavLocation, boolean timeVortex) {
        if (Platform.getServer() == null) {
            return;
        }
        Platform.getServer().m_6846_().m_11314_().forEach(serverPlayer -> TardisPlayerInfo.get((LivingEntity)serverPlayer).ifPresent(tardisPlayerInfo -> {
            if (tardisPlayerInfo.isViewingTardis() && Objects.equals(tardisPlayerInfo.getViewedTardis().toString(), UUID.fromString(tardisLevelOperator.getLevelKey().m_135782_().m_135815_()).toString())) {
                tardisPlayerInfo.startShellView((ServerPlayer)serverPlayer, tardisLevelOperator, tardisNavLocation, timeVortex);
            }
        }));
    }

    public float getPlayerPreviousRot() {
        return this.playerPreviousRot;
    }

    public void setPlayerPreviousRot(float playerPreviousRot) {
        this.playerPreviousRot = playerPreviousRot;
    }

    public float getPlayerPreviousYaw() {
        return this.playerPreviousYaw;
    }

    public void setPlayerPreviousYaw(float playerPreviousYaw) {
        this.playerPreviousYaw = playerPreviousYaw;
    }

    @Override
    public void updatePlayerAbilities(ServerPlayer player, Abilities abilities, boolean isWatcher) {
        if (isWatcher) {
            abilities.f_35936_ = false;
            abilities.f_35937_ = false;
            abilities.f_35938_ = false;
            abilities.f_35934_ = true;
            abilities.f_35935_ = true;
            player.m_20242_(true);
        } else {
            player.f_8941_.m_9290_().m_46398_(abilities);
            player.m_20242_(false);
        }
    }

    @Override
    public void startShellView(ServerPlayer serverPlayer, TardisLevelOperator tardisLevelOperator, TardisNavLocation spectateTarget, boolean timeVortex) {
        UUID uuid = UUID.fromString(tardisLevelOperator.getLevelKey().m_135782_().m_135815_());
        if (!this.isViewingTardis()) {
            this.setPlayerPreviousPos(new TardisNavLocation(this.player.m_20183_(), Direction.NORTH, tardisLevelOperator.getLevelKey()));
            this.setPlayerPreviousRot(this.player.m_6080_());
            this.setPlayerPreviousYaw(this.player.m_146909_());
        }
        this.setViewedTardis(uuid);
        if (spectateTarget != null) {
            BlockPos spectatePos = spectateTarget.getPosition();
            if (spectateTarget.getPosition().m_123333_(new Vec3i((int)this.player.m_20182_().f_82479_, (int)this.player.m_20182_().f_82480_, (int)this.player.m_20182_().f_82481_)) > 3 || !this.player.m_9236_().m_46472_().m_135782_().toString().equals(spectateTarget.getDimensionKey().m_135782_().toString())) {
                TRTeleporter.simpleTeleport((Entity)this.player, spectateTarget.getLevel(), (double)spectatePos.m_123341_() + 0.5, spectatePos.m_123342_(), (double)spectatePos.m_123343_() + 0.5, this.playerPreviousRot, this.playerPreviousYaw);
            }
            this.updatePlayerAbilities(serverPlayer, serverPlayer.m_150110_(), true);
            this.setRenderVortex(timeVortex);
            serverPlayer.m_6885_();
            this.syncToClients(null);
        }
    }

    public TardisNavLocation getPlayerPreviousPos() {
        return this.playerPreviousPos;
    }

    public void setPlayerPreviousPos(TardisNavLocation playerPreviousPos) {
        this.playerPreviousPos = playerPreviousPos;
    }

    public static void onExitKeybindPressed() {
        new C2SExitTardisView().send();
    }

    @Override
    @Nullable
    public UUID getViewedTardis() {
        return this.viewedTardis;
    }

    @Override
    public void setViewedTardis(@Nullable UUID uuid) {
        this.viewedTardis = uuid;
    }

    @Override
    public boolean isViewingTardis() {
        return this.viewedTardis != null;
    }

    @Override
    public CompoundTag saveData() {
        CompoundTag tag = new CompoundTag();
        if (this.viewedTardis != null) {
            tag.m_128362_("ViewedTardis", this.viewedTardis);
        }
        CompoundTag playerPos = this.playerPreviousPos.serialise();
        tag.m_128365_("TardisPlayerPos", (Tag)playerPos);
        tag.m_128379_("RenderVortex", this.renderVortex);
        tag.m_128350_("PlayerPreviousRot", this.playerPreviousRot);
        tag.m_128350_("PlayerPreviousYaw", this.playerPreviousYaw);
        return tag;
    }

    public boolean isRenderVortex() {
        return this.renderVortex;
    }

    public void setRenderVortex(boolean renderVortex) {
        this.renderVortex = renderVortex;
        this.syncToClients(null);
    }

    @Override
    public void loadData(CompoundTag tag) {
        this.playerPreviousRot = tag.m_128457_("PlayerPreviousRot");
        this.playerPreviousYaw = tag.m_128457_("PlayerPreviousYaw");
        if (tag.m_128441_("TardisPlayerPos")) {
            this.playerPreviousPos = TardisNavLocation.deserialize(tag.m_128469_("TardisPlayerPos"));
        }
        this.viewedTardis = tag.m_128403_("ViewedTardis") ? tag.m_128342_("ViewedTardis") : null;
        this.renderVortex = tag.m_128471_("RenderVortex");
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public void endShellView(ServerPlayer serverPlayer) {
        if (!this.isViewingTardis()) {
            return;
        }
        BlockPos targetPosition = this.getPlayerPreviousPos().getPosition();
        TRTeleporter.simpleTeleport((Entity)serverPlayer, DimensionUtil.getLevel(this.getPlayerPreviousPos().getDimensionKey()), (double)targetPosition.m_123341_() + 0.5, targetPosition.m_123342_(), (double)targetPosition.m_123343_() + 0.5, this.playerPreviousYaw, this.playerPreviousRot);
        this.updatePlayerAbilities(serverPlayer, serverPlayer.m_150110_(), false);
        serverPlayer.m_6885_();
        new S2CResetPostShellView().send(serverPlayer);
        this.setPlayerPreviousPos(TardisNavLocation.ORIGIN);
        this.setRenderVortex(false);
        this.setViewedTardis(null);
        this.syncToClients(null);
    }

    @Override
    public void syncToClients(@Nullable ServerPlayer serverPlayerEntity) {
        if (this.player != null && this.player.m_9236_().f_46443_) {
            throw new IllegalStateException("Don't sync client -> server");
        }
        CompoundTag nbt = this.saveData();
        S2CSyncTardisPlayerView message = new S2CSyncTardisPlayerView(this.player.m_19879_(), nbt);
        if (serverPlayerEntity == null) {
            message.sendToAll();
        } else {
            message.send(serverPlayerEntity);
        }
    }

    @Override
    public void tick(TardisLevelOperator tardisLevelOperator, ServerPlayer serverPlayerEntity) {
        TardisPilotingManager pilotManger = tardisLevelOperator.getPilotingManager();
        if (tardisLevelOperator.getLevelKey() == this.getPlayerPreviousPos().getDimensionKey()) {
            boolean showVortex = pilotManger.isLanding() || pilotManger.isTakingOff() || pilotManger.isInFlight();
            TardisNavLocation movePlayerToLocation = pilotManger.getCurrentLocation();
            if (pilotManger.isInFlight()) {
                if (pilotManger.isLanding()) {
                    movePlayerToLocation = pilotManger.getTargetLocation();
                } else if (pilotManger.isTakingOff()) {
                    movePlayerToLocation = pilotManger.getCurrentLocation();
                }
            }
            TardisPlayerInfo.updateTardisForAllPlayers(tardisLevelOperator, movePlayerToLocation, showVortex);
            this.setRenderVortex(showVortex);
        }
    }
}

