/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.data;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import whocraft.tardis_refined.TardisRefined;
import whocraft.tardis_refined.common.soundscape.hum.HumEntry;
import whocraft.tardis_refined.common.soundscape.hum.TardisHums;

public class HumProvider
implements DataProvider {
    protected final DataGenerator generator;
    private final boolean addDefaults;
    protected Map<ResourceLocation, HumEntry> data = new HashMap<ResourceLocation, HumEntry>();
    public static Logger LOGGER = LogManager.getLogger((String)"TardisRefined/HumProvider");

    public HumProvider(DataGenerator generator) {
        this(generator, true);
    }

    public HumProvider(DataGenerator generator, boolean addDefaults) {
        Preconditions.checkNotNull((Object)generator);
        this.generator = generator;
        this.addDefaults = addDefaults;
    }

    protected void addHums() {
    }

    public CompletableFuture<?> m_213708_(CachedOutput arg) {
        this.data.clear();
        ArrayList futures = new ArrayList();
        if (this.addDefaults) {
            TardisHums.registerDefaultHums();
            this.data.putAll(TardisHums.getDefaultHums());
            this.addHum(TardisHums.getDefaultHum());
            this.addHum(TardisHums.VICTORIAN);
            this.addHum(TardisHums.TOYOTA);
            this.addHum(TardisHums.CLASSIC);
            this.addHum(TardisHums.CAVE);
            this.addHum(TardisHums.AVIATRAX);
            this.addHum(TardisHums.CRIMSON_FOREST);
            this.addHum(TardisHums.BASALT_DELTAS);
            this.addHum(TardisHums.NETHER_WASTES);
            this.addHum(TardisHums.SOUL_SAND_VALLEY);
            this.addHum(TardisHums.WARPED_FOREST);
            this.addHum(TardisHums.UNDER_WATER);
            this.addHum(TardisHums.COPPER);
        }
        this.addHums();
        if (!this.data.isEmpty()) {
            this.data.forEach((key, hum) -> {
                TardisRefined.LOGGER.debug("Writing Hum {}", key);
                try {
                    JsonObject currentHum = ((JsonElement)HumEntry.codec().encodeStart((DynamicOps)JsonOps.INSTANCE, hum).get().ifRight(right -> TardisRefined.LOGGER.error(right.message())).orThrow()).getAsJsonObject();
                    String outputPath = "data/" + hum.getIdentifier().m_135827_() + "/" + TardisHums.getReloadListener().getFolderName() + "/" + hum.getIdentifier().m_135815_().replace("/", "_") + ".json";
                    futures.add(DataProvider.m_253162_((CachedOutput)arg, (JsonElement)currentHum, (Path)this.generator.getPackOutput().m_245114_().resolve(outputPath)));
                }
                catch (Exception exception) {
                    LOGGER.error("Issue writing Hum {{}}! Error: {}", (Object)hum.getIdentifier(), (Object)exception.getMessage());
                }
            });
        }
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    @NotNull
    public String m_6055_() {
        return "Tardis Refined - Hums";
    }

    protected void addHum(HumEntry hum) {
        LOGGER.info("Adding Interior Hum {{}} to Data Generation", (Object)hum.getIdentifier());
        this.data.put(hum.getIdentifier(), hum);
    }
}

