/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import org.jetbrains.annotations.NotNull;
import whocraft.tardis_refined.registry.TRBlockRegistry;
import whocraft.tardis_refined.registry.TREntityRegistry;
import whocraft.tardis_refined.registry.TRItemRegistry;

public class ProviderLootTable
extends LootTableProvider {
    public ProviderLootTable(PackOutput arg) {
        super(arg, Set.of(), List.of(new LootTableProvider.SubProviderEntry(ModBlockLoot::new, LootContextParamSets.f_81421_)));
    }

    public static class ModEntityLoot
    extends EntityLootSubProvider {
        protected ModEntityLoot() {
            super(FeatureFlags.f_244280_.m_247355_());
        }

        protected Stream<EntityType<?>> getKnownEntityTypes() {
            ArrayList<@NotNull EntityType<?>> entities = new ArrayList();
            for (Map.Entry<ResourceKey<EntityType<?>>, EntityType<?>> entry : TREntityRegistry.ENTITY_TYPES.entrySet()) {
                if (entry.getValue() == TREntityRegistry.CONTROL_ENTITY.get()) break;
                entities.add(entry.getValue());
            }
            return entities.stream();
        }

        public void m_246942_() {
            this.getKnownEntityTypes().forEach(entityType -> this.m_245309_((EntityType)entityType, new LootTable.Builder()));
        }
    }

    public static class ModBlockLoot
    extends BlockLootSubProvider {
        protected ModBlockLoot() {
            super(Set.of(), FeatureFlags.f_244280_.m_247355_());
        }

        protected void m_245660_() {
            for (Block block2 : this.getKnownBlocks()) {
                this.m_245724_(block2);
            }
            this.m_246481_(TRBlockRegistry.ZEITON_ORE.get(), block -> this.m_246109_((Block)block, TRItemRegistry.RAW_ZEITON.get()));
            this.m_246481_(TRBlockRegistry.ZEITON_ORE_DEEPSLATE.get(), block -> this.m_246109_((Block)block, TRItemRegistry.RAW_ZEITON.get()));
        }

        protected Iterable<Block> getKnownBlocks() {
            ArrayList<@NotNull Block> blocks = new ArrayList<Block>();
            for (Map.Entry<ResourceKey<Block>, Block> entry : TRBlockRegistry.BLOCKS.entrySet()) {
                ResourceLocation blockId = TRBlockRegistry.BLOCKS.getKey(entry.getValue());
                if (!blockId.toString().contains("tardis_refined")) continue;
                blocks.add(entry.getValue());
            }
            return blocks;
        }
    }
}

