/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.dimension;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import whocraft.tardis_refined.TardisRefined;
import whocraft.tardis_refined.common.dimension.forge.DimensionHandlerImpl;
import whocraft.tardis_refined.common.util.Platform;
import whocraft.tardis_refined.common.world.ChunkGenerators;
import whocraft.tardis_refined.common.world.chunk.TardisChunkGenerator;
import whocraft.tardis_refined.compat.ModCompatChecker;
import whocraft.tardis_refined.compat.portals.ImmersivePortals;
import whocraft.tardis_refined.mixin.MinecraftServerStorageAccessor;
import whocraft.tardis_refined.registry.TRDimensionTypes;

public class DimensionHandler {
    public static ArrayList<ResourceKey<Level>> LEVELS = new ArrayList();
    public static Logger LOGGER = LogManager.getLogger((String)"TardisRefined/DimensionHandler");

    public static void addDimension(ResourceKey<Level> resourceKey) {
        LEVELS.add(resourceKey);
        DimensionHandler.writeLevels();
    }

    public static Path getWorldSavingDirectory() {
        return DimensionHandler.getStorage().m_197394_(Level.f_46428_);
    }

    public static LevelStorageSource.LevelStorageAccess getStorage() {
        return ((MinecraftServerStorageAccessor)Platform.getServer()).getStorageSource();
    }

    private static void writeLevels() {
        File file = new File(DimensionHandler.getWorldSavingDirectory().toFile(), "tardis_refined_tardis_info.json");
        JsonObject jsonObject = new JsonObject();
        JsonArray dimensions = new JsonArray();
        for (ResourceKey<Level> level : LEVELS) {
            dimensions.add(level.m_135782_().toString());
        }
        jsonObject.add("tardis_dimensions", (JsonElement)dimensions);
        LOGGER.info("Writing {} to: {}", (Object)dimensions, (Object)file.getAbsolutePath());
        try (FileWriter writer = new FileWriter(file);){
            TardisRefined.GSON.toJson((JsonElement)jsonObject, (Appendable)writer);
            writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ServerLevel getOrCreateInterior(Level interactionLevel, ResourceLocation resourceLocation) {
        ResourceKey levelResourceKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)resourceLocation);
        if (ModCompatChecker.immersivePortals()) {
            return ImmersivePortals.createDimension(interactionLevel, (ResourceKey<Level>)levelResourceKey);
        }
        if (interactionLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)interactionLevel;
            ServerLevel existingLevel = DimensionHandler.getExistingLevel(serverLevel, (ResourceKey<Level>)levelResourceKey);
            if (existingLevel != null) {
                return existingLevel;
            }
            return DimensionHandler.createDimension(interactionLevel, (ResourceKey<Level>)levelResourceKey);
        }
        return null;
    }

    public static void loadLevels(ServerLevel serverLevel) {
        File file = new File(DimensionHandler.getWorldSavingDirectory().toFile(), "tardis_refined_tardis_info.json");
        if (!file.exists()) {
            return;
        }
        BufferedReader reader = null;
        try {
            reader = Files.newBufferedReader(file.toPath());
            JsonObject jsonObject = (JsonObject)TardisRefined.GSON.fromJson((Reader)reader, JsonObject.class);
            for (JsonElement dimension : jsonObject.get("tardis_dimensions").getAsJsonArray()) {
                LOGGER.info("Attempting to load {}", (Object)dimension.getAsString());
                ResourceLocation id = new ResourceLocation(dimension.getAsString());
                ResourceKey levelKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)id);
                if (DimensionHandler.getExistingLevel(serverLevel, (ResourceKey<Level>)levelKey) == null) {
                    LOGGER.warn("Level {} not found! Creating new level instance", (Object)dimension.getAsString());
                    if (DimensionHandler.getOrCreateInterior((Level)serverLevel, id) == null) continue;
                    LOGGER.warn("Successfully created and loaded new level {}", (Object)dimension.getAsString());
                    continue;
                }
                LOGGER.info("Successfully loaded existing level {}", (Object)dimension.getAsString());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ServerLevel createDimension(Level level, ResourceKey<Level> id) {
        void var1_1;
        return DimensionHandlerImpl.createDimension(level, (ResourceKey<Level>)var1_1);
    }

    public static LevelStem formLevelStem(MinecraftServer server, ResourceKey<LevelStem> stem) {
        RegistryAccess.Frozen access = server.m_206579_();
        return new LevelStem((Holder)access.m_175515_(Registries.f_256787_).m_246971_(TRDimensionTypes.TARDIS), (ChunkGenerator)new TardisChunkGenerator((Holder<Biome>)access.m_175515_(Registries.f_256952_).m_246971_(ChunkGenerators.TARDIS_BIOME)));
    }

    public static ServerLevel getExistingLevel(ServerLevel serverLevel, String id) {
        return DimensionHandler.getExistingLevel(serverLevel, (ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("tardis_refined", id)));
    }

    public static ServerLevel getExistingLevel(ServerLevel serverLevel, ResourceKey<Level> levelResourceKey) {
        Map levelMap = serverLevel.m_7654_().f_129762_;
        ServerLevel existingLevel = (ServerLevel)levelMap.get(levelResourceKey);
        return existingLevel;
    }
}

