/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.dimension.forge;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Lifecycle;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.util.Unit;
import net.minecraft.world.RandomSequences;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.border.BorderChangeListener;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.storage.DerivedLevelData;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.storage.WorldData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.Event;
import whocraft.tardis_refined.common.dimension.DimensionHandler;
import whocraft.tardis_refined.common.network.messages.sync.S2CSyncLevelList;
import whocraft.tardis_refined.common.util.forge.PlatformImpl;

public class DimensionHandlerImpl {
    public static ServerLevel createDimension(Level level, ResourceKey<Level> id) {
        BiFunction<MinecraftServer, ResourceKey, LevelStem> dimensionFactory = DimensionHandler::formLevelStem;
        MinecraftServer server = PlatformImpl.getServer();
        ServerLevel overworld = server.m_129880_(Level.f_46428_);
        ResourceKey dimensionKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256862_, (ResourceLocation)id.m_135782_());
        LevelStem dimension = dimensionFactory.apply(server, dimensionKey);
        ChunkProgressListener chunkListener = server.f_129756_.m_9620_(11);
        Executor executor = server.f_129738_;
        LevelStorageSource.LevelStorageAccess levelSave = server.f_129744_;
        WorldData serverConfig = server.m_129910_();
        DerivedLevelData derivedWorldInfo = new DerivedLevelData(serverConfig, serverConfig.m_5996_());
        Registry dimensionRegistry = server.m_206579_().m_175515_(Registries.f_256862_);
        if (!(dimensionRegistry instanceof MappedRegistry)) {
            throw new IllegalStateException(String.format("Unable to register dimension %s -- dimension registry not writable", dimensionKey.m_135782_()));
        }
        MappedRegistry writableRegistry = (MappedRegistry)dimensionRegistry;
        writableRegistry.unfreeze();
        writableRegistry.m_255290_(dimensionKey, (Object)dimension, Lifecycle.stable());
        ServerLevel newLevel = new ServerLevel(server, executor, levelSave, (ServerLevelData)derivedWorldInfo, id, dimension, chunkListener, false, BiomeManager.m_47877_((long)serverConfig.m_246337_().m_245499_()), (List)ImmutableList.of(), false, new RandomSequences(BiomeManager.m_47877_((long)serverConfig.m_246337_().m_245499_())));
        DimensionHandler.addDimension((ResourceKey<Level>)newLevel.m_46472_());
        overworld.m_6857_().m_61929_((BorderChangeListener)new BorderChangeListener.DelegateBorderChangeListener(newLevel.m_6857_()));
        server.f_129762_.put(id, newLevel);
        server.markWorldsDirty();
        MinecraftForge.EVENT_BUS.post((Event)new LevelEvent.Load((LevelAccessor)newLevel));
        new S2CSyncLevelList((ResourceKey<Level>)newLevel.m_46472_(), true).sendToAll();
        BlockPos blockPos = new BlockPos(0, 0, 0);
        ChunkPos chunkPos = new ChunkPos(blockPos);
        chunkListener.m_7647_(chunkPos);
        ServerChunkCache serverchunkcache = newLevel.m_7726_();
        serverchunkcache.m_7827_().m_7174_(blockPos);
        serverchunkcache.m_8387_(TicketType.f_9442_, chunkPos, 11, (Object)Unit.INSTANCE);
        return newLevel;
    }
}

