/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.entity;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import whocraft.tardis_refined.TardisRefined;
import whocraft.tardis_refined.client.TardisClientData;
import whocraft.tardis_refined.common.blockentity.console.GlobalConsoleBlockEntity;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;
import whocraft.tardis_refined.common.capability.tardis.upgrades.UpgradeHandler;
import whocraft.tardis_refined.common.tardis.control.Control;
import whocraft.tardis_refined.common.tardis.control.ControlSpecification;
import whocraft.tardis_refined.common.tardis.control.ship.MonitorControl;
import whocraft.tardis_refined.common.tardis.manager.FlightDanceManager;
import whocraft.tardis_refined.common.tardis.manager.TardisPilotingManager;
import whocraft.tardis_refined.common.tardis.themes.ConsoleTheme;
import whocraft.tardis_refined.common.util.ClientHelper;
import whocraft.tardis_refined.common.util.LevelHelper;
import whocraft.tardis_refined.common.util.MiscHelper;
import whocraft.tardis_refined.constants.ModMessages;
import whocraft.tardis_refined.patterns.sound.ConfiguredSound;
import whocraft.tardis_refined.registry.TRDimensionTypes;
import whocraft.tardis_refined.registry.TREntityRegistry;
import whocraft.tardis_refined.registry.TRItemRegistry;
import whocraft.tardis_refined.registry.TRSoundRegistry;

public class ControlEntity
extends Entity {
    private static final EntityDataAccessor<Boolean> TICKING_DOWN = SynchedEntityData.m_135353_(ControlEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_DEAD = SynchedEntityData.m_135353_(ControlEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> CONTROL_HEALTH = SynchedEntityData.m_135353_(ControlEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> SHOW_PARTICLE = SynchedEntityData.m_135353_(ControlEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> SIZE_WIDTH = SynchedEntityData.m_135353_(ControlEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> SIZE_HEIGHT = SynchedEntityData.m_135353_(ControlEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private int totalControlHealth = 10;
    private ControlSpecification controlSpecification;
    private ConsoleTheme consoleTheme;
    private BlockPos consoleBlockPos;
    private FlightDanceManager flightDanceManager;
    private Vector3f offset;

    public ControlEntity(EntityType<?> entityTypeIn, Level level) {
        super(entityTypeIn, level);
    }

    public ControlEntity(Level level) {
        super(TREntityRegistry.CONTROL_ENTITY.get(), level);
    }

    public GlobalConsoleBlockEntity getConsoleBlockEntity() {
        BlockEntity blockEntity;
        if (this.consoleBlockPos != null && (blockEntity = this.m_9236_().m_7702_(this.consoleBlockPos)) instanceof GlobalConsoleBlockEntity) {
            GlobalConsoleBlockEntity consoleBlockEntity = (GlobalConsoleBlockEntity)blockEntity;
            return consoleBlockEntity;
        }
        return null;
    }

    public int getControlHealth() {
        return (Integer)this.f_19804_.m_135370_(CONTROL_HEALTH);
    }

    public void assignControlData(ConsoleTheme theme, ControlSpecification specification, BlockPos consoleBlockPos) {
        this.consoleBlockPos = consoleBlockPos;
        this.controlSpecification = specification;
        this.consoleTheme = theme;
        if (this.controlSpecification != null) {
            float width = this.controlSpecification.size().f_20377_;
            float height = this.controlSpecification.size().f_20378_;
            this.setSizeData(width, height);
            this.m_6593_((Component)Component.m_237115_((String)this.controlSpecification.control().getTranslationKey()));
        }
    }

    protected void setSizeData(float width, float height) {
        this.m_20088_().m_135381_(SIZE_WIDTH, (Object)Float.valueOf(width));
        this.m_20088_().m_135381_(SIZE_HEIGHT, (Object)Float.valueOf(height));
    }

    public void setSizeAndUpdate(float width, float height) {
        this.setSizeData(width, height);
        this.m_6210_();
    }

    public ControlSpecification controlSpecification() {
        return this.controlSpecification;
    }

    public ConsoleTheme consoleTheme() {
        return this.consoleTheme;
    }

    public EntityDimensions m_6972_(Pose pose) {
        if (this.m_20088_().m_285897_(SIZE_WIDTH) && this.m_20088_().m_285897_(SIZE_HEIGHT)) {
            return EntityDimensions.m_20395_((float)((Float)this.m_20088_().m_135370_(SIZE_WIDTH)).floatValue(), (float)((Float)this.m_20088_().m_135370_(SIZE_HEIGHT)).floatValue());
        }
        return super.m_6972_(pose);
    }

    public Component m_7755_() {
        TardisClientData tardisClientData = TardisClientData.getInstance((ResourceKey<Level>)this.m_9236_().m_46472_());
        if (tardisClientData.isInRecovery()) {
            int cooldownTicks = tardisClientData.getRecoveryTicks();
            int maxCooldownTicks = 12000;
            int percentage = (int)((float)cooldownTicks / (float)maxCooldownTicks * 100.0f);
            return Component.m_237110_((String)ModMessages.RECOVERY_PROGRESS, (Object[])new Object[]{percentage + "%"});
        }
        if (this.controlSpecification == null) {
            return super.m_7755_();
        }
        return Component.m_237115_((String)this.controlSpecification.control().getTranslationKey());
    }

    public boolean setTickingDown(FlightDanceManager manager) {
        if (((Boolean)this.m_20088_().m_135370_(IS_DEAD)).booleanValue()) {
            return false;
        }
        this.f_19804_.m_135381_(TICKING_DOWN, (Object)true);
        this.flightDanceManager = manager;
        this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11685_, SoundSource.BLOCKS, 0.5f, 2.0f);
        this.m_6593_((Component)Component.m_237115_((String)"!"));
        return true;
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(SHOW_PARTICLE, (Object)false);
        this.m_20088_().m_135372_(TICKING_DOWN, (Object)false);
        this.m_20088_().m_135372_(IS_DEAD, (Object)false);
        this.m_20088_().m_135372_(SIZE_WIDTH, (Object)Float.valueOf(1.0f));
        this.m_20088_().m_135372_(SIZE_HEIGHT, (Object)Float.valueOf(1.0f));
        this.m_20088_().m_135372_(CONTROL_HEALTH, (Object)10);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        this.setSizeAndUpdate(((Float)this.m_20088_().m_135370_(SIZE_WIDTH)).floatValue(), ((Float)this.m_20088_().m_135370_(SIZE_HEIGHT)).floatValue());
    }

    public boolean m_20223_(CompoundTag compound) {
        if (this.consoleBlockPos != null) {
            compound.m_128365_("console_pos", (Tag)NbtUtils.m_129224_((BlockPos)this.consoleBlockPos));
        }
        compound.m_128350_("console_size_width", ((Float)this.m_20088_().m_135370_(SIZE_WIDTH)).floatValue());
        compound.m_128350_("console_size_height", ((Float)this.m_20088_().m_135370_(SIZE_HEIGHT)).floatValue());
        return super.m_20223_(compound);
    }

    public void m_7378_(CompoundTag compound) {
        CompoundTag consolePos = compound.m_128469_("console_pos");
        this.consoleBlockPos = NbtUtils.m_129239_((CompoundTag)consolePos);
        float width = compound.m_128457_("console_size_width");
        float height = compound.m_128457_("console_size_height");
        this.setSizeData(width, height);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            TardisLevelOperator.get(serverLevel).ifPresent(operator -> {
                this.flightDanceManager = operator.getFlightDanceManager();
            });
        }
    }

    protected void m_7380_(CompoundTag compound) {
        if (this.consoleBlockPos != null) {
            compound.m_128365_("console_pos", (Tag)NbtUtils.m_129224_((BlockPos)this.consoleBlockPos));
        }
        compound.m_128350_("console_size_width", ((Float)this.m_20088_().m_135370_(SIZE_WIDTH)).floatValue());
        compound.m_128350_("console_size_height", ((Float)this.m_20088_().m_135370_(SIZE_HEIGHT)).floatValue());
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return MiscHelper.spawnPacket(this);
    }

    public boolean m_6469_(DamageSource damageSource, float f) {
        Entity entity = damageSource.m_7640_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (!player.m_9236_().m_5776_()) {
                    if (((Boolean)this.f_19804_.m_135370_(IS_DEAD)).booleanValue()) {
                        return false;
                    }
                    if (((Boolean)this.f_19804_.m_135370_(TICKING_DOWN)).booleanValue()) {
                        ItemStack itemStack = player.m_21205_();
                        if (itemStack.m_150930_((Item)TRItemRegistry.MALLET.get()) && !player.m_36335_().m_41519_((Item)TRItemRegistry.MALLET.get())) {
                            player.m_36335_().m_41524_((Item)TRItemRegistry.MALLET.get(), 600);
                            this.m_216990_(TRSoundRegistry.MALLET.get());
                            itemStack.m_41622_(15, (LivingEntity)player, livingEntityx -> livingEntityx.m_21166_(EquipmentSlot.MAINHAND));
                            this.getConsoleBlockEntity().getControlEntityList().forEach(controlEntity -> {
                                controlEntity.realignControl();
                                BlockPos blockPos = controlEntity.m_20183_();
                                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123809_, (double)blockPos.m_123341_(), (double)blockPos.m_123342_() + 1.0, (double)blockPos.m_123343_(), 120, 2.0, 1.0, 2.0, 0.005);
                            });
                        } else {
                            this.realignControl();
                        }
                        return true;
                    }
                    if (this.handleLeftClick(player, serverLevel)) {
                        return true;
                    }
                }
            }
        }
        return super.m_6469_(damageSource, f);
    }

    public InteractionResult m_7111_(Player player, Vec3 hitPos, InteractionHand interactionHand) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!player.m_9236_().m_5776_()) {
                if (player.m_21205_().m_41720_() == Items.f_42657_) {
                    this.handleControlSizeAndPositionAdjustment(player);
                    return InteractionResult.m_19078_((boolean)false);
                }
                if (((Boolean)this.f_19804_.m_135370_(IS_DEAD)).booleanValue()) {
                    return InteractionResult.FAIL;
                }
                if (((Boolean)this.f_19804_.m_135370_(TICKING_DOWN)).booleanValue()) {
                    this.realignControl();
                    return InteractionResult.m_19078_((boolean)false);
                }
                if (this.handleRightClick(player, serverLevel, interactionHand)) {
                    return InteractionResult.m_19078_((boolean)false);
                }
            }
        }
        return InteractionResult.m_19078_((boolean)true);
    }

    public boolean isTickingDown() {
        return (Boolean)this.m_20088_().m_135370_(TICKING_DOWN);
    }

    public void realignControl() {
        int currentHealth = (Integer)this.f_19804_.m_135370_(CONTROL_HEALTH);
        int nextHealth = currentHealth + 2;
        if (nextHealth >= this.totalControlHealth) {
            this.f_19804_.m_135381_(TICKING_DOWN, (Object)false);
            this.f_19804_.m_135381_(CONTROL_HEALTH, (Object)this.totalControlHealth);
            this.m_6593_((Component)Component.m_237115_((String)this.controlSpecification.control().getTranslationKey()));
        } else {
            UpgradeHandler upgradeHandler = this.flightDanceManager.getOperator().getUpgradeHandler();
            upgradeHandler.addUpgradeXP(5);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123750_, (double)this.consoleBlockPos.m_123341_() + 0.5, (double)(this.consoleBlockPos.m_123342_() + 2), (double)this.consoleBlockPos.m_123343_() + 0.5, 0.0, 0.5, 0.0);
            this.f_19804_.m_135381_(CONTROL_HEALTH, (Object)nextHealth);
        }
    }

    public void m_8119_() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.flightDanceManager == null) {
                TardisLevelOperator.get(serverLevel).ifPresent(operator -> {
                    this.flightDanceManager = operator.getFlightDanceManager();
                });
            }
            if (this.controlSpecification == null) {
                if (this.consoleBlockPos != null) {
                    BlockEntity blockEntity = serverLevel.m_7702_(this.consoleBlockPos);
                    if (blockEntity instanceof GlobalConsoleBlockEntity) {
                        GlobalConsoleBlockEntity globalConsoleBlockEntity = (GlobalConsoleBlockEntity)blockEntity;
                        globalConsoleBlockEntity.markDirty();
                    }
                    this.m_146870_();
                }
            } else {
                this.onServerTick(serverLevel);
            }
        } else {
            this.onClientTick(this.m_9236_());
        }
        if (this.m_9236_().m_220362_() != TRDimensionTypes.TARDIS) {
            this.m_146870_();
        }
    }

    private void onServerTick(ServerLevel serverLevel) {
        boolean isTickingDown = (Boolean)this.m_20088_().m_135370_(TICKING_DOWN);
        boolean isDead = (Boolean)this.m_20088_().m_135370_(IS_DEAD);
        if (this.flightDanceManager != null) {
            TardisLevelOperator operator = this.flightDanceManager.getOperator();
            if (this.controlSpecification.control().hasCustomName()) {
                this.m_6593_(this.controlSpecification.control().getCustomControlName(operator, this, this.controlSpecification));
            }
        }
        if (!isDead && isTickingDown && serverLevel.m_46467_() % 100L == 0L) {
            int controlHealth = (Integer)this.m_20088_().m_135370_(CONTROL_HEALTH) - 1;
            this.m_20088_().m_135381_(CONTROL_HEALTH, (Object)controlHealth);
            if (controlHealth == 0) {
                this.onControlDead();
            }
        }
    }

    public void onControlDead() {
        this.f_19804_.m_135381_(TICKING_DOWN, (Object)false);
        this.f_19804_.m_135381_(IS_DEAD, (Object)true);
        if (this.flightDanceManager != null) {
            this.flightDanceManager.updateDamageList();
        }
    }

    private void onClientTick(Level level) {
        if ((Integer)this.m_20088_().m_135370_(CONTROL_HEALTH) <= 5 && level.f_46441_.m_188503_(25) == 0) {
            ClientHelper.playParticle((ClientLevel)level, (ParticleOptions)ParticleTypes.f_123756_, this.m_20182_(), -0.5 + (double)level.f_46441_.m_188501_(), 0.05, -0.5 + (double)level.f_46441_.m_188501_());
            level.m_245747_(BlockPos.m_274446_((Position)this.m_20182_()), SoundEvents.f_12031_, SoundSource.BLOCKS, 0.25f, level.m_213780_().m_188501_() + 1.0f, false);
        }
    }

    private void handleControlSizeAndPositionAdjustment(Player player) {
        float width = ((Float)this.m_20088_().m_135370_(SIZE_WIDTH)).floatValue();
        float height = ((Float)this.m_20088_().m_135370_(SIZE_HEIGHT)).floatValue();
        float incrementAmount = 0.05f;
        float posIncrementAmount = 0.025f;
        Item offhandItem = player.m_21206_().m_41720_();
        if (offhandItem == Items.f_42451_) {
            if (this.controlSpecification != null) {
                TardisRefined.LOGGER.info("Control Info for: " + this.controlSpecification.control().getId().m_135815_());
            }
            if (this.consoleBlockPos != null) {
                Vec3 centre = LevelHelper.centerPos(this.consoleBlockPos, true);
                double x = this.m_20182_().m_7096_() - centre.f_82479_;
                double y = this.m_20182_().m_7098_() - centre.f_82480_;
                double z = this.m_20182_().m_7094_() - centre.f_82481_;
                TardisRefined.LOGGER.info("Offset: " + x + "F, " + y + "F, " + z + "F");
            }
            float finalWidth = ((Float)this.m_20088_().m_135370_(SIZE_WIDTH)).floatValue();
            float finalHeight = ((Float)this.m_20088_().m_135370_(SIZE_HEIGHT)).floatValue();
            TardisRefined.LOGGER.info("Size (Width, Height): " + finalWidth + "F, " + finalHeight + "F");
        } else {
            if (offhandItem == Items.f_42616_) {
                this.m_146884_(this.m_20182_().m_82520_(player.m_6144_() ? (double)(-posIncrementAmount) : (double)posIncrementAmount, 0.0, 0.0));
            }
            if (offhandItem == Items.f_42415_) {
                this.m_146884_(this.m_20182_().m_82520_(0.0, player.m_6144_() ? (double)(-posIncrementAmount) : (double)posIncrementAmount, 0.0));
            }
            if (offhandItem == Items.f_42417_) {
                this.m_146884_(this.m_20182_().m_82520_(0.0, 0.0, player.m_6144_() ? (double)posIncrementAmount : (double)(-posIncrementAmount)));
            }
            if (offhandItem == Items.f_42416_) {
                float newWidth = player.m_6144_() ? width - incrementAmount : width + incrementAmount;
                this.setSizeAndUpdate(newWidth, height);
            }
            if (offhandItem == Items.f_151052_) {
                float newHeight = player.m_6144_() ? height - incrementAmount : height + incrementAmount;
                this.setSizeAndUpdate(width, newHeight);
            }
        }
    }

    public boolean isDesktopWaitingToGenerate(TardisLevelOperator operator) {
        if (!(this.controlSpecification.control() instanceof MonitorControl) && operator.getInteriorManager().isWaitingToGenerate()) {
            operator.getLevel().m_5594_(null, this.m_20183_(), (SoundEvent)SoundEvents.f_12170_.m_203334_(), SoundSource.BLOCKS, 100.0f, (float)(0.1 + (double)this.m_9236_().m_213780_().m_188501_() * 0.5));
            return true;
        }
        return false;
    }

    private boolean handleLeftClick(Player player, ServerLevel serverLevel) {
        if (!TardisLevelOperator.get(serverLevel).isPresent()) {
            return false;
        }
        TardisLevelOperator cap = TardisLevelOperator.get(serverLevel).get();
        if (cap.getPilotingManager().getCurrentConsole() == null || cap.getPilotingManager().getCurrentConsole() != this.getConsoleBlockEntity()) {
            cap.getPilotingManager().setCurrentConsole(this.getConsoleBlockEntity());
        }
        if (!this.controlSpecification.control().canUseControl(cap, this.controlSpecification.control(), this)) {
            return false;
        }
        Control control = this.controlSpecification.control();
        boolean successfulUse = control.onLeftClick(cap, this.consoleTheme, this, player);
        ConfiguredSound playedSound = successfulUse ? control.getSuccessSound(cap, this.consoleTheme, true) : control.getFailSound(cap, this.consoleTheme, true);
        control.playControlConfiguredSound(cap, this, playedSound);
        return successfulUse;
    }

    private boolean handleRightClick(Player player, ServerLevel serverLevel, InteractionHand interactionHand) {
        if (!TardisLevelOperator.get(serverLevel).isPresent()) {
            return false;
        }
        TardisLevelOperator cap = TardisLevelOperator.get(serverLevel).get();
        TardisPilotingManager pilotingManager = cap.getPilotingManager();
        if (pilotingManager.getCurrentConsole() == null || pilotingManager.getCurrentConsole() != this.getConsoleBlockEntity()) {
            pilotingManager.setCurrentConsole(this.getConsoleBlockEntity());
        }
        if (!cap.getPilotingManager().canUseControls() && !this.controlSpecification.control().canBeUsedPostCrash()) {
            if (player.m_7500_()) {
                serverLevel.m_5594_(null, this.m_20183_(), SoundEvents.f_11937_, SoundSource.BLOCKS, 100.0f, (float)(0.1 + (double)serverLevel.m_213780_().m_188501_() * 0.5));
            } else {
                DamageSource source = MiscHelper.getDamageSource(serverLevel, (ResourceKey<DamageType>)DamageTypes.f_268468_);
                player.m_6469_(source, 0.1f);
            }
            return false;
        }
        if (!this.controlSpecification.control().canUseControl(cap, this.controlSpecification.control(), this)) {
            return false;
        }
        Control control = this.controlSpecification.control();
        boolean successfulUse = control.onRightClick(cap, this.consoleTheme, this, player);
        ConfiguredSound playedSound = successfulUse ? control.getSuccessSound(cap, this.consoleTheme, false) : control.getFailSound(cap, this.consoleTheme, false);
        control.playControlConfiguredSound(cap, this, playedSound);
        return successfulUse;
    }

    public boolean m_142265_(Level level, BlockPos blockPos) {
        return true;
    }

    public boolean m_6052_() {
        return true;
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_6097_() {
        return true;
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6051_() {
        return false;
    }

    public int getTotalControlHealth() {
        return this.totalControlHealth;
    }

    public void setTotalControlHealth(int totalControlHealth) {
        this.totalControlHealth = totalControlHealth;
    }

    public void setPosForDebug(Vector3f vector3f) {
        this.offset = vector3f;
    }
}

