/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.items;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import whocraft.tardis_refined.client.TardisClientData;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;
import whocraft.tardis_refined.common.entity.ControlEntity;
import whocraft.tardis_refined.common.tardis.TardisNavLocation;
import whocraft.tardis_refined.common.tardis.manager.TardisPilotingManager;
import whocraft.tardis_refined.common.util.DimensionUtil;
import whocraft.tardis_refined.common.util.Platform;
import whocraft.tardis_refined.common.util.PlayerUtil;
import whocraft.tardis_refined.constants.ModMessages;
import whocraft.tardis_refined.registry.TRControlRegistry;

public class KeyItem
extends Item {
    public KeyItem(Item.Properties properties) {
        super(properties);
    }

    public static ItemStack addTardis(ItemStack itemStack, ResourceKey<Level> levelResourceKey) {
        ListTag keychain;
        CompoundTag itemtag = itemStack.m_41784_();
        StringTag dim = StringTag.m_129297_((String)levelResourceKey.m_135782_().toString());
        if (!itemtag.m_128425_("keychain", 9)) {
            keychain = new ListTag();
            itemtag.m_128365_("keychain", (Tag)keychain);
        } else {
            keychain = itemtag.m_128437_("keychain", 8);
        }
        keychain.add((Object)dim);
        itemStack.m_41751_(itemtag);
        return itemStack;
    }

    public static void setKeychain(ItemStack itemStack, ArrayList<ResourceKey<Level>> levels) {
        ListTag keychain;
        CompoundTag nbt = itemStack.m_41784_();
        if (!nbt.m_128425_("keychain", 9)) {
            keychain = new ListTag();
            nbt.m_128365_("keychain", (Tag)keychain);
        } else {
            keychain = nbt.m_128437_("keychain", 8);
        }
        keychain.clear();
        levels.forEach((Consumer<ResourceKey<Level>>)((Consumer<ResourceKey>)level -> keychain.add((Object)StringTag.m_129297_((String)level.m_135782_().toString()))));
        itemStack.m_41751_(nbt);
    }

    public static ArrayList<ResourceKey<Level>> getKeychain(ItemStack itemStack) {
        CompoundTag nbt = itemStack.m_41784_();
        if (!nbt.m_128441_("keychain")) {
            return new ArrayList<ResourceKey<Level>>();
        }
        ListTag keychain = nbt.m_128437_("keychain", 8);
        ArrayList<ResourceKey<Level>> levels = new ArrayList<ResourceKey<Level>>();
        for (Tag tag : keychain) {
            String string = tag.m_7916_();
            ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(string));
            levels.add((ResourceKey<Level>)key);
        }
        return levels;
    }

    public static boolean keychainContains(ItemStack itemStack, ResourceKey<Level> levelResourceKey) {
        ArrayList<ResourceKey<Level>> keychain = KeyItem.getKeychain(itemStack);
        return keychain.contains(levelResourceKey);
    }

    public Component m_7626_(ItemStack itemStack) {
        if (KeyItem.getKeychain(itemStack).size() >= 2) {
            return Component.m_237115_((String)ModMessages.ITEM_KEYCHAIN);
        }
        return super.m_7626_(itemStack);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ArrayList<ResourceKey<Level>> keychain;
        boolean canUseWhistle;
        boolean bl = canUseWhistle = "96511168-1bb3-4ff0-a894-271e42606a39".equals(player.m_20149_()) || Platform.isProduction();
        if (player.m_21206_().m_150930_(Items.f_220219_) && !level.f_46443_ && canUseWhistle && !(keychain = KeyItem.getKeychain(player.m_21205_())).isEmpty()) {
            ServerLevel tardisLevel = DimensionUtil.getLevel(keychain.get(0));
            Optional<TardisLevelOperator> operatorOptional = TardisLevelOperator.get(tardisLevel);
            TardisPilotingManager pilotManager = operatorOptional.get().getPilotingManager();
            if (!operatorOptional.get().getPilotingManager().isInRecovery()) {
                pilotManager.setTargetLocation(new TardisNavLocation(player.m_20183_(), player.m_6350_().m_122424_(), (ServerLevel)player.m_9236_()));
                pilotManager.beginFlight(true);
            }
        }
        return super.m_7203_(level, player, interactionHand);
    }

    public boolean interactMonitor(ItemStack itemStack, Player player, ControlEntity controlEntity, InteractionHand interactionHand) {
        Level level = controlEntity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ResourceKey tardis = serverLevel.m_46472_();
            if (controlEntity.controlSpecification().control() != null && controlEntity.controlSpecification().control() == TRControlRegistry.MONITOR.get()) {
                if (KeyItem.keychainContains(itemStack, (ResourceKey<Level>)tardis)) {
                    return false;
                }
                player.m_21008_(interactionHand, KeyItem.addTardis(itemStack, (ResourceKey<Level>)tardis));
                PlayerUtil.sendMessage((LivingEntity)player, (Component)Component.m_237110_((String)ModMessages.MSG_KEY_BOUND, (Object[])new Object[]{tardis.m_135782_().m_135815_()}), true);
                player.m_5496_(SoundEvents.f_12275_, 1.0f, 0.5f);
                return true;
            }
        }
        return false;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        ArrayList<ResourceKey<Level>> keychain;
        if (context.m_43725_() instanceof ServerLevel && context.m_43723_().m_6144_() && !(keychain = KeyItem.getKeychain(context.m_43722_())).isEmpty()) {
            Collections.rotate(keychain.subList(0, keychain.size()), -1);
            KeyItem.setKeychain(context.m_43722_(), keychain);
            PlayerUtil.sendMessage((LivingEntity)context.m_43723_(), (Component)Component.m_237110_((String)ModMessages.MSG_KEY_CYCLED, (Object[])new Object[]{keychain.get(0).m_135782_().m_135815_()}), true);
            context.m_43725_().m_5594_(null, context.m_43723_().m_20183_(), (SoundEvent)SoundEvents.f_12490_.m_203334_(), SoundSource.BLOCKS, 1.0f, 2.0f);
        }
        return super.m_6225_(context);
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        super.m_7373_(itemStack, level, list, tooltipFlag);
        ArrayList<ResourceKey<Level>> keychain = KeyItem.getKeychain(itemStack);
        if (!keychain.isEmpty()) {
            ResourceKey<Level> mainTardisLevel = keychain.get(0);
            if (TardisClientData.getInstance(mainTardisLevel).isFlying()) {
                list.add((Component)Component.m_237115_((String)ModMessages.TOOLTIP_IN_FLIGHT));
            }
            list.add((Component)Component.m_237115_((String)ModMessages.TOOLTIP_TARDIS_LIST_TITLE));
            for (int i = 0; i < keychain.size(); ++i) {
                MutableComponent hyphen = Component.m_237113_((String)(i == 0 ? ChatFormatting.YELLOW + "> " : ChatFormatting.GRAY + "- "));
                list.add((Component)hyphen.m_7220_((Component)Component.m_237113_((String)keychain.get(i).m_135782_().m_135815_().substring(0, 5))));
            }
            TardisClientData tardisClientData = TardisClientData.getInstance(mainTardisLevel);
            if (tardisClientData.isInRecovery()) {
                int cooldownTicks = tardisClientData.getRecoveryTicks();
                int maxCooldownTicks = 12000;
                int percentage = (int)((float)cooldownTicks / (float)maxCooldownTicks * 100.0f);
                list.add((Component)Component.m_237110_((String)ModMessages.RECOVERY_PROGRESS, (Object[])new Object[]{percentage + "%"}));
            }
        }
    }
}

