/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.network;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import whocraft.tardis_refined.common.network.Message;
import whocraft.tardis_refined.common.network.MessageC2S;
import whocraft.tardis_refined.common.network.MessageS2C;
import whocraft.tardis_refined.common.network.MessageType;
import whocraft.tardis_refined.common.network.forge.NetworkManagerImpl;
import whocraft.tardis_refined.common.util.Platform;

public abstract class NetworkManager {
    public static final Map<String, MessageType> toServer = new HashMap<String, MessageType>();
    protected final ResourceLocation channelName;
    protected final Map<String, MessageType> toClient = new HashMap<String, MessageType>();

    public NetworkManager(ResourceLocation channelName) {
        this.channelName = channelName;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static NetworkManager create(ResourceLocation channelName) {
        return NetworkManagerImpl.create(channelName);
    }

    public MessageType registerS2C(String id, MessageDecoder<MessageS2C> decoder) {
        MessageType msgType = new MessageType(id, this, decoder, false);
        this.toClient.put(id, msgType);
        return msgType;
    }

    public MessageType registerC2S(String id, MessageDecoder<MessageC2S> decoder) {
        MessageType msgType = new MessageType(id, this, decoder, true);
        toServer.put(id, msgType);
        return msgType;
    }

    public abstract void sendToServer(MessageC2S var1);

    public abstract void sendToPlayer(ServerPlayer var1, MessageS2C var2);

    public abstract void sendToTrackingAndSelf(ServerPlayer var1, MessageS2C var2);

    public abstract void sendToTracking(Entity var1, MessageS2C var2);

    public abstract void sendToTracking(BlockEntity var1, MessageS2C var2);

    public void sendToDimension(Level level, MessageS2C message) {
        if (!level.f_46443_) {
            for (Player player : level.m_6907_()) {
                this.sendToPlayer((ServerPlayer)player, message);
            }
        }
    }

    public void sendToAllPlayers(MessageS2C message) {
        MinecraftServer server = Platform.getServer();
        if (server == null) {
            return;
        }
        List players = server.m_6846_().m_11314_();
        players.forEach(entry -> this.sendToPlayer((ServerPlayer)entry, message));
    }

    @FunctionalInterface
    public static interface MessageDecoder<T extends Message> {
        public T decode(FriendlyByteBuf var1);
    }
}

