/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.network.messages.waypoints;

import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;
import whocraft.tardis_refined.common.network.MessageC2S;
import whocraft.tardis_refined.common.network.MessageContext;
import whocraft.tardis_refined.common.network.MessageType;
import whocraft.tardis_refined.common.network.TardisNetwork;
import whocraft.tardis_refined.common.network.messages.waypoints.S2COpenEditCoordinatesDisplayMessage;
import whocraft.tardis_refined.common.tardis.TardisWaypoint;
import whocraft.tardis_refined.common.tardis.manager.TardisWaypointManager;

public class C2SOpenEditCoordinatesDisplayMessage
extends MessageC2S {
    private UUID waypointId;

    public C2SOpenEditCoordinatesDisplayMessage(UUID waypointId) {
        this.waypointId = waypointId;
    }

    public C2SOpenEditCoordinatesDisplayMessage(FriendlyByteBuf friendlyByteBuf) {
        this.waypointId = friendlyByteBuf.m_130259_();
    }

    @Override
    @NotNull
    public MessageType getType() {
        return TardisNetwork.CLIENT_OPEN_EDIT_COORDS_SCREEN;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.waypointId);
    }

    @Override
    public void handle(MessageContext context) {
        ServerPlayer serverPlayer = context.getPlayer();
        ServerLevel level = serverPlayer.m_284548_();
        TardisLevelOperator.get(level).ifPresent(tardisLevelOperator -> {
            TardisWaypointManager waypointManager = tardisLevelOperator.getTardisWaypointManager();
            TardisWaypoint waypoint = waypointManager.getWaypointById(this.waypointId);
            if (waypoint != null) {
                new S2COpenEditCoordinatesDisplayMessage(waypoint).send(serverPlayer);
            }
        });
    }
}

