/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.tardis;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import whocraft.tardis_refined.common.util.DimensionUtil;
import whocraft.tardis_refined.common.util.Platform;

public class TardisNavLocation {
    public static final TardisNavLocation ORIGIN = new TardisNavLocation(BlockPos.f_121853_, Direction.NORTH, (ResourceKey<Level>)Level.f_46428_);
    private BlockPos position;
    private Direction direction;
    private ServerLevel level;
    private ResourceKey<Level> dimensionKey;
    private String name = "";

    public TardisNavLocation(BlockPos position, Direction direction, ServerLevel level) {
        this.position = position;
        this.direction = direction;
        this.level = level;
        if (level != null) {
            this.dimensionKey = level.m_46472_();
        }
    }

    public TardisNavLocation(BlockPos position, Direction direction, ResourceKey<Level> level) {
        this.position = position;
        this.direction = direction;
        this.dimensionKey = level;
    }

    public static TardisNavLocation deserialize(CompoundTag tag) {
        TardisNavLocation loc = new TardisNavLocation(BlockPos.m_122022_((long)tag.m_128454_("position")), Direction.values()[tag.m_128451_("direction")], (ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(tag.m_128461_("dimension"))));
        if (tag.m_128441_("name")) {
            loc.setName(tag.m_128461_("name"));
        }
        return loc;
    }

    public CompoundTag serialise() {
        CompoundTag tag = new CompoundTag();
        tag.m_128356_("position", this.position.m_121878_());
        tag.m_128359_("dimension", this.dimensionKey.m_135782_().toString());
        tag.m_128405_("direction", this.direction.ordinal());
        tag.m_128359_("name", this.name);
        return tag;
    }

    public ServerLevel getLevel() {
        if (Platform.getServer() == null) {
            throw new RuntimeException("Called TardisNavLocation::getLevel before server was created! Please adjust your code!");
        }
        if (this.level != null) {
            this.dimensionKey = this.level.m_46472_();
            return DimensionUtil.getLevel(this.dimensionKey);
        }
        return Platform.getServer().m_129880_(Level.f_46428_);
    }

    public void setLevel(ServerLevel level) {
        this.dimensionKey = level.m_46472_();
        this.level = level;
    }

    public ResourceKey<Level> getDimensionKey() {
        return this.dimensionKey;
    }

    public void setDimensionKey(ResourceKey<Level> dimensionKey) {
        this.dimensionKey = dimensionKey;
    }

    public BlockPos getPosition() {
        return this.position;
    }

    public TardisNavLocation setPosition(BlockPos pos) {
        this.position = pos;
        return this;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public TardisNavLocation setDirection(Direction dir) {
        this.direction = dir;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BlockPos setX(int x) {
        BlockPos blockPos;
        this.position = blockPos = new BlockPos(x, this.position.m_123342_(), this.position.m_123343_());
        return this.position;
    }

    public BlockPos setY(int y) {
        BlockPos blockPos;
        this.position = blockPos = new BlockPos(this.position.m_123341_(), y, this.position.m_123343_());
        return this.position;
    }

    public BlockPos setZ(int z) {
        BlockPos blockPos;
        this.position = blockPos = new BlockPos(this.position.m_123341_(), this.position.m_123342_(), z);
        return this.position;
    }

    public TardisNavLocation copy() {
        TardisNavLocation copy = new TardisNavLocation(this.position, this.direction, this.dimensionKey);
        if (this.getLevel() != null) {
            copy.setLevel(this.getLevel());
        }
        if (this.name != null) {
            copy.setName(this.name);
        }
        return copy;
    }
}

