/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.tardis.control.flight;

import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;
import whocraft.tardis_refined.common.entity.ControlEntity;
import whocraft.tardis_refined.common.tardis.TardisNavLocation;
import whocraft.tardis_refined.common.tardis.control.Control;
import whocraft.tardis_refined.common.tardis.control.flight.CoordinateButton;
import whocraft.tardis_refined.common.tardis.manager.TardisPilotingManager;
import whocraft.tardis_refined.common.tardis.themes.ConsoleTheme;
import whocraft.tardis_refined.common.util.PlayerUtil;

public class CoordinateControl
extends Control {
    private CoordinateButton button;

    protected CoordinateControl(CoordinateButton button, ResourceLocation id, String langId) {
        super(id, langId);
        this.button = button;
    }

    protected CoordinateControl(CoordinateButton button, ResourceLocation id) {
        this(button, id, "control." + id.m_135827_() + ".cord_" + button.name().toLowerCase());
    }

    public CoordinateControl(CoordinateButton button, String modid) {
        this(button, new ResourceLocation(modid, button.name().toLowerCase() + "_cord"));
    }

    @Override
    public boolean onRightClick(TardisLevelOperator operator, ConsoleTheme theme, ControlEntity controlEntity, Player player) {
        return this.changeCoord(operator, theme, controlEntity, player, true);
    }

    @Override
    public boolean onLeftClick(TardisLevelOperator operator, ConsoleTheme theme, ControlEntity controlEntity, Player player) {
        return this.changeCoord(operator, theme, controlEntity, player, false);
    }

    private boolean changeCoord(TardisLevelOperator operator, ConsoleTheme theme, ControlEntity controlEntity, Player player, boolean addValue) {
        if (!operator.getLevel().m_5776_()) {
            TardisPilotingManager pilotManager = operator.getPilotingManager();
            int increment = pilotManager.getCordIncrement();
            int incrementAmount = addValue ? increment : -increment;
            TardisNavLocation targetLocation = pilotManager.getTargetLocation();
            BlockPos potentialPos = targetLocation.getPosition();
            switch (this.button) {
                case X: {
                    potentialPos = potentialPos.m_7918_(incrementAmount, 0, 0);
                    break;
                }
                case Y: {
                    potentialPos = potentialPos.m_7918_(0, incrementAmount, 0);
                    break;
                }
                case Z: {
                    potentialPos = potentialPos.m_7918_(0, 0, incrementAmount);
                }
            }
            if (pilotManager.getTargetLocation().getLevel().m_46739_(potentialPos)) {
                pilotManager.setTargetPosition(potentialPos);
                if (pilotManager.isInFlight()) {
                    operator.getPilotingManager().recalculateFlightDistance();
                }
                PlayerUtil.sendMessage((LivingEntity)player, (Component)Component.m_237115_((String)pilotManager.getTargetLocation().getPosition().m_123344_()), true);
                return true;
            }
            return false;
        }
        return false;
    }
}

