/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.tardis.control.flight;

import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;
import whocraft.tardis_refined.common.entity.ControlEntity;
import whocraft.tardis_refined.common.tardis.control.Control;
import whocraft.tardis_refined.common.tardis.control.ControlSpecification;
import whocraft.tardis_refined.common.tardis.manager.TardisPilotingManager;
import whocraft.tardis_refined.common.tardis.themes.ConsoleTheme;
import whocraft.tardis_refined.common.util.PlayerUtil;
import whocraft.tardis_refined.constants.ModMessages;

public class FuelToggleControl
extends Control {
    public FuelToggleControl(ResourceLocation id) {
        super(id);
    }

    public FuelToggleControl(ResourceLocation id, String langId) {
        super(id, langId);
    }

    @Override
    public boolean onRightClick(TardisLevelOperator operator, ConsoleTheme theme, ControlEntity controlEntity, Player player) {
        if (!operator.getLevel().m_5776_()) {
            TardisPilotingManager pilotManager;
            if (operator.getTardisState() != 2) {
                return false;
            }
            boolean successful = pilotManager.setPassivelyRefuelling(!(pilotManager = operator.getPilotingManager()).isPassivelyRefuelling());
            if (successful) {
                PlayerUtil.sendMessage((LivingEntity)player, (Component)Component.m_237115_((String)(pilotManager.isPassivelyRefuelling() ? ModMessages.REFUEL : ModMessages.STOP_REFUEL)), true);
            }
            return successful;
        }
        return false;
    }

    @Override
    public boolean onLeftClick(TardisLevelOperator operator, ConsoleTheme theme, ControlEntity controlEntity, Player player) {
        return false;
    }

    @Override
    public boolean hasCustomName() {
        return true;
    }

    @Override
    public Component getCustomControlName(TardisLevelOperator operator, ControlEntity entity, ControlSpecification controlSpecification) {
        boolean offline;
        if (operator == null) {
            return super.getCustomControlName(operator, entity, controlSpecification);
        }
        boolean bl = offline = operator.getTardisState() != 2;
        if (offline) {
            return Component.m_237115_((String)ModMessages.FUEL_OFFLINE);
        }
        return Component.m_237110_((String)ModMessages.FUEL, (Object[])new Object[]{String.valueOf(Math.round(operator.getPilotingManager().getFuelPercentage() * 100.0f))}).m_130946_("%");
    }
}

