/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.tardis.control.ship;

import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;
import whocraft.tardis_refined.common.entity.ControlEntity;
import whocraft.tardis_refined.common.items.DimensionSamplerItem;
import whocraft.tardis_refined.common.items.KeyItem;
import whocraft.tardis_refined.common.network.messages.screens.S2COpenMonitor;
import whocraft.tardis_refined.common.tardis.control.Control;
import whocraft.tardis_refined.common.tardis.control.ControlSpecification;
import whocraft.tardis_refined.common.tardis.themes.ConsoleTheme;
import whocraft.tardis_refined.common.util.MiscHelper;
import whocraft.tardis_refined.common.util.PlayerUtil;
import whocraft.tardis_refined.constants.ModMessages;

public class MonitorControl
extends Control {
    public MonitorControl(ResourceLocation id) {
        super(id, true);
    }

    public MonitorControl(ResourceLocation id, String langId) {
        super(id, langId, true);
    }

    @Override
    public boolean onRightClick(TardisLevelOperator operator, ConsoleTheme theme, ControlEntity controlEntity, Player player) {
        if (!player.m_9236_().m_5776_()) {
            KeyItem key;
            if (operator.getTardisState() != 2 || operator.getPilotingManager().isOutOfFuel()) {
                PlayerUtil.sendMessage((LivingEntity)player, ModMessages.FUEL_OFFLINE, true);
                return false;
            }
            ItemStack hand = player.m_21205_();
            Item item = hand.m_41720_();
            if (item instanceof DimensionSamplerItem) {
                DimensionSamplerItem dimTrackerItem = (DimensionSamplerItem)item;
                ResourceKey<Level> levelResourceKey = DimensionSamplerItem.getSavedDim(hand);
                if (levelResourceKey != null) {
                    operator.getProgressionManager().addDiscoveredLevel(levelResourceKey);
                    PlayerUtil.sendMessage((LivingEntity)player, (Component)Component.m_237110_((String)ModMessages.DIM_ADDED_TO_TARDIS, (Object[])new Object[]{MiscHelper.getCleanDimensionName(levelResourceKey)}), true);
                    hand.m_41764_(0);
                }
                return false;
            }
            boolean isSyncingKey = false;
            Item item2 = hand.m_41720_();
            if (item2 instanceof KeyItem && (key = (KeyItem)item2).interactMonitor(hand, player, controlEntity, player.m_7655_())) {
                isSyncingKey = true;
            }
            if (!isSyncingKey) {
                new S2COpenMonitor(operator.getInteriorManager().isWaitingToGenerate(), operator.getPilotingManager().getCurrentLocation(), operator.getPilotingManager().getTargetLocation(), operator.getUpgradeHandler(), operator.getAestheticHandler().getShellTheme()).send((ServerPlayer)player);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean onLeftClick(TardisLevelOperator operator, ConsoleTheme theme, ControlEntity controlEntity, Player player) {
        return false;
    }

    @Override
    public boolean hasCustomName() {
        return true;
    }

    @Override
    public Component getCustomControlName(TardisLevelOperator operator, ControlEntity entity, ControlSpecification controlSpecification) {
        if (operator.getPilotingManager().isInFlight() && !operator.getPilotingManager().isLanding()) {
            float percentageCompleted = operator.getPilotingManager().getFlightPercentageCovered() * 100.0f;
            if (percentageCompleted > 100.0f) {
                percentageCompleted = 100.0f;
            }
            return Component.m_237115_((String)controlSpecification.control().getTranslationKey()).m_130946_(" (" + (int)percentageCompleted + "%)");
        }
        return super.getCustomControlName(operator, entity, controlSpecification);
    }
}

