/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.tardis.manager;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import whocraft.tardis_refined.common.blockentity.console.GlobalConsoleBlockEntity;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;
import whocraft.tardis_refined.common.entity.ControlEntity;
import whocraft.tardis_refined.common.tardis.manager.TardisPilotingManager;
import whocraft.tardis_refined.common.tardis.manager.TickableHandler;

public class FlightDanceManager
extends TickableHandler {
    private TardisLevelOperator operator;
    private TardisPilotingManager pilotingManager;
    private List<ControlEntity> controlEntityList = new ArrayList<ControlEntity>();
    private int damagedControlCount = 0;
    private boolean weAreDancing = false;

    public FlightDanceManager(TardisLevelOperator operator) {
        this.operator = operator;
        this.pilotingManager = this.operator.getPilotingManager();
    }

    public TardisLevelOperator getOperator() {
        return this.operator;
    }

    public boolean isDancing() {
        return this.weAreDancing;
    }

    private List<ControlEntity> getNonCriticalControls(GlobalConsoleBlockEntity controllerConsole) {
        List<ControlEntity> allControlsOnConsole = controllerConsole.getControlEntityList();
        ArrayList<ControlEntity> updatedList = new ArrayList<ControlEntity>(allControlsOnConsole);
        for (ControlEntity controlEntity : allControlsOnConsole) {
            if (!controlEntity.controlSpecification().control().isCriticalForTardisOperation()) continue;
            updatedList.remove((Object)controlEntity);
        }
        return updatedList;
    }

    public void startFlightDance(GlobalConsoleBlockEntity controllerConsole) {
        if (controllerConsole == null) {
            return;
        }
        this.controlEntityList = this.getNonCriticalControls(controllerConsole);
        this.weAreDancing = true;
    }

    @Override
    public void tick(ServerLevel operatorLevel) {
        if (this.weAreDancing && operatorLevel.m_46467_() % 20L == 0L) {
            this.onDanceTick(operatorLevel);
        }
    }

    @Override
    public CompoundTag saveData(CompoundTag tag) {
        tag.m_128379_("weAreDancing", this.weAreDancing);
        tag.m_128405_("damagedControlCount", this.damagedControlCount);
        return tag;
    }

    @Override
    public void loadData(CompoundTag tag) {
        this.weAreDancing = tag.m_128471_("weAreDancing");
        this.damagedControlCount = tag.m_128451_("damagedControlCount");
    }

    public void stopDancing() {
        this.updateControlsAfterDance();
        this.controlEntityList = new ArrayList<ControlEntity>();
        this.damagedControlCount = 0;
        this.weAreDancing = false;
    }

    private void onDanceTick(ServerLevel operatorLevel) {
        if (this.damagedControlCount >= 5) {
            this.stopDancing();
            this.operator.getPilotingManager().crash();
            return;
        }
        int chance = 20 - this.operator.getPilotingManager().getThrottleStage() * 2;
        if (operatorLevel.f_46441_.m_188503_(chance) == 0) {
            this.triggerNextEvent();
        }
    }

    private void triggerNextEvent() {
        if (this.controlEntityList.isEmpty()) {
            GlobalConsoleBlockEntity console = this.operator.getPilotingManager().getCurrentConsole();
            if (console == null) {
                this.stopDancing();
                this.operator.getPilotingManager().endFlight(true, false);
                return;
            }
            console.killControls();
            console.spawnControlEntities();
            this.controlEntityList.addAll(console.getControlEntityList());
        }
        ControlEntity randomControlEntity = this.controlEntityList.get(this.operator.getLevel().f_46441_.m_188503_(this.controlEntityList.size() - 1));
        randomControlEntity.setTickingDown(this);
    }

    public void updateDamageList() {
        ++this.damagedControlCount;
    }

    private void updateControlsAfterDance() {
        if (this.pilotingManager.getCurrentConsole() != null) {
            this.pilotingManager.getCurrentConsole().killControls();
            this.pilotingManager.getCurrentConsole().spawnControlEntities();
        }
    }
}

