/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.tardis.manager;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import whocraft.tardis_refined.TRConfig;
import whocraft.tardis_refined.common.tardis.manager.BaseHandler;
import whocraft.tardis_refined.common.util.DimensionUtil;
import whocraft.tardis_refined.common.util.Platform;

public class ProgressionManager
extends BaseHandler {
    private ArrayList<ResourceKey<Level>> DISCOVERED_LEVELS = new ArrayList();

    public ArrayList<ResourceKey<Level>> getDiscoveredLevels() {
        if (!((Boolean)TRConfig.SERVER.ADVENTURE_MODE.get()).booleanValue()) {
            return new ArrayList<ResourceKey<Level>>(DimensionUtil.getAllowedDimensions(Platform.getServer()));
        }
        for (String defaults : (List)TRConfig.SERVER.ADVENTURE_MODE_DEFAULTS.get()) {
            ResourceKey level = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(defaults));
            this.addDiscoveredLevel((ResourceKey<Level>)level);
        }
        return this.DISCOVERED_LEVELS.stream().filter(DimensionUtil::isAllowedDimension).collect(Collectors.toCollection(ArrayList::new));
    }

    public void setDiscoveredLevels(ArrayList<ResourceKey<Level>> allowedLevels) {
        if (allowedLevels != null) {
            this.DISCOVERED_LEVELS = new ArrayList<ResourceKey<Level>>(allowedLevels);
        } else {
            this.DISCOVERED_LEVELS.clear();
        }
    }

    public boolean addDiscoveredLevel(ResourceKey<Level> level) {
        if (level != null && !this.DISCOVERED_LEVELS.contains(level) && DimensionUtil.isAllowedDimension(level)) {
            return this.DISCOVERED_LEVELS.add(level);
        }
        return false;
    }

    public boolean undiscoverLevel(ResourceKey<Level> level) {
        return this.DISCOVERED_LEVELS.remove(level);
    }

    public boolean isLevelDiscovered(ResourceKey<Level> level) {
        if (!((Boolean)TRConfig.SERVER.ADVENTURE_MODE.get()).booleanValue()) {
            return DimensionUtil.isAllowedDimension(level);
        }
        return this.getDiscoveredLevels().contains(level);
    }

    @Override
    public CompoundTag saveData(CompoundTag tag) {
        ListTag levelsList = new ListTag();
        for (ResourceKey<Level> level : this.DISCOVERED_LEVELS) {
            levelsList.add((Object)StringTag.m_129297_((String)level.m_135782_().toString()));
        }
        tag.m_128365_("DiscoveredLevels", (Tag)levelsList);
        return tag;
    }

    @Override
    public void loadData(CompoundTag tag) {
        if (tag.m_128441_("DiscoveredLevels")) {
            ListTag levelsList = tag.m_128437_("DiscoveredLevels", 8);
            this.DISCOVERED_LEVELS.clear();
            for (Tag levelTag : levelsList) {
                String levelKey = levelTag.m_7916_();
                ResourceKey level = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(levelKey));
                this.DISCOVERED_LEVELS.add((ResourceKey<Level>)level);
            }
        }
    }
}

