/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.tardis.manager;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import whocraft.tardis_refined.api.event.TardisCommonEvents;
import whocraft.tardis_refined.common.block.door.BulkHeadDoorBlock;
import whocraft.tardis_refined.common.blockentity.door.BulkHeadDoorBlockEntity;
import whocraft.tardis_refined.common.blockentity.door.TardisInternalDoor;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;
import whocraft.tardis_refined.common.capability.tardis.upgrades.UpgradeHandler;
import whocraft.tardis_refined.common.dimension.TardisTeleportData;
import whocraft.tardis_refined.common.protection.ProtectedZone;
import whocraft.tardis_refined.common.soundscape.hum.HumEntry;
import whocraft.tardis_refined.common.soundscape.hum.TardisHums;
import whocraft.tardis_refined.common.tardis.TardisArchitectureHandler;
import whocraft.tardis_refined.common.tardis.TardisDesktops;
import whocraft.tardis_refined.common.tardis.manager.TardisExteriorManager;
import whocraft.tardis_refined.common.tardis.manager.TardisPilotingManager;
import whocraft.tardis_refined.common.tardis.manager.TickableHandler;
import whocraft.tardis_refined.common.tardis.themes.DesktopTheme;
import whocraft.tardis_refined.constants.TardisDimensionConstants;
import whocraft.tardis_refined.registry.TRBlockRegistry;
import whocraft.tardis_refined.registry.TRUpgrades;

public class TardisInteriorManager
extends TickableHandler {
    public static final BlockPos STATIC_CORRIDOR_POSITION = new BlockPos(1013, 99, 5);
    private final TardisLevelOperator operator;
    BlockPos pillarTopLeft = new BlockPos(1024, 78, 55);
    BlockPos pillarTopRight = new BlockPos(1002, 78, 55);
    BlockPos pillarBottomLeft = new BlockPos(1016, 73, 55);
    BlockPos pillarBottomRight = new BlockPos(1010, 73, 55);
    private boolean isWaitingToGenerate = false;
    private boolean isGeneratingDesktop = false;
    private boolean hasGeneratedCorridors = false;
    private int interiorGenerationCooldown = 0;
    private BlockPos corridorAirlockCenter = BlockPos.f_121853_;
    private DesktopTheme preparedTheme;
    private DesktopTheme currentTheme = TardisDesktops.DEFAULT_OVERGROWN_THEME;
    private boolean processingWarping = false;
    private int airlockCountdownSeconds = 3;
    private int airlockTimerSeconds = 5;
    private HumEntry humEntry = TardisHums.getDefaultHum();
    private double fuelForIntChange = 100.0;

    public TardisInteriorManager(TardisLevelOperator operator) {
        this.operator = operator;
    }

    public DesktopTheme preparedTheme() {
        return this.preparedTheme;
    }

    public boolean isGeneratingDesktop() {
        return this.isGeneratingDesktop;
    }

    public boolean isWaitingToGenerate() {
        return this.isWaitingToGenerate;
    }

    public int getInteriorGenerationCooldown() {
        return this.interiorGenerationCooldown / 20;
    }

    public ProtectedZone[] unbreakableZones() {
        if (!this.hasGeneratedCorridors || this.corridorAirlockCenter == null) {
            return new ProtectedZone[0];
        }
        ProtectedZone ctrlRoomAirlck = new ProtectedZone(this.corridorAirlockCenter.m_6625_(2).m_122013_(2).m_122025_(3), this.corridorAirlockCenter.m_122020_(3).m_122030_(3).m_6630_(5), "control_room_airlock");
        ProtectedZone hubAirlck = new ProtectedZone(STATIC_CORRIDOR_POSITION.m_6625_(2).m_122013_(2).m_122025_(3), STATIC_CORRIDOR_POSITION.m_122020_(3).m_122030_(3).m_6630_(6), "hub_airlock");
        ProtectedZone arsRoom = new ProtectedZone(new BlockPos(1051, 97, 6), new BlockPos(1023, 118, 36), "ars_room");
        return new ProtectedZone[]{ctrlRoomAirlck, hubAirlck, arsRoom};
    }

    public DesktopTheme currentTheme() {
        return this.currentTheme;
    }

    public TardisInteriorManager setCurrentTheme(DesktopTheme currentTheme) {
        this.currentTheme = currentTheme;
        return this;
    }

    public boolean isCave() {
        return this.currentTheme == TardisDesktops.DEFAULT_OVERGROWN_THEME;
    }

    public HumEntry getHumEntry() {
        return this.humEntry;
    }

    public void setHumEntry(HumEntry humEntry) {
        this.humEntry = humEntry;
    }

    @Override
    public CompoundTag saveData(CompoundTag tag) {
        tag.m_128379_("im_waiting_to_generate", this.isWaitingToGenerate);
        tag.m_128379_("im_generating_desktop", this.isGeneratingDesktop);
        tag.m_128405_("im_generation_cooldown", this.interiorGenerationCooldown);
        tag.m_128379_("im_generated_corridors", this.hasGeneratedCorridors);
        if (this.corridorAirlockCenter != null) {
            tag.m_128365_("im_generated_airlock_center", (Tag)NbtUtils.m_129224_((BlockPos)this.corridorAirlockCenter));
        }
        tag.m_128359_("im_prepared_desktop_theme", this.preparedTheme != null ? this.preparedTheme.getIdentifier().toString() : "");
        if (this.currentTheme != null) {
            tag.m_128359_("im_current_desktop_theme", this.currentTheme.getIdentifier().toString());
        }
        tag.m_128359_("tardis_current_hum", this.humEntry.getIdentifier().toString());
        tag.m_128347_("tardis_fuel_for_int_change", this.fuelForIntChange);
        return tag;
    }

    @Override
    public void loadData(CompoundTag tag) {
        this.isWaitingToGenerate = tag.m_128471_("im_waiting_to_generate");
        this.isGeneratingDesktop = tag.m_128471_("im_generating_desktop");
        this.interiorGenerationCooldown = tag.m_128451_("im_generation_cooldown");
        this.hasGeneratedCorridors = tag.m_128471_("im_generated_corridors");
        this.preparedTheme = TardisDesktops.getDesktopById(new ResourceLocation(tag.m_128461_("im_prepared_desktop_theme")));
        this.currentTheme = tag.m_128441_("im_current_desktop_theme") ? TardisDesktops.getDesktopById(new ResourceLocation("im_current_desktop_theme")) : this.preparedTheme;
        this.corridorAirlockCenter = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("im_generated_airlock_center"));
        this.humEntry = TardisHums.getHumById(new ResourceLocation(tag.m_128461_("tardis_current_hum")));
        this.fuelForIntChange = tag.m_128459_("tardis_fuel_for_int_change");
        if (!tag.m_128441_("tardis_fuel_for_int_change")) {
            this.fuelForIntChange = 500.0;
        }
    }

    @Override
    public void tick(ServerLevel level) {
        Object desktopEntities;
        TardisExteriorManager exteriorManager;
        RandomSource rand = level.m_213780_();
        if (this.shouldTheEyeBeOpen(level)) {
            this.openTheEye();
        }
        if ((exteriorManager = this.operator.getExteriorManager()) == null) {
            return;
        }
        TardisPilotingManager pilotingManager = this.operator.getPilotingManager();
        if (pilotingManager == null) {
            return;
        }
        this.handleDesktopGeneration(level);
        if (!this.processingWarping && level.m_46467_() % 20L == 0L) {
            desktopEntities = this.getAirlockEntities((Level)level);
            List<LivingEntity> corridorEntities = this.getCorridorEntities((Level)level);
            if (!desktopEntities.isEmpty() || !corridorEntities.isEmpty()) {
                --this.airlockCountdownSeconds;
                if (this.airlockCountdownSeconds <= 0) {
                    BlockPos corridorDoorBlockPos;
                    BlockEntity blockEntity;
                    this.processingWarping = true;
                    this.airlockCountdownSeconds = 10;
                    this.airlockTimerSeconds = 0;
                    BlockPos desktopDoorPos2 = this.corridorAirlockCenter.m_122013_(2);
                    BlockEntity blockEntity2 = level.m_7702_(desktopDoorPos2);
                    if (blockEntity2 instanceof BulkHeadDoorBlockEntity) {
                        BulkHeadDoorBlockEntity bulkHeadDoorBlockEntity = (BulkHeadDoorBlockEntity)blockEntity2;
                        bulkHeadDoorBlockEntity.toggleDoor((Level)level, desktopDoorPos2, level.m_8055_(desktopDoorPos2), false);
                        level.m_7731_(desktopDoorPos2, (BlockState)level.m_8055_(desktopDoorPos2).m_61124_((Property)BulkHeadDoorBlock.LOCKED, (Comparable)Boolean.valueOf(true)), 2);
                    }
                    if ((blockEntity = level.m_7702_(corridorDoorBlockPos = TardisDimensionConstants.CORRIDOR_AIRLOCK_DOOR_POS)) instanceof BulkHeadDoorBlockEntity) {
                        BulkHeadDoorBlockEntity bulkHeadDoorBlockEntity = (BulkHeadDoorBlockEntity)blockEntity;
                        bulkHeadDoorBlockEntity.toggleDoor((Level)level, corridorDoorBlockPos, level.m_8055_(corridorDoorBlockPos), false);
                        level.m_7731_(corridorDoorBlockPos, (BlockState)level.m_8055_(corridorDoorBlockPos).m_61124_((Property)BulkHeadDoorBlock.LOCKED, (Comparable)Boolean.valueOf(true)), 2);
                    }
                }
            } else {
                this.processingWarping = false;
                this.airlockCountdownSeconds = 3;
                this.airlockTimerSeconds = 0;
            }
        }
        if (this.processingWarping && level.m_46467_() % 20L == 0L) {
            for (ProtectedZone protectedZone : this.unbreakableZones()) {
                if (!protectedZone.getName().contains("_airlock")) continue;
                BlockPos.m_121921_((AABB)protectedZone.getArea()).forEach(position -> {
                    double velocityX = (rand.m_188500_() - 0.5) * 0.02;
                    double velocityY = (rand.m_188500_() - 0.5) * 0.02;
                    double velocityZ = (rand.m_188500_() - 0.5) * 0.02;
                    level.m_8767_((ParticleOptions)ParticleTypes.f_123796_, (double)position.m_123341_(), (double)position.m_123342_(), (double)position.m_123343_(), 2, velocityX, velocityY, velocityZ, velocityZ);
                });
            }
            if (this.airlockTimerSeconds == 1) {
                level.m_5594_(null, this.corridorAirlockCenter, SoundEvents.f_11937_, SoundSource.BLOCKS, 5.0f, 0.25f);
                level.m_5594_(null, STATIC_CORRIDOR_POSITION, SoundEvents.f_11937_, SoundSource.BLOCKS, 5.0f, 0.25f);
            }
            if (this.airlockTimerSeconds == 3) {
                desktopEntities = this.getAirlockEntities((Level)level);
                List<LivingEntity> corridorEntities = this.getCorridorEntities((Level)level);
                desktopEntities.forEach(x -> {
                    Vec3 offsetPos = x.m_20182_().m_82546_(Vec3.m_82512_((Vec3i)this.corridorAirlockCenter));
                    TardisTeleportData.scheduleEntityTeleport((Entity)x, (ResourceKey<Level>)level.m_46472_(), (double)STATIC_CORRIDOR_POSITION.m_123341_() + offsetPos.m_7096_() + 0.5, (double)STATIC_CORRIDOR_POSITION.m_123342_() + offsetPos.m_7098_() + 0.5, (double)STATIC_CORRIDOR_POSITION.m_123343_() + offsetPos.m_7094_() + 0.5, x.m_146908_(), x.m_146909_());
                });
                corridorEntities.forEach(x -> {
                    Vec3 offsetPos = x.m_20182_().m_82546_(Vec3.m_82512_((Vec3i)STATIC_CORRIDOR_POSITION));
                    TardisTeleportData.scheduleEntityTeleport((Entity)x, (ResourceKey<Level>)level.m_46472_(), (double)this.corridorAirlockCenter.m_123341_() + offsetPos.m_7096_() + 0.5, (double)this.corridorAirlockCenter.m_123342_() + offsetPos.m_7098_() + 0.5, (double)this.corridorAirlockCenter.m_123343_() + offsetPos.m_7094_() + 0.5, x.m_146908_(), x.m_146909_());
                });
            }
            if (this.airlockTimerSeconds == 5) {
                BlockPos corridorDoorBlockPos;
                BlockEntity blockEntity;
                this.processingWarping = false;
                this.airlockTimerSeconds = 20;
                BlockPos desktopDoorPos = this.corridorAirlockCenter.m_122013_(2);
                BlockEntity desktopDoorPos2 = level.m_7702_(desktopDoorPos);
                if (desktopDoorPos2 instanceof BulkHeadDoorBlockEntity) {
                    BulkHeadDoorBlockEntity bulkHeadDoorBlockEntity = (BulkHeadDoorBlockEntity)desktopDoorPos2;
                    bulkHeadDoorBlockEntity.toggleDoor((Level)level, desktopDoorPos, level.m_8055_(desktopDoorPos), true);
                    level.m_7731_(desktopDoorPos, (BlockState)level.m_8055_(desktopDoorPos).m_61124_((Property)BulkHeadDoorBlock.LOCKED, (Comparable)Boolean.valueOf(false)), 2);
                }
                if ((blockEntity = level.m_7702_(corridorDoorBlockPos = TardisDimensionConstants.CORRIDOR_AIRLOCK_DOOR_POS)) instanceof BulkHeadDoorBlockEntity) {
                    BulkHeadDoorBlockEntity bulkHeadDoorBlockEntity = (BulkHeadDoorBlockEntity)blockEntity;
                    bulkHeadDoorBlockEntity.toggleDoor((Level)level, corridorDoorBlockPos, level.m_8055_(corridorDoorBlockPos), true);
                    level.m_7731_(corridorDoorBlockPos, (BlockState)level.m_8055_(corridorDoorBlockPos).m_61124_((Property)BulkHeadDoorBlock.LOCKED, (Comparable)Boolean.valueOf(false)), 2);
                }
            }
            ++this.airlockTimerSeconds;
        }
    }

    public boolean shouldTheEyeBeOpen(ServerLevel level) {
        return level.m_8055_(this.pillarTopLeft).m_60734_() == TRBlockRegistry.ARTRON_PILLAR.get() && level.m_8055_(this.pillarTopRight).m_60734_() == TRBlockRegistry.ARTRON_PILLAR.get() && level.m_8055_(this.pillarBottomLeft).m_60734_() == TRBlockRegistry.ARTRON_PILLAR.get() && level.m_8055_(this.pillarBottomRight).m_60734_() == TRBlockRegistry.ARTRON_PILLAR.get() && this.operator.getTardisState() != 2;
    }

    public void openTheEye() {
        this.openTheEye(false);
    }

    public void setEyePillars(Level level) {
        level.m_7731_(this.pillarTopLeft, TRBlockRegistry.ARTRON_PILLAR.get().m_49966_(), 3);
        level.m_7731_(this.pillarTopRight, TRBlockRegistry.ARTRON_PILLAR.get().m_49966_(), 3);
        level.m_7731_(this.pillarBottomLeft, TRBlockRegistry.ARTRON_PILLAR.get().m_49966_(), 3);
        level.m_7731_(this.pillarBottomRight, TRBlockRegistry.ARTRON_PILLAR.get().m_49966_(), 3);
    }

    public void openTheEye(boolean forced) {
        Level level = this.operator.getLevel();
        this.operator.setTardisState(2);
        Vec3 eyeCenter = new Vec3(1013.0, 72.0, 55.0);
        AABB portalDoorLength = new AABB(1011.0, 72.0, 54.0, 1015.0, 71.0, 56.0);
        AABB portalDoorWidth = new AABB(1014.0, 71.0, 57.0, 1012.0, 72.0, 53.0);
        if (forced) {
            this.setEyePillars(level);
        }
        BlockPos.m_121921_((AABB)portalDoorLength).forEach(x -> level.m_7731_(x, Blocks.f_50016_.m_49966_(), 3));
        BlockPos.m_121921_((AABB)portalDoorWidth).forEach(x -> level.m_7731_(x, Blocks.f_50016_.m_49966_(), 3));
        LightningBolt lightningBolt = new LightningBolt(EntityType.f_20465_, this.operator.getLevel());
        lightningBolt.m_146884_(eyeCenter);
        this.operator.getLevel().m_7967_((Entity)lightningBolt);
        this.setHumEntry(TardisHums.getDefaultHum());
    }

    public List<LivingEntity> getCorridorEntities(Level level) {
        return level.m_45976_(LivingEntity.class, new AABB(STATIC_CORRIDOR_POSITION.m_122013_(2).m_122025_(2), STATIC_CORRIDOR_POSITION.m_122020_(2).m_122030_(2).m_6630_(4)));
    }

    public List<LivingEntity> getAirlockEntities(Level level) {
        if (this.corridorAirlockCenter == null) {
            return new ArrayList<LivingEntity>();
        }
        return level.m_45976_(LivingEntity.class, new AABB(this.corridorAirlockCenter.m_122013_(2).m_122025_(2), this.corridorAirlockCenter.m_122020_(2).m_122030_(2).m_6630_(4)));
    }

    public boolean isInAirlock(LivingEntity livingEntity) {
        if (!this.hasGeneratedCorridors) {
            return false;
        }
        List<LivingEntity> airlock = this.getAirlockEntities(livingEntity.m_9236_());
        List<LivingEntity> corridor = this.getCorridorEntities(livingEntity.m_9236_());
        return airlock.contains(livingEntity) || corridor.contains(livingEntity);
    }

    public BlockPos getCorridorAirlockCenter() {
        return this.corridorAirlockCenter;
    }

    public void setCorridorAirlockCenter(BlockPos center) {
        this.corridorAirlockCenter = center;
    }

    public void handleDesktopGeneration(ServerLevel level) {
        if (this.isWaitingToGenerate) {
            if (level.f_46441_.m_188503_(30) == 0) {
                level.m_5594_(null, TardisArchitectureHandler.DESKTOP_CENTER_POS, SoundEvents.f_11936_, SoundSource.BLOCKS, 5.0f + level.f_46441_.m_188501_(), level.f_46441_.m_188501_() * 0.7f + 0.3f);
            }
            if (level.f_46441_.m_188503_(100) == 0) {
                level.m_5594_(null, TardisArchitectureHandler.DESKTOP_CENTER_POS, SoundEvents.f_11739_, SoundSource.BLOCKS, 15.0f + level.f_46441_.m_188501_(), 0.1f);
            }
            if (level.m_6907_().isEmpty() && this.operator.triggerRegenState(true)) {
                this.operator.forceEjectAllPlayers();
                TardisCommonEvents.DESKTOP_CHANGE_EVENT.invoker().onDesktopChange(this.operator);
                this.generateDesktop(this.preparedTheme);
                this.isWaitingToGenerate = false;
                this.isGeneratingDesktop = true;
            }
        }
        if (this.isGeneratingDesktop) {
            if (!level.m_5776_()) {
                --this.interiorGenerationCooldown;
            }
            if (this.interiorGenerationCooldown == 0 && this.operator.triggerRegenState(false)) {
                this.isGeneratingDesktop = false;
            }
            if (level.m_46467_() % 60L == 0L) {
                this.operator.getExteriorManager().playSoundAtShell(SoundEvents.f_11739_, SoundSource.BLOCKS, 1.0f + this.operator.getLevel().m_213780_().m_188501_(), 0.1f);
            }
        }
    }

    public void generateDesktop(DesktopTheme theme) {
        Level level = this.operator.getLevel();
        if (level instanceof ServerLevel) {
            TardisInternalDoor tardisInternalDoor;
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.operator.getTardisState() == 0) {
                this.operator.setTardisState(1);
            }
            if ((tardisInternalDoor = this.operator.getInternalDoor()) != null) {
                serverLevel.m_7471_(tardisInternalDoor.getDoorPosition(), false);
            }
            this.hasGeneratedCorridors = true;
            TardisArchitectureHandler.generateDesktop(serverLevel, theme);
            this.setCurrentTheme(theme);
        }
    }

    public boolean isHasGeneratedCorridors() {
        return this.hasGeneratedCorridors;
    }

    public void setHasGeneratedCorridors(boolean hasGeneratedCorridors) {
        this.hasGeneratedCorridors = hasGeneratedCorridors;
    }

    public void prepareDesktop(DesktopTheme theme) {
        this.preparedTheme = theme;
        this.isWaitingToGenerate = true;
        int cooldownSeconds = 180;
        UpgradeHandler upgradeHandler = this.operator.getUpgradeHandler();
        if (upgradeHandler.isUpgradeUnlocked(TRUpgrades.IMPROVED_GENERATION_TIME_I.get())) {
            cooldownSeconds = 120;
        }
        if (upgradeHandler.isUpgradeUnlocked(TRUpgrades.IMPROVED_GENERATION_TIME_II.get())) {
            cooldownSeconds = 30;
        }
        if (upgradeHandler.isUpgradeUnlocked(TRUpgrades.IMPROVED_GENERATION_TIME_III.get())) {
            cooldownSeconds = 10;
        }
        this.interiorGenerationCooldown = 20 * cooldownSeconds;
    }

    public void cancelDesktopChange() {
        this.preparedTheme = null;
        this.isWaitingToGenerate = false;
    }

    public boolean hasEnoughFuel() {
        return this.operator.getPilotingManager().getFuel() >= this.getRequiredFuel();
    }

    public double getRequiredFuel() {
        return this.fuelForIntChange;
    }

    private void setRequiredFuel(double fuel) {
        this.fuelForIntChange = fuel;
    }
}

