/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.tardis.manager;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;
import whocraft.tardis_refined.common.tardis.TardisNavLocation;
import whocraft.tardis_refined.common.tardis.TardisWaypoint;
import whocraft.tardis_refined.common.tardis.manager.BaseHandler;

public class TardisWaypointManager
extends BaseHandler {
    private final TardisLevelOperator operator;
    private List<TardisWaypoint> waypoints = new ArrayList<TardisWaypoint>();

    public TardisWaypointManager(TardisLevelOperator tardisLevelOperator) {
        this.operator = tardisLevelOperator;
    }

    public void addWaypoint(TardisNavLocation tardisNavLocation, String name) {
        tardisNavLocation.setName(name);
        this.waypoints.add(new TardisWaypoint(tardisNavLocation));
    }

    public void editWaypoint(TardisWaypoint waypoint) {
        this.waypoints.removeIf(x -> x.getId().equals(waypoint.getId()));
        this.waypoints.add(waypoint);
    }

    public void deleteWaypoint(UUID id) {
        this.waypoints.removeIf(x -> x.getId().equals(id));
    }

    public List<TardisWaypoint> getWaypoints() {
        return this.waypoints;
    }

    public TardisWaypoint getWaypointById(UUID id) {
        Optional<TardisWaypoint> waypoint = this.waypoints.stream().filter(x -> x.getId().equals(id)).findFirst();
        return waypoint.orElse(null);
    }

    @Override
    public CompoundTag saveData(CompoundTag compoundTag) {
        ListTag waypointsList = new ListTag();
        for (TardisWaypoint waypoint : this.waypoints) {
            CompoundTag waypointTag = waypoint.serialise();
            waypointsList.add((Object)waypointTag);
        }
        compoundTag.m_128365_("Waypoints", (Tag)waypointsList);
        return compoundTag;
    }

    @Override
    public void loadData(CompoundTag tag) {
        this.waypoints.clear();
        ListTag waypointsList = tag.m_128437_("Waypoints", 10);
        for (int i = 0; i < waypointsList.size(); ++i) {
            CompoundTag locationTag = waypointsList.m_128728_(i);
            TardisWaypoint waypoint = TardisWaypoint.deserialise(locationTag);
            this.waypoints.add(waypoint);
        }
    }
}

