/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.util;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.apache.commons.lang3.text.WordUtils;
import whocraft.tardis_refined.TardisRefined;
import whocraft.tardis_refined.common.block.console.GlobalConsoleBlock;
import whocraft.tardis_refined.common.block.life.EyeBlock;
import whocraft.tardis_refined.common.block.shell.ShellBaseBlock;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;
import whocraft.tardis_refined.common.protection.ProtectedZone;
import whocraft.tardis_refined.common.util.forge.MiscHelperImpl;
import whocraft.tardis_refined.registry.TRBlockRegistry;
import whocraft.tardis_refined.registry.TRDimensionTypes;

public class MiscHelper {
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Packet<ClientGamePacketListener> spawnPacket(Entity entity) {
        return MiscHelperImpl.spawnPacket(entity);
    }

    public static String convertTicksToRealTime(int ticks) {
        long totalSeconds = ticks / 20;
        long years = totalSeconds / 31104000L;
        long remainingAfterYears = totalSeconds % 31104000L;
        long months = remainingAfterYears / 2592000L;
        long remainingAfterMonths = remainingAfterYears % 2592000L;
        long days = remainingAfterMonths / 86400L;
        long remainingAfterDays = remainingAfterMonths % 86400L;
        long hours = remainingAfterDays / 3600L;
        long remainingAfterHours = remainingAfterDays % 3600L;
        long minutes = remainingAfterHours / 60L;
        long seconds = remainingAfterHours % 60L;
        StringBuilder result = new StringBuilder();
        if (years > 0L) {
            result.append(years).append(years == 1L ? " year, " : " years, ");
        }
        if (months > 0L) {
            result.append(months).append(months == 1L ? " month, " : " months, ");
        }
        if (days > 0L) {
            result.append(days).append(days == 1L ? " day, " : " days, ");
        }
        if (hours > 0L) {
            result.append(hours).append(hours == 1L ? " hour, " : " hours, ");
        }
        if (minutes > 0L) {
            result.append(minutes).append(minutes == 1L ? " minute, " : " minutes, ");
        }
        if (seconds > 0L || result.isEmpty()) {
            result.append(seconds).append(seconds == 1L ? " second" : " seconds");
        } else {
            result.setLength(result.length() - 2);
        }
        return result.toString();
    }

    public static boolean isBlockPosInBox(BlockPos blockPos, AABB aabb) {
        return aabb.m_82393_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
    }

    public static ResourceKey<Level> idToKey(ResourceLocation identifier) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)identifier);
    }

    public static boolean performTeleport(Entity pEntity, ServerLevel pLevel, double pX, double pY, double pZ, float pYaw, float pPitch) {
        TardisRefined.LOGGER.debug("Teleported {} to {} {} {}", (Object)pEntity.m_5446_().getString(), (Object)pX, (Object)pY, (Object)pZ);
        int xRound = (int)pX;
        int yRound = (int)pY;
        int zRound = (int)pZ;
        BlockPos blockpos = new BlockPos(xRound, yRound, zRound);
        if (!Level.m_46741_((BlockPos)blockpos)) {
            return false;
        }
        float f = Mth.m_14177_((float)pYaw);
        float f1 = Mth.m_14177_((float)pPitch);
        if (pEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)pEntity;
            ChunkPos chunkpos = new ChunkPos(blockpos);
            pLevel.m_7726_().m_8387_(TicketType.f_9448_, chunkpos, 1, (Object)pEntity.m_19879_());
            pEntity.m_8127_();
            if (serverPlayer.m_5803_()) {
                serverPlayer.m_6145_(true, true);
            }
            if (pLevel == pEntity.m_9236_()) {
                serverPlayer.f_8906_.m_9774_(pX, pY, pZ, f, f1);
            } else {
                serverPlayer.m_8999_(pLevel, pX, pY, pZ, f, f1);
            }
            pEntity.m_5616_(f);
        } else {
            float f2 = Mth.m_14036_((float)f1, (float)-90.0f, (float)90.0f);
            if (pLevel == pEntity.m_9236_()) {
                pEntity.m_7678_(pX, pY, pZ, f, f2);
                pEntity.m_5616_(f);
            } else {
                pEntity.m_19877_();
                Entity entity = pEntity;
                pEntity = pEntity.m_6095_().m_20615_((Level)pLevel);
                if (pEntity == null) {
                    return false;
                }
                pEntity.m_20361_(entity);
                pEntity.m_7678_(pX, pY, pZ, f, f2);
                pEntity.m_5616_(f);
                entity.m_142467_(Entity.RemovalReason.CHANGED_DIMENSION);
                pLevel.m_143334_(pEntity);
            }
        }
        if (!(pEntity instanceof LivingEntity) || !((LivingEntity)pEntity).m_21255_()) {
            pEntity.m_20256_(pEntity.m_20184_().m_82542_(1.0, 0.0, 1.0));
            pEntity.m_6853_(true);
        }
        if (pEntity instanceof PathfinderMob) {
            ((PathfinderMob)pEntity).m_21573_().m_26573_();
        }
        return true;
    }

    public static boolean shouldStopItem(Level level, Player player, BlockPos blockPos, ItemStack itemInHand) {
        if (level.m_220362_() == TRDimensionTypes.TARDIS && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            TardisLevelOperator data = TardisLevelOperator.get(serverLevel).get();
            Item consoleItem = TRBlockRegistry.GLOBAL_CONSOLE_BLOCK.get().m_5456_();
            Item consoleConfigItem = TRBlockRegistry.CONSOLE_CONFIGURATION_BLOCK.get().m_5456_();
            if (data.getInteriorManager().isCave() && (itemInHand.m_41720_() == consoleConfigItem || itemInHand.m_41720_() == consoleItem)) {
                return true;
            }
            for (ProtectedZone protectedZone : data.getInteriorManager().unbreakableZones()) {
                boolean shouldCancel;
                boolean bl = shouldCancel = !protectedZone.isAllowPlacement() && MiscHelper.isBlockPosInBox(blockPos, protectedZone.getArea());
                if (!shouldCancel) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean shouldCancelBreaking(Level world, Entity entity, BlockPos pos, BlockState state) {
        if (world.m_220362_() == TRDimensionTypes.TARDIS && world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            TardisLevelOperator data = TardisLevelOperator.get(serverLevel).get();
            for (ProtectedZone protectedZone : data.getInteriorManager().unbreakableZones()) {
                boolean shouldCancel;
                boolean bl = shouldCancel = !protectedZone.isAllowBreaking() && MiscHelper.isBlockPosInBox(pos, protectedZone.getArea());
                if (!shouldCancel) continue;
                return true;
            }
        }
        return state.m_60734_() instanceof GlobalConsoleBlock && world.m_220362_() == TRDimensionTypes.TARDIS || state.m_60734_() instanceof ShellBaseBlock || state.m_60734_() instanceof EyeBlock;
    }

    public static String getCleanDimensionName(ResourceKey<Level> dimensionKey) {
        return MiscHelper.getCleanName(dimensionKey.m_135782_().m_135815_());
    }

    public static String getCleanName(String name) {
        String noUnderscores = name.replace("_", " ");
        return WordUtils.capitalizeFully((String)noUnderscores);
    }

    public static DamageSource getDamageSource(ServerLevel level, ResourceKey<DamageType> damageTypeResourceKey) {
        Holder.Reference damageType = level.m_9598_().m_175515_(Registries.f_268580_).m_246971_(damageTypeResourceKey);
        DamageSource source = new DamageSource((Holder)damageType);
        return source;
    }

    public static <T> ArrayList<T> unionList(List<T> setOne, List<T> setTwo) {
        if (setOne != null) {
            if (setTwo != null) {
                ArrayList<T> finalSet = new ArrayList<T>();
                finalSet.addAll(setOne);
                finalSet.addAll(setTwo);
                return finalSet;
            }
            throw new NullPointerException("set2");
        }
        throw new NullPointerException("set1");
    }
}

