/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.world.chunk;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.FixedBiomeSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import whocraft.tardis_refined.common.tardis.TardisArchitectureHandler;
import whocraft.tardis_refined.common.world.ChunkGenerators;
import whocraft.tardis_refined.common.world.chunk.ARSStructurePiece;
import whocraft.tardis_refined.compat.ModCompatChecker;
import whocraft.tardis_refined.compat.valkyrienskies.VSHelper;
import whocraft.tardis_refined.constants.TardisDimensionConstants;
import whocraft.tardis_refined.registry.TRARSStructurePieceRegistry;
import whocraft.tardis_refined.registry.TRBlockRegistry;

public class TardisChunkGenerator
extends ChunkGenerator {
    public static final Codec<TardisChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryOps.m_254866_(ChunkGenerators.TARDIS_BIOME)).apply((Applicative)instance, instance.stable(TardisChunkGenerator::new)));
    public final RandomSource random;
    public final int distanceBetweenGravityWell = 18;
    public final int arsChunkSize = ARSStructurePiece.LOCKED_PIECE_CHUNK_SIZE;
    private final int chunkSize = 16;

    public TardisChunkGenerator(Holder<Biome> holder) {
        super((BiomeSource)new FixedBiomeSource(holder));
        this.random = RandomSource.m_216327_();
    }

    public void m_213609_(WorldGenLevel pLevel, ChunkAccess pChunk, StructureManager pStructureManager) {
        if (pChunk.m_7697_().f_45578_ == 63 && pChunk.m_7697_().f_45579_ == 2) {
            pLevel.m_6018_().m_215082_().m_230407_(new ResourceLocation("tardis_refined", "rooms/eye_of_harmony_part_a")).ifPresent(structure -> {
                BlockPos offsetPosition = new BlockPos((Vec3i)TardisArchitectureHandler.EYE_OF_HARMONY_PLACEMENT);
                structure.m_230328_((ServerLevelAccessor)pLevel, offsetPosition, offsetPosition, new StructurePlaceSettings(), pLevel.m_213780_(), 4);
            });
        }
        if (pChunk.m_7697_().f_45578_ == 63 && pChunk.m_7697_().f_45579_ == 4) {
            pLevel.m_6018_().m_215082_().m_230407_(new ResourceLocation("tardis_refined", "rooms/eye_of_harmony_part_b")).ifPresent(structure -> {
                BlockPos offsetPosition = new BlockPos((Vec3i)TardisArchitectureHandler.EYE_OF_HARMONY_PLACEMENT).m_7918_(0, 0, 24);
                structure.m_230328_((ServerLevelAccessor)pLevel, offsetPosition, offsetPosition, new StructurePlaceSettings(), pLevel.m_213780_(), 4);
            });
        }
        if (pChunk.m_7697_().f_45578_ == 63 && pChunk.m_7697_().f_45579_ == 0) {
            pLevel.m_6018_().m_215082_().m_230407_(new ResourceLocation("tardis_refined", "corridors/corridor_hub/corridor_hub_center")).ifPresent(structure -> {
                int height = 76;
                BlockPos pos = pChunk.m_7697_().m_151384_(0, height, 0).m_122013_(16).m_122025_(16);
                StructurePlaceSettings settings = new StructurePlaceSettings();
                structure.m_230328_((ServerLevelAccessor)pLevel, pos, pos, settings, pLevel.m_213780_(), 1);
            });
            ResourceLocation pieceToPlace = this.getRandomCorridorPiece().getResourceLocation();
            this.placePieceInWorld(pLevel, pieceToPlace, pChunk, true);
            return;
        }
        if (pChunk.m_7697_().f_45578_ == 63 && pChunk.m_7697_().f_45579_ == 3) {
            this.placePieceInWorld(pLevel, new ResourceLocation("tardis_refined", "corridors/corridor_hub/corridor_hub_south"), pChunk, false);
            ResourceLocation pieceToPlace = this.getRandomCorridorPiece().getResourceLocation();
            this.placePieceInWorld(pLevel, pieceToPlace, pChunk, true);
            return;
        }
        if (pChunk.m_7697_().f_45578_ == 66 && pChunk.m_7697_().f_45579_ == 3) {
            this.placePieceInWorld(pLevel, new ResourceLocation("tardis_refined", "corridors/corridor_hub/corridor_hub_south_east"), pChunk, false);
            ResourceLocation pieceToPlace = this.getRandomCorridorPiece().getResourceLocation();
            this.placePieceInWorld(pLevel, pieceToPlace, pChunk, true);
            return;
        }
        if (pChunk.m_7697_().f_45578_ == 66 && pChunk.m_7697_().f_45579_ == 0) {
            this.placePieceInWorld(pLevel, new ResourceLocation("tardis_refined", "corridors/corridor_hub/corridor_hub_east"), pChunk, false);
            ResourceLocation pieceToPlace = this.getRandomCorridorPiece().getResourceLocation();
            this.placePieceInWorld(pLevel, pieceToPlace, pChunk, true);
            return;
        }
        if (pChunk.m_7697_().f_45578_ == 66 && pChunk.m_7697_().f_45579_ == -3) {
            this.placePieceInWorld(pLevel, new ResourceLocation("tardis_refined", "corridors/corridor_hub/corridor_hub_north_east"), pChunk, false);
            ResourceLocation pieceToPlace = this.getRandomCorridorPiece().getResourceLocation();
            this.placePieceInWorld(pLevel, pieceToPlace, pChunk, true);
            return;
        }
        if (pChunk.m_7697_().f_45578_ == 63 && pChunk.m_7697_().f_45579_ == -3) {
            this.placePieceInWorld(pLevel, new ResourceLocation("tardis_refined", "corridors/corridor_hub/corridor_hub_north"), pChunk, false);
            ResourceLocation pieceToPlace = this.getRandomCorridorPiece().getResourceLocation();
            this.placePieceInWorld(pLevel, pieceToPlace, pChunk, true);
            return;
        }
        if (pChunk.m_7697_().f_45578_ == 60 && pChunk.m_7697_().f_45579_ == 0) {
            this.placePieceInWorld(pLevel, new ResourceLocation("tardis_refined", "corridors/corridor_hub/corridor_hub_west"), pChunk, false);
            ResourceLocation pieceToPlace = this.getRandomCorridorPiece().getResourceLocation();
            this.placePieceInWorld(pLevel, pieceToPlace, pChunk, true);
            return;
        }
        if (pChunk.m_7697_().f_45578_ > -25 && pChunk.m_7697_().f_45578_ < 25 && pChunk.m_7697_().f_45579_ > -25 && pChunk.m_7697_().f_45579_ < 25) {
            return;
        }
        if (ModCompatChecker.valkyrienSkies() && VSHelper.isChunkInShipyard(pChunk.m_7697_())) {
            return;
        }
        if (pChunk.m_7697_().f_45578_ % this.arsChunkSize == 0 && pChunk.m_7697_().f_45579_ % this.arsChunkSize == 0) {
            if (this.isChunkAtGravityInterval(pChunk.m_7697_())) {
                ResourceLocation pieceToPlace = new ResourceLocation("tardis_refined", "corridors/corridor_connection_bottom");
                this.placePieceInWorld(pLevel, pieceToPlace, pChunk, false);
                pieceToPlace = new ResourceLocation("tardis_refined", "corridors/corridor_connection_top");
                this.placePieceInWorld(pLevel, pieceToPlace, pChunk, true);
            } else {
                ResourceLocation pieceToPlace;
                if (this.random.m_188503_(3) == 0) {
                    pieceToPlace = this.getRandomRoomPiece().getResourceLocation();
                    this.placePieceInWorld(pLevel, pieceToPlace, pChunk, false);
                } else {
                    pieceToPlace = this.getRandomRoomPiece().getResourceLocation();
                    this.placePieceInWorld(pLevel, pieceToPlace, pChunk, false);
                }
                if (this.random.m_188503_(3) == 0) {
                    pieceToPlace = this.getRandomRoomPiece().getResourceLocation();
                    this.placePieceInWorld(pLevel, pieceToPlace, pChunk, true);
                } else {
                    pieceToPlace = this.getRandomRoomPiece().getResourceLocation();
                    this.placePieceInWorld(pLevel, pieceToPlace, pChunk, true);
                }
            }
        }
    }

    public void m_255037_(RegistryAccess registryAccess, ChunkGeneratorStructureState chunkGeneratorStructureState, StructureManager structureManager, ChunkAccess chunkAccess, StructureTemplateManager structureTemplateManager) {
    }

    public void m_223076_(WorldGenLevel pLevel, StructureManager pStructureManager, ChunkAccess pChunk) {
    }

    public Codec<TardisChunkGenerator> m_6909_() {
        return CODEC;
    }

    public void m_213679_(WorldGenRegion p_223043_, long p_223044_, RandomState p_223045_, BiomeManager p_223046_, StructureManager p_223047_, ChunkAccess p_223048_, GenerationStep.Carving p_223049_) {
    }

    public void m_214194_(WorldGenRegion level, StructureManager structureManager, RandomState random, ChunkAccess chunk) {
    }

    public void m_6929_(WorldGenRegion p_62167_) {
    }

    public int m_6331_() {
        return 384;
    }

    public CompletableFuture<ChunkAccess> m_213974_(Executor executor, Blender blender, RandomState randomState, StructureManager structureManager, ChunkAccess access) {
        if (ModCompatChecker.valkyrienSkies() && VSHelper.isChunkInShipyard(access.m_7697_())) {
            return CompletableFuture.completedFuture(access);
        }
        BlockPos cornerPos = new BlockPos(access.m_7697_().m_45604_(), TardisDimensionConstants.TARDIS_ROOT_GENERATION_MIN_HEIGHT - 5, access.m_7697_().m_45605_());
        BlockPos lastCornerPos = new BlockPos(access.m_7697_().m_45608_(), TardisDimensionConstants.TARDIS_ROOT_GENERATION_MAX_HEIGHT + 5, access.m_7697_().m_45609_());
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)cornerPos, (BlockPos)lastCornerPos)) {
            if (pos.m_123342_() <= TardisDimensionConstants.TARDIS_ROOT_GENERATION_MIN_HEIGHT || pos.m_123342_() > TardisDimensionConstants.TARDIS_ROOT_GENERATION_MAX_HEIGHT) {
                access.m_6978_(pos, Blocks.f_50752_.m_49966_(), false);
                continue;
            }
            access.m_6978_(pos, TRBlockRegistry.FOOLS_STONE.get().m_49966_(), false);
        }
        return CompletableFuture.completedFuture(access);
    }

    public int m_6337_() {
        return -63;
    }

    public int m_142062_() {
        return 0;
    }

    public int m_214096_(int p_223032_, int p_223033_, Heightmap.Types p_223034_, LevelHeightAccessor p_223035_, RandomState p_223036_) {
        return 0;
    }

    public NoiseColumn m_214184_(int p_223028_, int p_223029_, LevelHeightAccessor level, RandomState p_223031_) {
        BlockState[] states = new BlockState[level.m_141928_()];
        for (int i = 0; i < states.length; ++i) {
            states[i] = Blocks.f_50069_.m_49966_();
        }
        return new NoiseColumn(0, states);
    }

    private boolean isChunkAtGravityInterval(ChunkPos pos) {
        return pos.f_45578_ % 18 == 0 && pos.f_45579_ % 18 == 0;
    }

    private ARSStructurePiece getRandomCorridorPiece() {
        return TRARSStructurePieceRegistry.CORRIDORS.get(this.random.m_188503_(TRARSStructurePieceRegistry.CORRIDORS.size()));
    }

    private ARSStructurePiece getRandomRoomPiece() {
        return TRARSStructurePieceRegistry.ROOMS.get(this.random.m_188503_(TRARSStructurePieceRegistry.ROOMS.size()));
    }

    private void placePieceInWorld(WorldGenLevel level, ResourceLocation pieceToPlace, ChunkAccess pChunk, boolean isSecondFloor) {
        level.m_6018_().m_215082_().m_230407_(pieceToPlace).ifPresent(structure -> {
            int height = isSecondFloor ? 125 : 97;
            BlockPos pos = pChunk.m_7697_().m_151384_(0, height, 0).m_122013_(16).m_122025_(16);
            StructurePlaceSettings settings = new StructurePlaceSettings();
            structure.m_230328_((ServerLevelAccessor)level, pos, pos, settings, level.m_213780_(), 0);
        });
    }

    public void m_213600_(List<String> p_223175_, RandomState p_223176_, BlockPos p_223177_) {
    }
}

