/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.compat.create;

import com.simibubi.create.api.behaviour.display.DisplaySource;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkContext;
import com.simibubi.create.content.redstone.displayLink.target.DisplayTargetStats;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import whocraft.tardis_refined.common.blockentity.device.FlightDetectorBlockEntity;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;
import whocraft.tardis_refined.common.tardis.TardisNavLocation;
import whocraft.tardis_refined.common.util.MiscHelper;
import whocraft.tardis_refined.compat.ModCompatChecker;
import whocraft.tardis_refined.compat.valkyrienskies.VSHelper;
import whocraft.tardis_refined.constants.ModMessages;

public class TardisDisplaySource
extends DisplaySource {
    public List<MutableComponent> provideText(DisplayLinkContext context, DisplayTargetStats stats) {
        FlightDetectorBlockEntity flightDetectorBlockEntity;
        Level level;
        BlockEntity blockEntity = context.getSourceBlockEntity();
        ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
        if (blockEntity instanceof FlightDetectorBlockEntity && (level = (flightDetectorBlockEntity = (FlightDetectorBlockEntity)blockEntity).m_58904_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            boolean isPresent = TardisLevelOperator.get(serverLevel).isPresent();
            if (isPresent) {
                TardisLevelOperator levelOperator = TardisLevelOperator.get(serverLevel).get();
                TardisNavLocation currentLoc = levelOperator.getPilotingManager().getCurrentLocation();
                if (ModCompatChecker.valkyrienSkies()) {
                    currentLoc = VSHelper.toWorldLocation(currentLoc);
                }
                list.add(Component.m_237110_((String)ModMessages.IN_FLIGHT, (Object[])new Object[]{levelOperator.getPilotingManager().isInFlight()}));
                list.add(Component.m_237110_((String)ModMessages.POSITION, (Object[])new Object[]{currentLoc.getPosition().m_123344_()}));
                list.add(Component.m_237110_((String)ModMessages.DIMENSION, (Object[])new Object[]{MiscHelper.getCleanDimensionName(currentLoc.getDimensionKey())}));
                list.add(Component.m_237115_((String)ModMessages.FUEL).m_130946_(String.valueOf(Math.round(levelOperator.getPilotingManager().getFuelPercentage() * 100.0f))).m_130946_("%"));
                list.add(Component.m_237110_((String)ModMessages.SHELL, (Object[])new Object[]{levelOperator.getAestheticHandler().getShellTheme().m_135815_()}));
                list.add(Component.m_237115_((String)ModMessages.JOURNEY_PROGRESS).m_130946_(levelOperator.getPilotingManager().getFlightPercentageCovered() * 100.0f + "%"));
            }
            return list;
        }
        return List.of();
    }

    public int getPassiveRefreshTicks() {
        return 10;
    }
}

