/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.forge;

import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import whocraft.tardis_refined.TRConfig;
import whocraft.tardis_refined.TardisRefined;
import whocraft.tardis_refined.common.crafting.astral_manipulator.ManipulatorRecipes;
import whocraft.tardis_refined.common.data.ConsolePatternProvider;
import whocraft.tardis_refined.common.data.DesktopProvider;
import whocraft.tardis_refined.common.data.HumProvider;
import whocraft.tardis_refined.common.data.ItemModelProvider;
import whocraft.tardis_refined.common.data.ItemTagProvider;
import whocraft.tardis_refined.common.data.LangProviderEnglish;
import whocraft.tardis_refined.common.data.ManipulatorRecipeProvider;
import whocraft.tardis_refined.common.data.ParticleProvider;
import whocraft.tardis_refined.common.data.ProviderBlockTags;
import whocraft.tardis_refined.common.data.ProviderEntityTags;
import whocraft.tardis_refined.common.data.ProviderLootTable;
import whocraft.tardis_refined.common.data.RecipeProvider;
import whocraft.tardis_refined.common.data.ShellPatternProvider;
import whocraft.tardis_refined.common.data.SoundProvider;
import whocraft.tardis_refined.common.data.TRBiomeTagsProvider;
import whocraft.tardis_refined.common.data.TRBlockModelProvider;
import whocraft.tardis_refined.common.data.TRPoiTypeTagsProvider;
import whocraft.tardis_refined.common.data.WorldGenProvider;
import whocraft.tardis_refined.common.util.Platform;
import whocraft.tardis_refined.compat.ModCompatChecker;
import whocraft.tardis_refined.compat.create.CreateIntergrationsForge;
import whocraft.tardis_refined.compat.portals.ImmersivePortals;
import whocraft.tardis_refined.compat.portals.neoforge.PortalsCompatForge;
import whocraft.tardis_refined.compat.trinkets.CuriosUtil;

@Mod(value="tardis_refined")
public class TardisRefinedForge {
    public TardisRefinedForge() {
        TardisRefined.init();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::onGatherData);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)TRConfig.COMMON_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)TRConfig.CLIENT_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)TRConfig.SERVER_SPEC);
        if (Platform.isModLoaded("curios")) {
            CuriosUtil.init();
        }
        if (ModCompatChecker.immersivePortals()) {
            if (((Boolean)TRConfig.COMMON.COMPATIBILITY_IP.get()).booleanValue()) {
                ImmersivePortals.init();
                PortalsCompatForge.init();
            }
        } else {
            TardisRefined.LOGGER.info("ImmersivePortals was not detected.");
        }
        if (ModCompatChecker.create()) {
            CreateIntergrationsForge.init();
        }
    }

    public void onGatherData(GatherDataEvent e) {
        DataGenerator generator = e.getGenerator();
        ExistingFileHelper existingFileHelper = e.getExistingFileHelper();
        ManipulatorRecipes.registerRecipes();
        generator.addProvider(e.includeClient(), (DataProvider)new LangProviderEnglish(generator));
        generator.addProvider(e.includeClient(), (DataProvider)new ItemModelProvider(generator, existingFileHelper));
        generator.addProvider(e.includeClient(), (DataProvider)new TRBlockModelProvider(generator, existingFileHelper));
        generator.addProvider(e.includeClient(), (DataProvider)new SoundProvider(generator, existingFileHelper));
        generator.addProvider(e.includeClient(), (DataProvider)new ParticleProvider(generator));
        ProviderBlockTags blocks = (ProviderBlockTags)generator.addProvider(e.includeServer(), (DataProvider)new ProviderBlockTags(generator.getPackOutput(), e.getLookupProvider(), e.getExistingFileHelper()));
        generator.addProvider(e.includeServer(), (DataProvider)new ItemTagProvider(generator.getPackOutput(), e.getLookupProvider(), blocks.m_274426_(), existingFileHelper));
        generator.addProvider(e.includeServer(), (DataProvider)new WorldGenProvider(generator.getPackOutput(), e.getLookupProvider()));
        generator.addProvider(e.includeServer(), (DataProvider)new ProviderLootTable(generator.getPackOutput()));
        generator.addProvider(e.includeServer(), (DataProvider)new RecipeProvider(generator.getPackOutput()));
        generator.addProvider(e.includeServer(), (DataProvider)new ConsolePatternProvider(generator));
        generator.addProvider(e.includeServer(), (DataProvider)new DesktopProvider(generator));
        generator.addProvider(e.includeServer(), (DataProvider)new HumProvider(generator));
        generator.addProvider(e.includeServer(), (DataProvider)new ShellPatternProvider(generator, "tardis_refined"));
        generator.addProvider(e.includeServer(), (DataProvider)new ManipulatorRecipeProvider(generator, "tardis_refined"));
        generator.addProvider(e.includeServer(), (DataProvider)new TRBiomeTagsProvider(generator.getPackOutput(), e.getLookupProvider(), e.getExistingFileHelper()));
        generator.addProvider(e.includeServer(), (DataProvider)new ProviderEntityTags(generator.getPackOutput(), e.getLookupProvider(), e.getExistingFileHelper()));
        generator.addProvider(e.includeServer(), (DataProvider)new TRPoiTypeTagsProvider(generator.getPackOutput(), e.getLookupProvider(), e.getExistingFileHelper()));
    }
}

