/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.patterns;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import whocraft.tardis_refined.common.tardis.themes.ConsoleTheme;
import whocraft.tardis_refined.common.util.Platform;
import whocraft.tardis_refined.constants.ResourceConstants;
import whocraft.tardis_refined.patterns.ConsolePattern;
import whocraft.tardis_refined.patterns.ConsolePatternCollection;
import whocraft.tardis_refined.patterns.PatternReloadListener;
import whocraft.tardis_refined.patterns.PatternTexture;
import whocraft.tardis_refined.patterns.sound.ConsoleSoundProfile;
import whocraft.tardis_refined.patterns.sound.TRConsoleSoundProfiles;

public class ConsolePatterns {
    public static final ConsolePattern DEFAULT = (ConsolePattern)new ConsolePattern(ResourceConstants.DEFAULT_PATTERN_ID, new PatternTexture(ConsolePatterns.createConsolePatternTextureLocation(ConsoleTheme.FACTORY.getId(), ConsoleTheme.FACTORY.getId().m_135815_() + "_console"), true), Optional.of(TRConsoleSoundProfiles.DEFAULT_SOUND_PROFILE)).setThemeId(ConsoleTheme.FACTORY.getId());
    private static final PatternReloadListener<ConsolePatternCollection, ConsolePattern> PATTERNS = PatternReloadListener.createListener("tardis_refined/patterns/console", ConsolePatternCollection.CODEC, patternCollections -> PatternReloadListener.processPatternCollections(patternCollections));
    private static final Map<ResourceLocation, List<ConsolePattern>> DEFAULT_PATTERNS = new HashMap<ResourceLocation, List<ConsolePattern>>();
    public static Logger LOGGER = LogManager.getLogger((String)"TardisRefined/ConsolePatterns");

    public static PatternReloadListener<ConsolePatternCollection, ConsolePattern> getReloadListener() {
        return PATTERNS;
    }

    public static Map<ResourceLocation, List<ConsolePattern>> getRegistry() {
        return PATTERNS.getData();
    }

    public static List<ConsolePattern> getPatternsForTheme(ResourceLocation consoleThemeId) {
        return (List)PATTERNS.getData().get(consoleThemeId);
    }

    public static List<ConsolePattern> getPatternsForThemeDefault(ResourceLocation consoleThemeId) {
        return DEFAULT_PATTERNS.get(consoleThemeId);
    }

    public static List<ConsolePattern> getPatternCollectionForTheme(ResourceLocation consoleThemeId) {
        return (List)PATTERNS.getData().get(consoleThemeId);
    }

    public static ConsoleTheme getThemeForPattern(ConsolePattern pattern) {
        Map<ResourceLocation, List<ConsolePattern>> entries = ConsolePatterns.getRegistry();
        for (Map.Entry<ResourceLocation, List<ConsolePattern>> entry : entries.entrySet()) {
            if (pattern.getThemeId() != entry.getKey()) continue;
            return ConsoleTheme.CONSOLE_THEME_DEFERRED_REGISTRY.get(entry.getKey());
        }
        return ConsoleTheme.FACTORY.get();
    }

    public static boolean doesPatternExist(ResourceLocation consoleThemeId, ResourceLocation patternId) {
        List<ConsolePattern> consolePatterns = ConsolePatterns.getPatternsForTheme(consoleThemeId);
        for (ConsolePattern consolePattern : consolePatterns) {
            if (!Objects.equals(consolePattern.id(), patternId)) continue;
            return true;
        }
        return false;
    }

    public static ConsolePattern getPatternOrDefault(ResourceLocation consoleThemeId, ResourceLocation id) {
        List<ConsolePattern> consolePatterns = ConsolePatterns.getPatternsForTheme(consoleThemeId);
        for (ConsolePattern consolePattern : consolePatterns) {
            if (!Objects.equals(consolePattern.id(), id)) continue;
            return consolePattern;
        }
        return consolePatterns.get(0);
    }

    public static ConsolePattern next(ResourceLocation consoleThemeId, ConsolePattern currentPattern) {
        List<ConsolePattern> collection = ConsolePatterns.getPatternCollectionForTheme(consoleThemeId);
        return ConsolePatterns.next(collection, currentPattern);
    }

    public static ConsolePattern next(List<ConsolePattern> patterns, ConsolePattern currentPattern) {
        if (currentPattern == null) {
            return patterns.get(0);
        }
        int prevIndex = patterns.indexOf(currentPattern);
        if (prevIndex > patterns.size() || prevIndex + 1 >= patterns.size()) {
            return patterns.get(0);
        }
        return patterns.get(prevIndex + 1);
    }

    private static void addDefaultPattern(ResourceLocation themeId, String patternId, String textureName, boolean hasEmissiveTexture) {
        ConsolePatterns.addDefaultPattern(themeId, patternId, textureName, hasEmissiveTexture, Optional.of(TRConsoleSoundProfiles.DEFAULT_SOUND_PROFILE));
    }

    private static void addDefaultPattern(ResourceLocation themeId, String patternId, String textureName, boolean hasEmissiveTexture, Optional<ConsoleSoundProfile> soundProfile) {
        ConsolePattern pattern = (ConsolePattern)new ConsolePattern(patternId, new PatternTexture(ConsolePatterns.createConsolePatternTextureLocation(themeId, textureName), hasEmissiveTexture), soundProfile).setThemeId(themeId);
        if (DEFAULT_PATTERNS.containsKey(themeId)) {
            List<ConsolePattern> consolePatternList = DEFAULT_PATTERNS.get(themeId);
            ArrayList<ConsolePattern> currentList = new ArrayList<ConsolePattern>(consolePatternList);
            currentList.add(pattern);
            DEFAULT_PATTERNS.replace(themeId, currentList);
        } else {
            List<ConsolePattern> consolePatternList = List.of(pattern);
            DEFAULT_PATTERNS.put(themeId, consolePatternList);
        }
        if (!Platform.isProduction()) {
            LOGGER.info("Adding ConsolePattern {} for {}", (Object)pattern.id(), (Object)themeId);
        }
    }

    private static ResourceLocation createConsolePatternTextureLocation(ResourceLocation themeId, String textureName) {
        return new ResourceLocation("tardis_refined", "textures/blockentity/console/" + themeId.m_135815_().toLowerCase(Locale.ENGLISH) + "/" + textureName + ".png");
    }

    public static Map<ResourceLocation, List<ConsolePattern>> getDefaultPatterns() {
        return DEFAULT_PATTERNS;
    }

    public static Map<ResourceLocation, ConsolePatternCollection> getDefaultPatternsDatagen() {
        HashMap<ResourceLocation, ConsolePatternCollection> defaults = new HashMap<ResourceLocation, ConsolePatternCollection>();
        DEFAULT_PATTERNS.forEach((key, value) -> defaults.put((ResourceLocation)key, (ConsolePatternCollection)new ConsolePatternCollection((List<ConsolePattern>)value).setThemeId((ResourceLocation)key)));
        return defaults;
    }

    public static Map<ResourceLocation, List<ConsolePattern>> registerDefaultPatterns() {
        DEFAULT_PATTERNS.clear();
        for (ResourceLocation consoleTheme : ConsoleTheme.CONSOLE_THEME_DEFERRED_REGISTRY.keySet()) {
            boolean hasDefaultEmission = consoleTheme == ConsoleTheme.VICTORIAN.getId() || consoleTheme == ConsoleTheme.COPPER.getId() || consoleTheme == ConsoleTheme.CRYSTAL.getId() || consoleTheme == ConsoleTheme.CORAL.getId() || consoleTheme == ConsoleTheme.FACTORY.getId() || consoleTheme == ConsoleTheme.INITIATIVE.getId() || consoleTheme == ConsoleTheme.TOYOTA.getId();
            ConsolePatterns.addDefaultPattern(consoleTheme, ResourceConstants.DEFAULT_PATTERN_ID.m_135815_(), consoleTheme.m_135815_() + "_console", hasDefaultEmission);
        }
        ConsolePatterns.addDefaultPattern(ConsoleTheme.CORAL.getId(), "war", "coral_console_war", true);
        ConsolePatterns.addDefaultPattern(ConsoleTheme.CORAL.getId(), "blue", "coral_console_blue", true);
        ConsolePatterns.addDefaultPattern(ConsoleTheme.FACTORY.getId(), "vintage", "factory_console_vintage", true);
        ConsolePatterns.addDefaultPattern(ConsoleTheme.FACTORY.getId(), "mint", "factory_console_mint", true);
        ConsolePatterns.addDefaultPattern(ConsoleTheme.FACTORY.getId(), "wood", "factory_console_wood", true);
        ConsolePatterns.addDefaultPattern(ConsoleTheme.TOYOTA.getId(), "violet", "toyota_console_purple", true);
        ConsolePatterns.addDefaultPattern(ConsoleTheme.TOYOTA.getId(), "blue", "toyota_console_blue", true);
        ConsolePatterns.addDefaultPattern(ConsoleTheme.TOYOTA.getId(), "skulk", "toyota_console_skulk", false);
        ConsolePatterns.addDefaultPattern(ConsoleTheme.CRYSTAL.getId(), "corrupted", "crystal_console_corrupted", true);
        ConsolePatterns.addDefaultPattern(ConsoleTheme.MYST.getId(), "molten", "myst_console_molten", false);
        ConsolePatterns.addDefaultPattern(ConsoleTheme.VICTORIAN.getId(), "bronze_age", "victorian_console_bronze_age", true);
        ConsolePatterns.addDefaultPattern(ConsoleTheme.INITIATIVE.getId(), "aperture", "initiative_console_aperture", true);
        ConsolePatterns.addDefaultPattern(ConsoleTheme.INITIATIVE.getId(), "blue", "initiative_console_blue", true);
        ConsolePatterns.addDefaultPattern(ConsoleTheme.INITIATIVE.getId(), "construction", "initiative_console_construction", false);
        ConsolePatterns.addDefaultPattern(ConsoleTheme.NUKA.getId(), "industrial", "nuka_industrial", false);
        ConsolePatterns.addDefaultPattern(ConsoleTheme.NUKA.getId(), "cool", "nuka_cool", false);
        ConsolePatterns.addDefaultPattern(ConsoleTheme.COPPER.getId(), "sculk", "copper_console_sculk", false);
        return new HashMap<ResourceLocation, List<ConsolePattern>>(DEFAULT_PATTERNS);
    }
}

