/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.patterns;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import whocraft.tardis_refined.TardisRefined;
import whocraft.tardis_refined.common.util.MergeableCodecJsonReloadListener;
import whocraft.tardis_refined.common.util.MiscHelper;
import whocraft.tardis_refined.patterns.BasePattern;
import whocraft.tardis_refined.patterns.PatternCollection;
import whocraft.tardis_refined.patterns.forge.PatternReloadListenerImpl;

public class PatternReloadListener<T extends PatternCollection, B extends BasePattern>
extends MergeableCodecJsonReloadListener<T, List<B>> {
    protected PatternReloadListener(String folderName, Codec<T> codec, Function<List<T>, List<B>> merger) {
        super(folderName, codec, merger);
    }

    public static <B extends BasePattern, C extends PatternCollection> ArrayList<B> processPatternCollections(List<C> patternCollections) {
        return patternCollections.stream().reduce(new ArrayList(), PatternReloadListener::mergeOrReplacePatterns, MiscHelper::unionList);
    }

    public static <B extends BasePattern, C extends PatternCollection> ArrayList<B> mergeOrReplacePatterns(ArrayList<B> set, C nextPatternCollection) {
        return PatternReloadListener.addPatterns(nextPatternCollection.isReplace() ? new ArrayList() : set, nextPatternCollection.patterns());
    }

    public static <B extends BasePattern> ArrayList<B> addPatterns(List<B> finalPatterns, List<B> patterns) {
        ArrayList<B> finalPatternsModified = MiscHelper.unionList(finalPatterns, patterns);
        return finalPatternsModified;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <P extends PatternCollection, B extends BasePattern> PatternReloadListener<P, B> createListener(String folderName, Codec<P> codec, Function<List<P>, List<B>> merger) {
        void var2_2;
        void var1_1;
        return PatternReloadListenerImpl.createListener(folderName, var1_1, var2_2);
    }

    @Override
    protected Map<ResourceLocation, List<B>> mapValues(Map<ResourceLocation, List<Resource>> inputs) {
        HashMap<ResourceLocation, List<B>> entries = new HashMap<ResourceLocation, List<B>>();
        for (Map.Entry<ResourceLocation, List<Resource>> entry : inputs.entrySet()) {
            ArrayList raws = new ArrayList();
            ResourceLocation fullId = entry.getKey();
            String fullPath = fullId.m_135815_();
            ResourceLocation key = new ResourceLocation(fullId.m_135827_(), fullPath.substring(this.folderName.length() + 1, fullPath.length() - this.EXTENSION_LENGTH));
            for (Resource resource : entry.getValue()) {
                try {
                    BufferedReader reader = resource.m_215508_();
                    try {
                        JsonElement element = JsonParser.parseReader((Reader)reader);
                        this.codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)element).get().ifLeft(result -> {
                            raws.add(((PatternCollection)result.getFirst()).setThemeId(key));
                            LOGGER.info("Adding Pattern {} for {}", (Object)fullId, (Object)key);
                        }).ifRight(partial -> TardisRefined.LOGGER.error("Error deserializing json {} in folder {} from pack {}: {}", (Object)key, (Object)this.folderName, (Object)resource.m_215506_(), (Object)partial.message()));
                    }
                    finally {
                        if (reader == null) continue;
                        ((Reader)reader).close();
                    }
                }
                catch (Exception e) {
                    LOGGER.error(String.format(Locale.ENGLISH, "Error reading resource %s in folder %s from pack %s: ", key, this.folderName, resource.m_215506_()), (Throwable)e);
                }
            }
            entries.put(key, (List)this.merger.apply(raws));
        }
        return entries;
    }
}

