/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.registry;

import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import whocraft.tardis_refined.common.block.RootPlantBlock;
import whocraft.tardis_refined.common.block.console.GlobalConsoleBlock;
import whocraft.tardis_refined.common.block.device.AirLockGenerationBlock;
import whocraft.tardis_refined.common.block.device.AntiGravityBlock;
import whocraft.tardis_refined.common.block.device.ArtronPillarBlock;
import whocraft.tardis_refined.common.block.device.AstralManipulatorBlock;
import whocraft.tardis_refined.common.block.device.ConsoleConfigurationBlock;
import whocraft.tardis_refined.common.block.device.CorridorTeleporterBlock;
import whocraft.tardis_refined.common.block.device.FlightDetectorBlock;
import whocraft.tardis_refined.common.block.device.LandingPadBlock;
import whocraft.tardis_refined.common.block.device.TerraformerBlock;
import whocraft.tardis_refined.common.block.door.BulkHeadDoorBlock;
import whocraft.tardis_refined.common.block.door.GlobalDoorBlock;
import whocraft.tardis_refined.common.block.door.RootShellDoorBlock;
import whocraft.tardis_refined.common.block.life.ARSLeavesBlock;
import whocraft.tardis_refined.common.block.life.ArsEggBlock;
import whocraft.tardis_refined.common.block.life.EyeBlock;
import whocraft.tardis_refined.common.block.life.GrowthStoneBlock;
import whocraft.tardis_refined.common.block.shell.GlobalShellBlock;
import whocraft.tardis_refined.common.block.shell.RootedShellBlock;
import whocraft.tardis_refined.common.block.shell.ShellBaseBlock;
import whocraft.tardis_refined.registry.DeferredRegistry;
import whocraft.tardis_refined.registry.RegistrySupplier;
import whocraft.tardis_refined.registry.TRItemRegistry;

public class TRBlockRegistry {
    public static final DeferredRegistry<Block> BLOCKS = DeferredRegistry.create("tardis_refined", Registries.f_256747_);
    public static final RegistrySupplier<ShellBaseBlock> ROOT_SHELL_BLOCK = TRBlockRegistry.register("root_shell", () -> new RootedShellBlock(BlockBehaviour.Properties.m_284310_().m_60955_().m_60913_(1000.0f, 1000.0f).m_60918_(SoundType.f_56753_)), true, true);
    public static final RegistrySupplier<ShellBaseBlock> GLOBAL_SHELL_BLOCK = TRBlockRegistry.register("tardis_shell", () -> new GlobalShellBlock(BlockBehaviour.Properties.m_284310_().m_60955_().m_60913_(1000.0f, 1000.0f).m_60918_(SoundType.f_56742_).m_60953_(blocksState -> (Boolean)blocksState.m_61143_((Property)GlobalShellBlock.LIT) != false ? 13 : 0)), false, false);
    public static final RegistrySupplier<GlobalDoorBlock> GLOBAL_DOOR_BLOCK = TRBlockRegistry.register("tardis_door", () -> new GlobalDoorBlock(BlockBehaviour.Properties.m_284310_().m_60955_().m_60913_(10.0f, 10.0f).m_60918_(SoundType.f_56742_)), true, true);
    public static final RegistrySupplier<RootShellDoorBlock> ROOT_SHELL_DOOR = TRBlockRegistry.register("root_shell_door", () -> new RootShellDoorBlock(BlockBehaviour.Properties.m_284310_().m_60955_().m_60913_(1000.0f, 1000.0f)), false, true);
    public static final RegistrySupplier<Block> FOOLS_STONE = TRBlockRegistry.register("fools_stone", () -> new GrowthStoneBlock(BlockBehaviour.Properties.m_284310_().m_60978_(3.0f)), true, true);
    public static final RegistrySupplier<RootPlantBlock> ROOT_PLANT_BLOCK = TRBlockRegistry.register("root_plant", () -> new RootPlantBlock(BlockBehaviour.Properties.m_284310_().m_60955_().m_60913_(3.0f, 3.0f).m_60918_(SoundType.f_56753_)), true, true);
    public static final RegistrySupplier<BulkHeadDoorBlock> BULK_HEAD_DOOR = TRBlockRegistry.register("bulk_head_door", () -> new BulkHeadDoorBlock(BlockBehaviour.Properties.m_284310_().m_60955_().m_60913_(3.0f, 3.0f).m_60918_(SoundType.f_56753_)), true, true);
    public static final RegistrySupplier<ArsEggBlock> ARS_EGG = TRBlockRegistry.register("ars_egg", () -> new ArsEggBlock(BlockBehaviour.Properties.m_284310_().m_60955_().m_60913_(3.0f, 3.0f).m_60918_(SoundType.f_154674_).m_60953_(x -> 12)), true, true);
    public static final RegistrySupplier<Block> ARS_LEAVES = TRBlockRegistry.register("ars_leaves", () -> new ARSLeavesBlock(BlockBehaviour.Properties.m_284310_().m_60955_().m_60913_(3.0f, 3.0f).m_60918_(SoundType.f_154674_)), false, true);
    public static final RegistrySupplier<SlabBlock> ARS_LEAVES_SLAB = TRBlockRegistry.register("ars_leaves_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_284310_().m_60955_().m_60913_(3.0f, 3.0f).m_60918_(SoundType.f_154674_)), false, true);
    public static final RegistrySupplier<FenceBlock> ARS_LEAVES_FENCE = TRBlockRegistry.register("ars_leaves_fence", () -> new FenceBlock(BlockBehaviour.Properties.m_284310_().m_60955_().m_60913_(3.0f, 3.0f).m_60918_(SoundType.f_154674_)), false, true);
    public static final RegistrySupplier<TerraformerBlock> TERRAFORMER_BLOCK = TRBlockRegistry.register("terraformer", () -> new TerraformerBlock(BlockBehaviour.Properties.m_284310_().m_60913_(3.0f, 3.0f).m_60918_(SoundType.f_56749_).m_60955_()), true, true);
    public static final RegistrySupplier<AirLockGenerationBlock> AIR_LOCK_GENERATION_BLOCK = TRBlockRegistry.register("air_lock_generator", () -> new AirLockGenerationBlock(BlockBehaviour.Properties.m_284310_().m_60913_(3.0f, 3.0f).m_60918_(SoundType.f_56749_).m_60955_()), false, true);
    public static final RegistrySupplier<ConsoleConfigurationBlock> CONSOLE_CONFIGURATION_BLOCK = TRBlockRegistry.register("console_configuration", () -> new ConsoleConfigurationBlock(BlockBehaviour.Properties.m_284310_().m_60913_(3.0f, 3.0f).m_60918_(SoundType.f_56749_).m_60955_()), true, true);
    public static final RegistrySupplier<AstralManipulatorBlock> ASTRAL_MANIPULATOR_BLOCK = TRBlockRegistry.register("astral_manipulator", () -> new AstralManipulatorBlock(BlockBehaviour.Properties.m_284310_().m_60913_(3.0f, 3.0f).m_60918_(SoundType.f_56749_).m_60955_().m_60953_(x -> (Boolean)x.m_61143_((Property)AstralManipulatorBlock.POWERED) != false ? 15 : 0)), true, true);
    public static final RegistrySupplier<AntiGravityBlock> GRAVITY_WELL = TRBlockRegistry.register("gravity_well", () -> new AntiGravityBlock(BlockBehaviour.Properties.m_284310_().m_60913_(3.0f, 3.0f).m_60918_(SoundType.f_56749_).m_60955_()), true, true);
    public static final RegistrySupplier<CorridorTeleporterBlock> CORRIDOR_TELEPORTER = TRBlockRegistry.register("corridor_teleporter", () -> new CorridorTeleporterBlock(BlockBehaviour.Properties.m_284310_().m_60913_(3.0f, 3.0f).m_60918_(SoundType.f_56749_).m_60955_()), true, true);
    public static final RegistrySupplier<LandingPadBlock> LANDING_PAD = TRBlockRegistry.register("landing_pad", () -> new LandingPadBlock(BlockBehaviour.Properties.m_284310_().m_60913_(3.0f, 3.0f).m_60918_(SoundType.f_56749_).m_60955_().m_60953_(x -> 12)), true, true);
    public static final RegistrySupplier<FlightDetectorBlock> FLIGHT_DETECTOR = TRBlockRegistry.register("flight_detector", () -> new FlightDetectorBlock(BlockBehaviour.Properties.m_284310_().m_60913_(3.0f, 3.0f).m_60918_(SoundType.f_56749_).m_60955_()), true, true);
    public static final RegistrySupplier<ArtronPillarBlock> ARTRON_PILLAR = TRBlockRegistry.register("artron_pillar", () -> new ArtronPillarBlock(BlockBehaviour.Properties.m_284310_().m_60913_(3.0f, 3.0f).m_60918_(SoundType.f_56749_).m_60955_()), false, false);
    public static final RegistrySupplier<GlobalConsoleBlock> GLOBAL_CONSOLE_BLOCK = TRBlockRegistry.register("tardis_console", () -> new GlobalConsoleBlock(BlockBehaviour.Properties.m_284310_().m_60913_(1000.0f, 1000.0f).m_60918_(SoundType.f_56749_).m_60955_().m_60953_(x -> (Boolean)x.m_61143_((Property)GlobalConsoleBlock.POWERED) != false ? 15 : 0)), true, true);
    public static final RegistrySupplier<Block> ZEITON_BLOCK = TRBlockRegistry.register("zeiton_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60918_(SoundType.f_56743_)), true, true);
    public static final RegistrySupplier<Block> ZEITON_FUSED_IRON_BLOCK = TRBlockRegistry.register("zeiton_fused_iron_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60918_(SoundType.f_56743_)), true, true);
    public static final RegistrySupplier<Block> ZEITON_FUSED_COPPER_BLOCK = TRBlockRegistry.register("zeiton_fused_copper_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152504_).m_60918_(SoundType.f_154663_)), true, true);
    public static final RegistrySupplier<Block> ZEITON_ORE = TRBlockRegistry.register("zeiton_ore", () -> new Block(BlockBehaviour.Properties.m_284310_().m_60999_().m_60913_(3.0f, 3.0f)), true, true);
    public static final RegistrySupplier<Block> ZEITON_ORE_DEEPSLATE = TRBlockRegistry.register("deepslate_zeiton_ore", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152467_).m_60999_()), true, true);
    public static final RegistrySupplier<Block> THE_EYE = TRBlockRegistry.register("the_eye", () -> new EyeBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50752_)), false, false);
    public static final RegistrySupplier<LanternBlock> ZEITON_LANTERN = TRBlockRegistry.register("zeiton_lantern", () -> new LanternBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50681_).m_60999_()), true, true);
    public static final RegistrySupplier<Block> ARTRON_PILLAR_PORT = TRBlockRegistry.register("artron_pillar_port", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50752_)), false, false);

    private static <T extends Block> RegistrySupplier<T> register(String id, Supplier<T> blockSupplier, boolean addToTab, boolean registerItem) {
        RegistrySupplier registryObject = BLOCKS.register(id, blockSupplier);
        if (registerItem) {
            RegistrySupplier<Item> itemSupplier = TRItemRegistry.ITEMS.register(id, () -> new BlockItem((Block)registryObject.get(), new Item.Properties()));
            if (addToTab) {
                TRItemRegistry.TAB_ITEMS.add(itemSupplier);
            }
        }
        return registryObject;
    }

    private static <T extends Block> RegistrySupplier<T> register(String id, Supplier<T> blockSupplier, boolean addToTab) {
        return TRBlockRegistry.register(id, blockSupplier, addToTab, true);
    }
}

