/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum.script.types;

import dev.obscuria.fragmentum.script.types.LuaLevel;
import dev.obscuria.fragmentum.script.types.LuaOps;
import dev.obscuria.fragmentum.script.types.LuaVec3;
import dev.obscuria.fragmentum.script.types.LuaWrapper;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;
import org.luaj.vm2.LuaValue;

public class LuaEntity<T extends Entity>
extends LuaWrapper<T> {
    public static final LuaOps<Entity> OPS = LuaOps.nonnil(LuaEntity::valueOf, LuaEntity::nonnilSourceOf);
    public static final LuaOps.Nilable<Entity> NIL_OPS = LuaOps.nilable(LuaEntity::valueOf, LuaEntity::nilableSourceOf);

    public LuaEntity(T entity) {
        super(entity, LuaOps.nonnil(LuaEntity::valueOf, LuaEntity::nonnilSourceOf));
    }

    public LuaEntity(T entity, LuaOps<T> ops) {
        super(entity, ops);
    }

    @Override
    protected void build(LuaWrapper.Builder builder) {
        builder.put("tickCount", LuaWrapper.Property.of(LuaOps.INT, LuaEntity::getTickCount, LuaEntity::setTickCount));
        builder.put("position", LuaWrapper.Property.of(LuaVec3.OPS, Entity::m_20182_, Entity::m_146884_));
        builder.put("level", LuaWrapper.Property.readOnly(LuaLevel.OPS, Entity::m_9236_));
        builder.put("canSeeSky", this.method0(LuaOps.BOOL, LuaEntity::canSeeSky));
        builder.put("isInWaterOrRain", this.method0(LuaOps.BOOL, Entity::m_20070_));
        builder.put("isInWaterRainOrBubble", this.method0(LuaOps.BOOL, Entity::m_20071_));
    }

    private static int getTickCount(Entity entity) {
        return entity.f_19797_;
    }

    private static void setTickCount(Entity entity, int tickCount) {
        entity.f_19797_ = tickCount;
    }

    private static boolean canSeeSky(Entity entity) {
        return entity.m_9236_().m_45527_(entity.m_20183_());
    }

    private static <T extends Entity> LuaValue valueOf(@Nullable T entity) {
        return entity == null ? LuaValue.NIL : new LuaEntity<T>(entity);
    }

    @Nullable
    private static <T extends Entity> T nilableSourceOf(LuaValue value) {
        return (T)(value.isnil() ? null : (Entity)((LuaEntity)value).getSource());
    }

    private static <T extends Entity> T nonnilSourceOf(LuaValue value) {
        return (T)((Entity)((LuaEntity)value).getSource());
    }
}

