/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum.util.color;

import com.mojang.serialization.Codec;
import dev.obscuria.fragmentum.util.color.ARGB;
import dev.obscuria.fragmentum.util.color.Colors;
import dev.obscuria.fragmentum.util.color.RGB;
import java.util.List;
import lombok.Generated;
import net.minecraft.util.Mth;

public record HSV(float hue, float saturation, float value) {
    public static final Codec<HSV> CODEC = Codec.FLOAT.listOf().xmap(Colors::hsvOf, HSV::normalized);

    public List<Float> normalized() {
        return List.of(Float.valueOf(this.hue), Float.valueOf(this.saturation), Float.valueOf(this.value));
    }

    public HSV shiftHue(float offset) {
        float newHue = (this.hue + offset) % 1.0f;
        if (newHue < 0.0f) {
            newHue += 1.0f;
        }
        return new HSV(newHue, this.saturation, this.value);
    }

    public HSV shiftSaturation(float offset) {
        float newSaturation = (this.saturation + offset) % 1.0f;
        if (newSaturation < 0.0f) {
            newSaturation += 1.0f;
        }
        return new HSV(this.hue, newSaturation, this.value);
    }

    public HSV shiftValue(float offset) {
        float newValue = (this.value + offset) % 1.0f;
        if (newValue < 0.0f) {
            newValue += 1.0f;
        }
        return new HSV(this.hue, this.saturation, newValue);
    }

    public HSV lerp(HSV to, float delta) {
        return new HSV(Mth.m_14179_((float)delta, (float)this.hue, (float)to.hue), Mth.m_14179_((float)delta, (float)this.saturation, (float)to.saturation), Mth.m_14179_((float)delta, (float)this.value, (float)to.value));
    }

    public RGB toRGB() {
        int hueSegment = (int)(this.hue * 6.0f);
        float chroma = this.value * this.saturation;
        float secondary = chroma * (1.0f - Math.abs(this.hue * 6.0f % 2.0f - 1.0f));
        float match = this.value - chroma;
        float red = 0.0f;
        float green = 0.0f;
        float blue = 0.0f;
        switch (hueSegment) {
            case 0: {
                red = chroma;
                green = secondary;
                break;
            }
            case 1: {
                red = secondary;
                green = chroma;
                break;
            }
            case 2: {
                green = chroma;
                blue = secondary;
                break;
            }
            case 3: {
                green = secondary;
                blue = chroma;
                break;
            }
            case 4: {
                red = secondary;
                blue = chroma;
                break;
            }
            case 5: 
            case 6: {
                red = chroma;
                blue = secondary;
            }
        }
        return new RGB(red + match, green + match, blue + match);
    }

    public ARGB toARGB(float alpha) {
        return this.toRGB().toARGB(alpha);
    }

    @Generated
    public HSV withHue(float hue) {
        return this.hue == hue ? this : new HSV(hue, this.saturation, this.value);
    }

    @Generated
    public HSV withSaturation(float saturation) {
        return this.saturation == saturation ? this : new HSV(this.hue, saturation, this.value);
    }

    @Generated
    public HSV withValue(float value) {
        return this.value == value ? this : new HSV(this.hue, this.saturation, value);
    }
}

