/*
 * Decompiled with CFR 0.152.
 */
package com.yablon.furnitury.block.entity;

import com.yablon.furnitury.block.entity.ModBlockEntities;
import com.yablon.furnitury.recipe.GrillRecipe;
import com.yablon.furnitury.screen.GrillMenu;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GrillBlockEntity
extends BlockEntity
implements MenuProvider {
    private final ItemStackHandler itemHandler = new ItemStackHandler(4);
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    protected final ContainerData data;
    private final int[] progress = new int[2];
    private final int maxProgress = 100;

    public GrillBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.GRILL_BLOCK_ENTITY.get(), pPos, pBlockState);
        this.data = new ContainerData(){

            public int m_6413_(int index) {
                if (index < 2) {
                    return GrillBlockEntity.this.progress[index];
                }
                if (index < 4) {
                    return 100;
                }
                return 0;
            }

            public void m_8050_(int index, int value) {
                if (index < 2) {
                    GrillBlockEntity.this.progress[index] = value;
                }
            }

            public int m_6499_() {
                return 4;
            }
        };
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        this.lazyItemHandler.invalidate();
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"Grill");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
        return new GrillMenu(id, inv, this, this.data);
    }

    protected void m_183515_(CompoundTag tag) {
        CompoundTag progressTag = new CompoundTag();
        for (int i = 0; i < 2; ++i) {
            progressTag.m_128405_("progress" + i, this.progress[i]);
        }
        tag.m_128365_("grill.progress", (Tag)progressTag);
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
    }

    public void m_142466_(CompoundTag tag) {
        CompoundTag progressTag = tag.m_128469_("grill.progress");
        for (int i = 0; i < 2; ++i) {
            this.progress[i] = progressTag.m_128451_("progress" + i);
        }
        this.itemHandler.deserializeNBT(tag.m_128469_("inventory"));
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        for (int i = 0; i < 2; ++i) {
            if (this.hasRecipe(i)) {
                int n = i;
                this.progress[n] = this.progress[n] + 1;
                if (this.progress[i] < 100) continue;
                this.craftItem(i);
                this.progress[i] = 0;
                continue;
            }
            this.progress[i] = 0;
        }
        GrillBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
    }

    private void craftItem(int index) {
        Optional<GrillRecipe> recipe = this.getCurrentRecipe(index);
        if (recipe.isEmpty()) {
            return;
        }
        ItemStack result = recipe.get().getFirstOutput();
        int inputSlot = index;
        int outputSlot = 2 + index;
        this.itemHandler.extractItem(inputSlot, 1, false);
        this.itemHandler.setStackInSlot(outputSlot, new ItemStack((ItemLike)result.m_41720_(), this.itemHandler.getStackInSlot(outputSlot).m_41613_() + result.m_41613_()));
    }

    private boolean hasRecipe(int index) {
        Optional<GrillRecipe> recipe = this.getCurrentRecipe(index);
        if (recipe.isEmpty()) {
            return false;
        }
        int outputSlot = 2 + index;
        ItemStack result = recipe.get().getFirstOutput();
        return this.canInsertAmountIntoOutputSlot(outputSlot, result.m_41613_()) && this.canInsertItemIntoOutputSlot(outputSlot, result.m_41720_());
    }

    private boolean canInsertItemIntoOutputSlot(int slot, Item item) {
        return this.itemHandler.getStackInSlot(slot).m_41619_() || this.itemHandler.getStackInSlot(slot).m_150930_(item);
    }

    private boolean canInsertAmountIntoOutputSlot(int slot, int count) {
        return this.itemHandler.getStackInSlot(slot).m_41613_() + count <= this.itemHandler.getStackInSlot(slot).m_41741_();
    }

    private Optional<GrillRecipe> getCurrentRecipe(int index) {
        SimpleContainer inventory = new SimpleContainer(1);
        inventory.m_6836_(0, this.itemHandler.getStackInSlot(index));
        return this.f_58857_.m_7465_().m_44015_((RecipeType)GrillRecipe.Type.INSTANCE, (Container)inventory, this.f_58857_);
    }
}

