/*
 * Decompiled with CFR 0.152.
 */
package alabaster.hearthandharvest.client.renderer;

import alabaster.hearthandharvest.common.block.entity.WineRackBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class WineRackRenderer
implements BlockEntityRenderer<WineRackBlockEntity> {
    private final ItemRenderer itemRenderer;

    public WineRackRenderer(BlockEntityRendererProvider.Context context) {
        this.itemRenderer = context.m_234447_();
    }

    public void render(WineRackBlockEntity rack, float pt, PoseStack pose, MultiBufferSource buf, int light, int overlay) {
        Direction facing = (Direction)rack.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
        pose.m_85836_();
        pose.m_252880_(0.5f, 0.5f, 0.5f);
        pose.m_252781_(Axis.f_252436_.m_252977_(-facing.m_122435_()));
        pose.m_252880_(-0.5f, -0.5f, -0.5f);
        for (int slot = 0; slot < 9; ++slot) {
            double px;
            ItemStack stack = rack.m_8020_(slot);
            if (stack.m_41619_()) continue;
            pose.m_85836_();
            int row = slot / 3;
            int col = slot % 3;
            double spacing = px = 0.0625;
            double slotSize = 4.0 * px;
            double baseX = spacing + (double)col * (slotSize + spacing);
            double baseY = 1.0 - (spacing + slotSize + (double)row * (slotSize + spacing));
            double baseZ = px;
            double x = baseX + 2.0 * px;
            double y = baseY + 2.0 * px;
            double z = baseZ + 10.0 * px;
            pose.m_85837_(x, y, z);
            pose.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            this.itemRenderer.m_269128_(stack, ItemDisplayContext.FIRST_PERSON_LEFT_HAND, light, overlay, pose, buf, rack.m_58904_(), 0);
            pose.m_85849_();
        }
        pose.m_85849_();
    }
}

